/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core;

import micdoodle8.mods.galacticraft.core.Constants;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.blocks.MaterialOleaginous;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.core.items.ItemBucketGC;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class GCFluids {
    public static Fluid fluidOil;
    public static Fluid fluidFuel;
    public static Fluid fluidOxygenGas;
    public static Fluid fluidHydrogenGas;
    public static Material materialOil;

    public static void registerFluids() {
        fluidOxygenGas = GCFluids.registerFluid("oxygen", 1, 13, 295, true, "oxygen_gas");
        fluidHydrogenGas = GCFluids.registerFluid("hydrogen", 1, 1, 295, true, "hydrogen_gas");
    }

    public static void registerOilandFuel() {
        String fuelID;
        String oilID = ConfigManagerCore.useOldOilFluidID ? "oilgc" : "oil";
        String string = fuelID = ConfigManagerCore.useOldFuelFluidID ? "fuelgc" : "fuel";
        if (!FluidRegistry.isFluidRegistered((String)oilID)) {
            ResourceLocation flowingOil = new ResourceLocation(Constants.TEXTURE_PREFIX + "blocks/fluids/oil_flow");
            ResourceLocation stillOil = new ResourceLocation(Constants.TEXTURE_PREFIX + "blocks/fluids/oil_still");
            Fluid gcFluidOil = new Fluid(oilID, stillOil, flowingOil).setDensity(800).setViscosity(1500);
            FluidRegistry.registerFluid((Fluid)gcFluidOil);
        } else {
            GCLog.info("Galacticraft oil is not default, issues may occur.");
        }
        fluidOil = FluidRegistry.getFluid((String)oilID);
        if (fluidOil.getBlock() == null) {
            GCBlocks.registerOil();
            fluidOil.setBlock(GCBlocks.crudeOil);
        } else {
            GCBlocks.crudeOil = fluidOil.getBlock();
        }
        if (GCBlocks.crudeOil != null && !FluidRegistry.getBucketFluids().contains(fluidOil)) {
            FluidRegistry.addBucketForFluid((Fluid)fluidOil);
            GCItems.bucketOil = new ItemBucketGC(GCBlocks.crudeOil, fluidOil);
            GCItems.bucketOil.func_77655_b("bucket_oil");
            GCItems.registerItem(GCItems.bucketOil);
            EventHandlerGC.bucketList.put(GCBlocks.crudeOil, GCItems.bucketOil);
        }
        if (!FluidRegistry.isFluidRegistered((String)fuelID)) {
            ResourceLocation flowingFuel = new ResourceLocation(Constants.TEXTURE_PREFIX + "blocks/fluids/fuel_flow");
            ResourceLocation stillFuel = new ResourceLocation(Constants.TEXTURE_PREFIX + "blocks/fluids/fuel_still");
            Fluid gcFluidFuel = new Fluid(fuelID, stillFuel, flowingFuel).setDensity(400).setViscosity(900);
            FluidRegistry.registerFluid((Fluid)gcFluidFuel);
        } else {
            GCLog.info("Galacticraft fuel is not default, issues may occur.");
        }
        fluidFuel = FluidRegistry.getFluid((String)fuelID);
        if (fluidFuel.getBlock() == null) {
            GCBlocks.registerFuel();
            fluidFuel.setBlock(GCBlocks.fuel);
        } else {
            GCBlocks.fuel = fluidFuel.getBlock();
        }
        if (GCBlocks.fuel != null && !FluidRegistry.getBucketFluids().contains(fluidFuel)) {
            FluidRegistry.addBucketForFluid((Fluid)fluidFuel);
            GCItems.bucketFuel = new ItemBucketGC(GCBlocks.fuel, fluidFuel);
            GCItems.bucketFuel.func_77655_b("bucket_fuel");
            GCItems.registerItem(GCItems.bucketFuel);
            EventHandlerGC.bucketList.put(GCBlocks.fuel, GCItems.bucketFuel);
        }
    }

    private static Fluid registerFluid(String fluidName, int density, int viscosity, int temperature, boolean gaseous, String fluidTexture) {
        Fluid returnFluid = FluidRegistry.getFluid((String)fluidName);
        if (returnFluid == null) {
            ResourceLocation texture = new ResourceLocation(Constants.TEXTURE_PREFIX + "blocks/fluids/" + fluidTexture);
            FluidRegistry.registerFluid((Fluid)new Fluid(fluidName, texture, texture).setDensity(density).setViscosity(viscosity).setTemperature(temperature).setGaseous(gaseous));
            returnFluid = FluidRegistry.getFluid((String)fluidName);
        } else {
            returnFluid.setGaseous(gaseous);
        }
        return returnFluid;
    }

    public static void registerLegacyFluids() {
        ResourceLocation flowingOil = new ResourceLocation(Constants.TEXTURE_PREFIX + "blocks/fluids/oil_flow");
        ResourceLocation flowingFuel = new ResourceLocation(Constants.TEXTURE_PREFIX + "blocks/fluids/fuel_flow");
        ResourceLocation stillOil = new ResourceLocation(Constants.TEXTURE_PREFIX + "blocks/fluids/oil_still");
        ResourceLocation stillFuel = new ResourceLocation(Constants.TEXTURE_PREFIX + "blocks/fluids/fuel_still");
        if (!FluidRegistry.isFluidRegistered((String)"oil")) {
            FluidRegistry.registerFluid((Fluid)new Fluid("oil", stillOil, flowingOil).setDensity(800).setViscosity(1500));
        }
        if (!FluidRegistry.isFluidRegistered((String)"oilgc")) {
            FluidRegistry.registerFluid((Fluid)new Fluid("oilgc", stillOil, flowingOil).setDensity(800).setViscosity(1500));
        }
        if (!FluidRegistry.isFluidRegistered((String)"fuel")) {
            FluidRegistry.registerFluid((Fluid)new Fluid("fuel", stillFuel, flowingFuel).setDensity(400).setViscosity(900));
        }
        if (!FluidRegistry.isFluidRegistered((String)"fuelgc")) {
            FluidRegistry.registerFluid((Fluid)new Fluid("fuelgc", stillFuel, flowingFuel).setDensity(400).setViscosity(900));
        }
    }

    static {
        materialOil = new MaterialOleaginous(MapColor.field_151650_B);
    }
}

