/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.dimension;

import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.planets.GCPlanetDimensions;
import micdoodle8.mods.galacticraft.planets.venus.VenusModule;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.BiomeProviderVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.ChunkProviderVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.RoomTreasureVenus;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderVenus
extends WorldProviderSpace
implements IGalacticraftWorldProvider,
ISolarLevel {
    private double solarMultiplier = -0.36;

    public Vector3 getFogColor() {
        float night = this.getStarBrightness(1.0f);
        float day = 1.0f - this.getStarBrightness(1.0f);
        float dayColR = 0.79607844f;
        float dayColG = 0.5764706f;
        float dayColB = 0.0f;
        float nightColR = 0.5137255f;
        float nightColG = 0.42352942f;
        float nightColB = 0.18039216f;
        return new Vector3((double)(dayColR * day + nightColR * night), (double)(dayColG * day + nightColG * night), (double)(dayColB * day + nightColB * night));
    }

    public Vector3 getSkyColor() {
        float night = this.getStarBrightness(1.0f);
        float day = 1.0f - this.getStarBrightness(1.0f);
        float dayColR = 1.0f;
        float dayColG = 0.8117647f;
        float dayColB = 0.31764707f;
        float nightColR = 0.4627451f;
        float nightColG = 0.34901962f;
        float nightColB = 0.08235294f;
        return new Vector3((double)(dayColR * day + nightColR * night), (double)(dayColG * day + nightColG * night), (double)(dayColB * day + nightColB * night));
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 720000L;
    }

    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderVenus.class;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        return BiomeProviderVenus.class;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(par1);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 0.75f;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 76;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public boolean func_76567_e() {
        if (EventHandlerGC.bedActivated) {
            EventHandlerGC.bedActivated = false;
            return true;
        }
        return false;
    }

    public float getGravity() {
        return 0.0375f;
    }

    public double getFuelUsageMultiplier() {
        return 0.9;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= 3;
    }

    public float getFallDamageModifier() {
        return 0.38f;
    }

    public CelestialBody getCelestialBody() {
        return VenusModule.planetVenus;
    }

    public double getSolarEnergyMultiplier() {
        if (this.solarMultiplier < 0.0) {
            double s = this.getSolarSize();
            this.solarMultiplier = s * s * s;
        }
        return this.solarMultiplier;
    }

    public boolean shouldDisablePrecipitation() {
        return true;
    }

    public DimensionType func_186058_p() {
        return GCPlanetDimensions.VENUS;
    }

    public int getDungeonSpacing() {
        return 704;
    }

    public float getArrowGravity() {
        return 0.0275f;
    }

    public ResourceLocation getDungeonChestType() {
        return RoomTreasureVenus.VENUSCHEST;
    }
}

