/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.client.render.tile;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import micdoodle8.mods.galacticraft.core.tile.ReceiverMode;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamReceiver;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityBeamReceiverRenderer
extends TileEntitySpecialRenderer<TileEntityBeamReceiver> {
    private static OBJModel.OBJBakedModel reflectorModelMain;
    private static OBJModel.OBJBakedModel reflectorModelReceiver;
    private static OBJModel.OBJBakedModel reflectorModelRing;

    private void updateModels() {
        if (reflectorModelMain == null) {
            try {
                OBJModel model = (OBJModel)ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("galacticraftplanets", "block/receiver.obj"));
                model = (OBJModel)model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                Function<ResourceLocation, TextureAtlasSprite> spriteFunction = new Function<ResourceLocation, TextureAtlasSprite>(){

                    public TextureAtlasSprite apply(ResourceLocation location) {
                        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                    }
                };
                reflectorModelMain = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Main"), false), DefaultVertexFormats.field_176599_b, (Function)spriteFunction);
                reflectorModelReceiver = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Receiver"), false), DefaultVertexFormats.field_176599_b, (Function)spriteFunction);
                reflectorModelRing = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Ring"), false), DefaultVertexFormats.field_176599_b, (Function)spriteFunction);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void renderTileEntityAt(TileEntityBeamReceiver tile, double x, double y, double z, float partialTicks, int destroyStage) {
        if (tile.facing == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
        GL11.glScalef((float)0.85f, (float)0.85f, (float)0.85f);
        switch (tile.facing) {
            case DOWN: {
                GL11.glTranslatef((float)0.7f, (float)-0.15f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case UP: {
                GL11.glTranslatef((float)-0.7f, (float)1.3f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GL11.glTranslatef((float)0.7f, (float)-0.15f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GL11.glTranslatef((float)0.0f, (float)-0.15f, (float)0.7f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glTranslatef((float)-0.7f, (float)-0.15f, (float)0.0f);
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GL11.glTranslatef((float)0.0f, (float)-0.15f, (float)-0.7f);
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            default: {
                GL11.glPopMatrix();
                return;
            }
        }
        this.updateModels();
        RenderHelper.func_74518_a();
        this.func_147499_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtil.drawBakedModel((IBakedModel)reflectorModelMain);
        int color = tile.modeReceive == ReceiverMode.RECEIVE.ordinal() ? ColorUtil.to32BitColor((int)255, (int)0, (int)204, (int)0) : (tile.modeReceive == ReceiverMode.EXTRACT.ordinal() ? ColorUtil.to32BitColor((int)255, (int)0, (int)0, (int)153) : ColorUtil.to32BitColor((int)255, (int)25, (int)25, (int)25));
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2884);
        ClientUtil.drawBakedModelColored((IBakedModel)reflectorModelReceiver, (int)color);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2884);
        float dX = 0.34772f;
        float dY = 0.75097f;
        float dZ = 0.0f;
        GL11.glTranslatef((float)dX, (float)dY, (float)dZ);
        if (tile.modeReceive != ReceiverMode.UNDEFINED.ordinal()) {
            GL11.glRotatef((float)(-tile.ticks * 50), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glTranslatef((float)(-dX), (float)(-dY), (float)(-dZ));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtil.drawBakedModel((IBakedModel)reflectorModelRing);
        RenderHelper.func_74519_b();
        GL11.glPopMatrix();
    }
}

