/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IGridNetwork;
import micdoodle8.mods.galacticraft.api.transmission.grid.IOxygenNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.IBufferTransmitter;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.transmission.tile.ITransmitter;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.blocks.BlockFluidPipe;
import micdoodle8.mods.galacticraft.core.fluid.FluidNetwork;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityFluidTransmitter
extends TileEntityAdvanced
implements IBufferTransmitter<FluidStack>,
IFluidHandlerWrapper {
    private IGridNetwork network;
    public TileEntity[] adjacentConnections = null;
    private int pullAmount;
    private boolean validated = true;

    public TileEntityFluidTransmitter(int pullAmount) {
        this.pullAmount = pullAmount;
    }

    public void func_145829_t() {
        this.validated = false;
        super.func_145829_t();
    }

    public void func_145843_s() {
        if (!BlockFluidPipe.ignoreDrop) {
            this.getNetwork().split(this);
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        super.func_145843_s();
        super.onChunkUnload();
    }

    @Override
    public IGridNetwork getNetwork() {
        if (this.network == null) {
            this.resetNetwork();
        }
        return this.network;
    }

    @Override
    public boolean hasNetwork() {
        return this.network != null;
    }

    @Override
    public void onNetworkChanged() {
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            Block blockType;
            if (!this.validated) {
                TickHandlerServer.oxygenTransmitterUpdates.add(this);
                this.validated = true;
            }
            if ((blockType = this.func_145838_q()) instanceof BlockFluidPipe && ((BlockFluidPipe)blockType).getMode() == BlockFluidPipe.EnumPipeMode.PULL) {
                TileEntity[] tiles = OxygenUtil.getAdjacentFluidConnections(this);
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    FluidStack received;
                    IFluidHandler handler;
                    TileEntity sideTile = tiles[side.ordinal()];
                    if (sideTile == null || sideTile instanceof IBufferTransmitter || (handler = (IFluidHandler)sideTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) == null || (received = handler.drain(this.pullAmount, false)) == null || received.amount == 0) continue;
                    handler.drain(this.fill(EnumFacing.DOWN, received, true), true);
                }
            }
        }
        super.func_73660_a();
    }

    protected void resetNetwork() {
        FluidNetwork network = new FluidNetwork();
        network.addTransmitter(this);
        network.register();
        this.setNetwork(network);
    }

    @Override
    public void setNetwork(IGridNetwork network) {
        if (this.network == network) {
            return;
        }
        if (this.field_145850_b.field_72995_K && this.network != null) {
            FluidNetwork fluidNetwork = (FluidNetwork)this.network;
            fluidNetwork.removeTransmitter(this);
            if (fluidNetwork.getTransmitters().isEmpty()) {
                fluidNetwork.unregister();
            }
        }
        this.network = network;
        if (this.field_145850_b.field_72995_K && this.network != null) {
            ((FluidNetwork)this.network).pipes.add(this);
        }
    }

    @Override
    public void refresh() {
        if (!this.field_145850_b.field_72995_K) {
            this.adjacentConnections = null;
            for (EnumFacing side : EnumFacing.values()) {
                TileEntity tileEntity = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, side);
                if (tileEntity == null || tileEntity.getClass() != this.getClass() || !(tileEntity instanceof INetworkProvider) || !((INetworkProvider)tileEntity).hasNetwork() || tileEntity instanceof ITransmitter && !((ITransmitter)tileEntity).canConnect(side.func_176734_d(), ((ITransmitter)tileEntity).getNetworkType())) continue;
                if (!this.hasNetwork()) {
                    this.setNetwork(((INetworkProvider)tileEntity).getNetwork());
                    ((FluidNetwork)this.getNetwork()).addTransmitter(this);
                    ((FluidNetwork)this.getNetwork()).onTransmitterAdded(this);
                    continue;
                }
                if (!this.hasNetwork() || this.getNetwork().equals(((INetworkProvider)tileEntity).getNetwork())) continue;
                this.setNetwork(this.getNetwork().merge(((INetworkProvider)tileEntity).getNetwork()));
            }
            this.getNetwork().refresh();
        }
    }

    @Override
    public TileEntity[] getAdjacentConnections() {
        if (this.adjacentConnections == null) {
            this.adjacentConnections = OxygenUtil.getAdjacentFluidConnections(this, this.field_145850_b.field_72995_K);
        }
        return this.adjacentConnections;
    }

    @Override
    public boolean canConnect(EnumFacing direction, NetworkType type) {
        return type == NetworkType.FLUID;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    @Override
    public NetworkType getNetworkType() {
        return NetworkType.FLUID;
    }

    @Override
    public double getPacketRange() {
        return 0.0;
    }

    @Override
    public int getPacketCooldown() {
        return 0;
    }

    @Override
    public boolean isNetworkedTile() {
        return false;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (!stack.getGas().getName().equals("oxygen")) {
            return 0;
        }
        return stack.amount - (int)Math.floor(((IOxygenNetwork)this.getNetwork()).produce(stack.amount, this));
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public int receiveGas(EnumFacing side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public GasStack drawGas(EnumFacing side, int amount) {
        return null;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return type.getName().equals("oxygen");
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.ITubeConnection", modID="mekanism")
    public boolean canTubeConnect(EnumFacing side) {
        return this.canConnect(side, NetworkType.FLUID);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper(this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }
}

