/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachineTiered;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityElectricFurnace
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IMachineSides {
    public static int PROCESS_TIME_REQUIRED = 130;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired = PROCESS_TIME_REQUIRED;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    public final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    private boolean initialised = true;
    private IMachineSides.MachineSidePack[] machineSides;

    public TileEntityElectricFurnace() {
        this(1);
    }

    public TileEntityElectricFurnace(int tier) {
        if (tier == 1) {
            this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 60.0f : 45.0f);
            return;
        }
        this.setTier2();
    }

    private void setTier2() {
        this.storage.setCapacity(25000.0f);
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 60.0f);
        this.processTimeRequired = 100;
        this.setTierGC(2);
    }

    @Override
    public void func_73660_a() {
        if (!this.initialised) {
            int metadata = this.func_145832_p();
            Block b = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c();
            if (b == GCBlocks.machineBase) {
                this.field_145850_b.func_180501_a(this.func_174877_v(), GCBlocks.machineTiered.func_176223_P(), 2);
            } else if (metadata >= 8) {
                this.setTier2();
            }
            this.initialised = true;
        }
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.canProcess()) {
                if (this.hasEnoughEnergyToRun) {
                    if (this.tierGC == 2) {
                        this.processTimeRequired = 200 / (1 + this.poweredByTierGC);
                    }
                    if (this.processTicks == 0) {
                        this.processTicks = this.processTimeRequired;
                    } else if (--this.processTicks <= 0) {
                        this.smeltItem();
                        this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                    }
                } else if (this.processTicks > 0 && this.processTicks < this.processTimeRequired && this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    ++this.processTicks;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    public boolean canProcess() {
        if (((ItemStack)this.stacks.get(1)).func_190926_b() || FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.stacks.get(1)).func_190926_b()) {
            return false;
        }
        if (!((ItemStack)this.stacks.get(2)).func_190926_b()) {
            if (!((ItemStack)this.stacks.get(2)).func_77969_a(FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.stacks.get(1)))) {
                return false;
            }
            if (((ItemStack)this.stacks.get(2)).func_190916_E() > 63) {
                return false;
            }
        }
        return true;
    }

    public void smeltItem() {
        if (this.canProcess()) {
            ItemStack resultItemStack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.stacks.get(1));
            if (((ItemStack)this.stacks.get(2)).func_190926_b()) {
                this.stacks.set(2, (Object)resultItemStack.func_77946_l());
                if (this.tierGC > 1) {
                    String nameSmelted = ((ItemStack)this.stacks.get(1)).func_77977_a().toLowerCase();
                    if (resultItemStack.func_77977_a().toLowerCase().contains("ingot") && (nameSmelted.contains("ore") || nameSmelted.contains("raw") || nameSmelted.contains("moon") || nameSmelted.contains("mars") || nameSmelted.contains("shard"))) {
                        ((ItemStack)this.stacks.get(2)).func_190917_f(resultItemStack.func_190916_E());
                    }
                }
            } else if (((ItemStack)this.stacks.get(2)).func_77969_a(resultItemStack)) {
                ((ItemStack)this.stacks.get(2)).func_190917_f(resultItemStack.func_190916_E());
                if (this.tierGC > 1) {
                    String nameSmelted = ((ItemStack)this.stacks.get(1)).func_77977_a().toLowerCase();
                    if (resultItemStack.func_77977_a().toLowerCase().contains("ingot") && (nameSmelted.contains("ore") || nameSmelted.contains("raw") || nameSmelted.contains("moon") || nameSmelted.contains("mars") || nameSmelted.contains("shard"))) {
                        ((ItemStack)this.stacks.get(2)).func_190917_f(resultItemStack.func_190916_E());
                    }
                }
            }
            ((ItemStack)this.stacks.get(1)).func_190918_g(1);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.storage.getEnergyStoredGC() > 16000.0f) {
            this.setTier2();
            this.initialised = true;
        } else {
            this.initialised = false;
        }
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        this.stacks = this.readStandardItemsFromNBT(nbt);
        this.readMachineSidesFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.tierGC == 1 && this.storage.getEnergyStoredGC() > 16000.0f) {
            this.storage.setEnergyStored(16000.0f);
        }
        super.func_189515_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(nbt, this.stacks);
        this.addMachineSidesToNBT(nbt);
        return nbt;
    }

    @Override
    protected NonNullList<ItemStack> getContainingItems() {
        return this.stacks;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate(this.tierGC == 1 ? "tile.machine.2.name" : "tile.machine.7.name");
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        return slotID == 1 ? !FurnaceRecipes.func_77602_a().func_151395_a(itemStack).func_190926_b() : slotID == 0 && ItemElectricBase.isElectricItem(itemStack.func_77973_b());
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_180461_b(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return slotID == 2;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public ITextComponent func_145748_c_() {
        return null;
    }

    @Override
    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockMachineTiered) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockMachineTiered.FACING);
        }
        return EnumFacing.NORTH;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        switch (this.getSide(IMachineSides.MachineSide.ELECTRIC_IN)) {
            case RIGHT: {
                return this.getFront().func_176735_f();
            }
            case REAR: {
                return this.getFront().func_176734_d();
            }
            case TOP: {
                return EnumFacing.UP;
            }
            case BOTTOM: {
                return EnumFacing.DOWN;
            }
        }
        return this.getFront().func_176746_e();
    }

    @Override
    public IMachineSides.MachineSide[] listConfigurableSides() {
        return new IMachineSides.MachineSide[]{IMachineSides.MachineSide.ELECTRIC_IN};
    }

    @Override
    public IMachineSides.Face[] listDefaultFaces() {
        return new IMachineSides.Face[]{IMachineSides.Face.LEFT};
    }

    @Override
    public IMachineSides.MachineSidePack[] getAllMachineSides() {
        if (this.machineSides == null) {
            this.initialiseSides();
        }
        return this.machineSides;
    }

    @Override
    public void setupMachineSides(int length) {
        this.machineSides = new IMachineSides.MachineSidePack[length];
    }

    public void onLoad() {
        this.clientOnLoad();
    }

    @Override
    public IMachineSidesProperties getConfigurationType() {
        return BlockMachineTiered.MACHINESIDES_RENDERTYPE;
    }
}

