/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.recipe.CircuitFabricatorRecipes;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachine2;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityCircuitFabricator
extends TileBaseElectricBlockWithInventory
implements ISidedInventory {
    public static final int PROCESS_TIME_REQUIRED = 300;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack producingStack = ItemStack.field_190927_a;
    private long ticks;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)7, (Object)ItemStack.field_190927_a);

    public TileEntityCircuitFabricator() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 40.0f : 20.0f);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.updateInput();
        if (!this.field_145850_b.field_72995_K) {
            boolean updateInv = false;
            if (this.hasEnoughEnergyToRun) {
                if (this.canCompress()) {
                    ++this.processTicks;
                    if (this.processTicks >= this.getProcessTimeRequired()) {
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.3f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
                        this.processTicks = 0;
                        this.compressItems();
                        updateInv = true;
                    }
                } else {
                    this.processTicks = 0;
                }
            } else {
                this.processTicks = 0;
            }
            if (updateInv) {
                this.func_70296_d();
            }
        }
        ++this.ticks;
    }

    public int getProcessTimeRequired() {
        return 600 / (1 + this.poweredByTierGC);
    }

    public void updateInput() {
        this.producingStack = CircuitFabricatorRecipes.getOutputForInput(this.stacks.subList(1, 6));
    }

    private boolean canCompress() {
        if (this.producingStack.func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.stacks.get(6)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.stacks.get(6)).func_190926_b() && !((ItemStack)this.stacks.get(6)).func_77969_a(this.producingStack)) {
            return false;
        }
        int result = ((ItemStack)this.stacks.get(6)).func_190926_b() ? 0 : ((ItemStack)this.stacks.get(6)).func_190916_E() + this.producingStack.func_190916_E();
        return result <= this.func_70297_j_() && result <= this.producingStack.func_77976_d();
    }

    public void compressItems() {
        if (this.canCompress()) {
            ItemStack resultItemStack = this.producingStack.func_77946_l();
            if (ConfigManagerCore.quickMode && resultItemStack.func_77973_b() == GCItems.basicItem) {
                if (resultItemStack.func_77952_i() == 13) {
                    resultItemStack.func_190920_e(5);
                } else if (resultItemStack.func_77952_i() == 14) {
                    resultItemStack.func_190920_e(2);
                }
            }
            if (((ItemStack)this.stacks.get(6)).func_190926_b()) {
                this.stacks.set(6, (Object)resultItemStack);
            } else if (((ItemStack)this.stacks.get(6)).func_77969_a(resultItemStack)) {
                if (((ItemStack)this.stacks.get(6)).func_190916_E() + resultItemStack.func_190916_E() > 64) {
                    for (int i = 0; i < ((ItemStack)this.stacks.get(6)).func_190916_E() + resultItemStack.func_190916_E() - 64; ++i) {
                        float var = 0.7f;
                        double dx = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                        double dy = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                        double dz = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + dx, (double)this.func_174877_v().func_177956_o() + dy, (double)this.func_174877_v().func_177952_p() + dz, new ItemStack(resultItemStack.func_77973_b(), 1, resultItemStack.func_77952_i()));
                        entityitem.func_174867_a(10);
                        this.field_145850_b.func_72838_d((Entity)entityitem);
                    }
                    ((ItemStack)this.stacks.get(6)).func_190920_e(64);
                } else {
                    ((ItemStack)this.stacks.get(6)).func_190917_f(resultItemStack.func_190916_E());
                }
            }
        }
        for (int i = 1; i < 6; ++i) {
            this.func_70298_a(i, 1);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        this.stacks = this.readStandardItemsFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(nbt, this.stacks);
        return nbt;
    }

    @Override
    protected NonNullList<ItemStack> getContainingItems() {
        return this.stacks;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate("tile.machine2.5.name");
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public ITextComponent func_145748_c_() {
        return null;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 0) {
            return itemStack != null && ItemElectricBase.isElectricItem(itemStack.func_77973_b());
        }
        if (slotID > 5) {
            return false;
        }
        ArrayList<ItemStack> list = CircuitFabricatorRecipes.slotValidItems.get(slotID - 1);
        for (ItemStack test : list) {
            if (!test.func_77969_a(itemStack)) continue;
            return true;
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        boolean siliconFlag;
        if (side == EnumFacing.UP) {
            return new int[]{6};
        }
        boolean bl = siliconFlag = !((ItemStack)this.stacks.get(2)).func_190926_b() && (((ItemStack)this.stacks.get(3)).func_190926_b() || ((ItemStack)this.stacks.get(3)).func_190916_E() < ((ItemStack)this.stacks.get(2)).func_190916_E());
        if (siliconFlag) {
            int[] nArray2 = new int[5];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 3;
            nArray2[3] = 4;
            nArray = nArray2;
            nArray2[4] = 5;
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray3[3] = 4;
            nArray = nArray3;
            nArray3[4] = 5;
        }
        return nArray;
    }

    public boolean func_180462_a(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return slotID < 6 && this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_180461_b(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return slotID == 6;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.processTicks > 0;
    }

    @Override
    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockMachine2) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockMachine2.FACING);
        }
        return EnumFacing.NORTH;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        return this.getFront().func_176746_e();
    }
}

