/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.blocks.BlockCargoLoader;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityCargoUnloader
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
ILandingPadAttachable {
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)15, (Object)ItemStack.field_190927_a);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean targetEmpty;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean targetNoInventory;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean noTarget;
    public ICargoEntity attachedFuelable;

    public TileEntityCargoUnloader() {
        this.storage.setMaxExtract(45.0f);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticks % 100 == 0) {
                this.checkForCargoEntity();
            }
            if (this.attachedFuelable != null) {
                this.noTarget = false;
                ICargoEntity.RemovalResult result = this.attachedFuelable.removeCargo(false);
                if (!result.resultStack.func_190926_b()) {
                    this.targetEmpty = false;
                    ICargoEntity.EnumCargoLoadingState state = this.addCargo(result.resultStack, false);
                    this.targetEmpty = state == ICargoEntity.EnumCargoLoadingState.EMPTY;
                    if (this.ticks % (this.poweredByTierGC > 1 ? 9 : 15) == 0 && state == ICargoEntity.EnumCargoLoadingState.SUCCESS && !this.disabled && this.hasEnoughEnergyToRun) {
                        this.addCargo(this.attachedFuelable.removeCargo((boolean)true).resultStack, true);
                    }
                } else {
                    this.targetNoInventory = result.resultState == ICargoEntity.EnumCargoLoadingState.NOINVENTORY;
                    this.noTarget = result.resultState == ICargoEntity.EnumCargoLoadingState.NOTARGET;
                    this.targetEmpty = true;
                }
            } else {
                this.noTarget = true;
            }
        }
    }

    public void checkForCargoEntity() {
        boolean foundFuelable = false;
        for (EnumFacing dir : EnumFacing.values()) {
            TileEntity pad = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, dir);
            if (pad != null && pad instanceof TileEntityMulti) {
                TileEntity mainTile = ((TileEntityMulti)pad).getMainBlockTile();
                if (!(mainTile instanceof ICargoEntity)) continue;
                this.attachedFuelable = (ICargoEntity)mainTile;
                foundFuelable = true;
                break;
            }
            if (pad == null || !(pad instanceof ICargoEntity)) continue;
            this.attachedFuelable = (ICargoEntity)pad;
            foundFuelable = true;
            break;
        }
        if (!foundFuelable) {
            this.attachedFuelable = null;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.stacks = this.readStandardItemsFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeStandardItemsToNBT(nbt, this.stacks);
        return nbt;
    }

    @Override
    protected NonNullList<ItemStack> getContainingItems() {
        return this.stacks;
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public ITextComponent func_145748_c_() {
        return null;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate("container.cargounloader.name");
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side != this.getElectricInputDirection()) {
            int[] nArray2 = new int[14];
            nArray2[0] = 1;
            nArray2[1] = 2;
            nArray2[2] = 3;
            nArray2[3] = 4;
            nArray2[4] = 5;
            nArray2[5] = 6;
            nArray2[6] = 7;
            nArray2[7] = 8;
            nArray2[8] = 9;
            nArray2[9] = 10;
            nArray2[10] = 11;
            nArray2[11] = 12;
            nArray2[12] = 13;
            nArray = nArray2;
            nArray2[13] = 14;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (side != this.getElectricInputDirection()) {
            if (slotID == 0) {
                return ItemElectricBase.isElectricItem(itemstack.func_77973_b());
            }
            return true;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return ItemElectricBase.isElectricItem(itemstack.func_77973_b());
        }
        return true;
    }

    @Override
    public boolean shouldUseEnergy() {
        return !this.getDisabled(0);
    }

    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        ItemStack stackAt;
        int count = 1;
        for (count = 1; count < this.stacks.size(); ++count) {
            stackAt = (ItemStack)this.stacks.get(count);
            if (stackAt.func_190926_b() || stackAt.func_77973_b() != stack.func_77973_b() || stackAt.func_77952_i() != stack.func_77952_i() || stackAt.func_190916_E() >= stackAt.func_77976_d()) continue;
            if (stackAt.func_190916_E() + stack.func_190916_E() <= stackAt.func_77976_d()) {
                if (doAdd) {
                    stackAt.func_190917_f(stack.func_190916_E());
                    this.func_70296_d();
                }
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            int origSize = stackAt.func_190916_E();
            int surplus = origSize + stack.func_190916_E() - stackAt.func_77976_d();
            if (doAdd) {
                stackAt.func_190920_e(stackAt.func_77976_d());
                this.func_70296_d();
            }
            stack.func_190920_e(surplus);
            if (this.addCargo(stack, doAdd) == ICargoEntity.EnumCargoLoadingState.SUCCESS) {
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            stackAt.func_190920_e(origSize);
            return ICargoEntity.EnumCargoLoadingState.FULL;
        }
        for (count = 1; count < this.stacks.size(); ++count) {
            stackAt = (ItemStack)this.stacks.get(count);
            if (!stackAt.func_190926_b()) continue;
            if (doAdd) {
                this.stacks.set(count, (Object)stack);
                this.func_70296_d();
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        return ICargoEntity.EnumCargoLoadingState.FULL;
    }

    @Override
    public boolean canAttachToLandingPad(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockCargoLoader) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockCargoLoader.FACING);
        }
        return EnumFacing.NORTH;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        return this.getFront().func_176746_e();
    }
}

