/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import micdoodle8.mods.galacticraft.api.tile.ITileClientUpdates;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityArclamp
extends TileEntity
implements ITickable,
ITileClientUpdates,
IPacketReceiver {
    private static final int LIGHTRANGE = 14;
    private int ticks = 0;
    private int sideRear = 0;
    public int facing = 0;
    private HashSet<BlockVec3> airToRestore = new HashSet();
    private intBucket[] buckets;
    private static intBucket[] bucketsServer;
    private static intBucket[] bucketsClient;
    private static AtomicBoolean usingBucketsServer;
    private static AtomicBoolean usingBucketsClient;
    private AtomicBoolean usingBuckets;
    private static final int SIZELIST = 65536;
    private int[] lightUpdateBlockList;
    private static int[] lightUpdateBlockListServer;
    private static int[] lightUpdateBlockListClient;
    private static AtomicBoolean usingLightListServer;
    private static AtomicBoolean usingLightListClient;
    private AtomicBoolean usingLightList;
    private boolean isActive = false;
    private AxisAlignedBB thisAABB;
    private AxisAlignedBB renderAABB;
    private Vec3d thisPos;
    private int facingSide = 0;

    public void func_73660_a() {
        boolean initialLight = false;
        if (RedstoneUtil.isBlockReceivingRedstone(this.field_145850_b, this.func_174877_v())) {
            if (this.isActive) {
                this.isActive = false;
                this.revertAir();
                this.func_70296_d();
            }
        } else if (!this.isActive && this.field_174879_c.func_177958_n() >= -29999968 && this.field_174879_c.func_177952_p() >= -29999968 && this.field_174879_c.func_177958_n() < 29999968 && this.field_174879_c.func_177952_p() < 29999968) {
            this.isActive = true;
            initialLight = true;
        }
        if (this.isActive) {
            List moblist;
            if (this.thisAABB == null) {
                initialLight = true;
                int side = this.func_145832_p();
                switch (side) {
                    case 0: {
                        this.sideRear = side;
                        this.facingSide = this.facing + 2;
                        break;
                    }
                    case 1: {
                        this.sideRear = side;
                        this.facingSide = this.facing + 2;
                        break;
                    }
                    case 2: {
                        this.sideRear = side;
                        this.facingSide = this.facing;
                        if (this.facing <= 1) break;
                        this.facingSide = 7 - this.facing;
                        break;
                    }
                    case 3: {
                        this.sideRear = side;
                        this.facingSide = this.facing;
                        if (this.facing <= 1) break;
                        this.facingSide += 2;
                        break;
                    }
                    case 4: {
                        this.sideRear = side;
                        this.facingSide = this.facing;
                        break;
                    }
                    case 5: {
                        this.sideRear = side;
                        this.facingSide = this.facing;
                        if (this.facing <= 1) break;
                        this.facingSide = 5 - this.facing;
                        break;
                    }
                }
                this.thisAABB = this.getAABBforSideAndFacing();
            }
            if (initialLight || this.ticks % 100 == 0) {
                this.lightArea();
            }
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextInt(10) == 0 && !(moblist = this.field_145850_b.func_175674_a(null, this.thisAABB, IMob.field_82192_a)).isEmpty()) {
                Vec3d thisVec3 = new Vec3d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
                for (Entity entry : moblist) {
                    double distanceCurrent;
                    double distanceNew;
                    Vec3d vecNewTarget;
                    EntityCreature mob;
                    PathNavigate nav;
                    if (!(entry instanceof EntityCreature) || (nav = (mob = (EntityCreature)entry).func_70661_as()) == null || (vecNewTarget = RandomPositionGenerator.func_75461_b((EntityCreature)mob, (int)28, (int)11, (Vec3d)this.thisPos)) == null || !((distanceNew = vecNewTarget.func_72438_d(thisVec3)) > (distanceCurrent = thisVec3.func_72436_e(new Vec3d(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v))))) continue;
                    Vec3d vecOldTarget = null;
                    if (nav.func_75505_d() != null && !nav.func_75505_d().func_75879_b()) {
                        vecOldTarget = nav.func_75505_d().func_75878_a((Entity)mob);
                    }
                    if (vecOldTarget != null && !(distanceCurrent > vecOldTarget.func_72436_e(thisVec3))) continue;
                    nav.func_75492_a(vecNewTarget.field_72450_a, vecNewTarget.field_72448_b, vecNewTarget.field_72449_c, 1.3);
                }
            }
        }
        ++this.ticks;
    }

    private AxisAlignedBB getAABBforSideAndFacing() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        int[] rangeForSide = new int[6];
        for (int i = 0; i < 6; ++i) {
            rangeForSide[i] = i == this.sideRear ? 2 : (i == (this.facingSide ^ 1) ? 4 : 25);
        }
        return new AxisAlignedBB((double)(x - rangeForSide[4]), (double)(y - rangeForSide[0]), (double)(z - rangeForSide[2]), (double)(x + rangeForSide[5]), (double)(y + rangeForSide[1]), (double)(z + rangeForSide[3]));
    }

    public void onLoad() {
        this.thisPos = new Vec3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        this.ticks = 0;
        this.thisAABB = null;
        if (this.field_145850_b.field_72995_K) {
            this.buckets = bucketsClient;
            this.usingBuckets = usingBucketsClient;
            if (lightUpdateBlockListClient == null) {
                lightUpdateBlockListClient = new int[65536];
            }
            this.lightUpdateBlockList = lightUpdateBlockListClient;
            this.usingLightList = usingLightListClient;
            this.clientOnLoad();
            GalacticraftCore.packetPipeline.sendToServer(new PacketDynamic(this));
        } else {
            this.buckets = bucketsServer;
            this.usingBuckets = usingBucketsServer;
            if (lightUpdateBlockListServer == null) {
                lightUpdateBlockListServer = new int[65536];
            }
            this.lightUpdateBlockList = lightUpdateBlockListServer;
            this.usingLightList = usingLightListServer;
            this.isActive = this.field_174879_c.func_177958_n() >= -29999968 && this.field_174879_c.func_177952_p() >= -29999968 && this.field_174879_c.func_177958_n() < 29999968 && this.field_174879_c.func_177952_p() < 29999968;
        }
    }

    public void func_145843_s() {
        this.revertAir();
        this.isActive = false;
        super.func_145843_s();
    }

    public void lightArea() {
        IBlockState iBlockState;
        IBlockState iBlockState2;
        if (this.usingBuckets.getAndSet(true) || this.usingLightList.getAndSet(true)) {
            return;
        }
        int index = 0;
        Block air = Blocks.field_150350_a;
        Block breatheableAirID = GCBlocks.breatheableAir;
        IBlockState brightAir = GCBlocks.brightAir.func_176223_P();
        IBlockState brightBreatheableAir = GCBlocks.brightBreatheableAir.func_176223_P();
        boolean dirty = false;
        this.checkedClear();
        HashSet<BlockVec3> airToRevert = new HashSet<BlockVec3>();
        airToRevert.addAll(this.airToRestore);
        LinkedList<BlockVec3> airNew = new LinkedList<BlockVec3>();
        LinkedList<BlockVec3> currentLayer = new LinkedList<BlockVec3>();
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        BlockVec3 thisvec = new BlockVec3(this);
        currentLayer.add(thisvec);
        World world = this.field_145850_b;
        int sideskip1 = this.sideRear;
        int sideskip2 = this.facingSide ^ 1;
        for (int i = 0; i < 6; ++i) {
            BlockVec3 onEitherSide;
            IBlockState iBlockState3;
            if (i == sideskip1 || i == sideskip2 || i == (sideskip1 ^ 1) || i == (sideskip2 ^ 1) || (iBlockState3 = (onEitherSide = thisvec.newVecSide(i)).getBlockStateSafe_noChunkLoad(world)).func_177230_c().func_149717_k(iBlockState3) >= 15) continue;
            currentLayer.add(onEitherSide);
        }
        BlockVec3 inFront = new BlockVec3(this);
        for (int i = 0; i < 4 && (iBlockState2 = (inFront = inFront.newVecSide(this.facingSide)).getBlockStateSafe_noChunkLoad(world)).func_177230_c().func_149717_k(iBlockState2) != 15 && (iBlockState = (inFront = inFront.newVecSide(sideskip1 ^ 1)).getBlockStateSafe_noChunkLoad(world)).func_177230_c().func_149717_k(iBlockState) < 15; ++i) {
            currentLayer.add(inFront);
        }
        inFront = new BlockVec3(this).newVecSide(this.facingSide);
        for (int count = 0; count < 14; ++count) {
            for (BlockVec3 vec : currentLayer) {
                if (count > 1) {
                    int offset = 0;
                    switch (this.facingSide) {
                        case 0: {
                            offset = inFront.y - vec.y;
                            break;
                        }
                        case 1: {
                            offset = vec.y - inFront.y;
                            break;
                        }
                        case 2: {
                            offset = inFront.z - vec.z;
                            break;
                        }
                        case 3: {
                            offset = vec.z - inFront.z;
                            break;
                        }
                        case 4: {
                            offset = inFront.x - vec.x;
                            break;
                        }
                        case 5: {
                            offset = vec.x - inFront.x;
                        }
                    }
                    int offset2 = 0;
                    switch (this.sideRear ^ 1) {
                        case 0: {
                            offset2 = inFront.y - vec.y;
                            break;
                        }
                        case 1: {
                            offset2 = vec.y - inFront.y;
                            break;
                        }
                        case 2: {
                            offset2 = inFront.z - vec.z;
                            break;
                        }
                        case 3: {
                            offset2 = vec.z - inFront.z;
                            break;
                        }
                        case 4: {
                            offset2 = inFront.x - vec.x;
                            break;
                        }
                        case 5: {
                            offset2 = vec.x - inFront.x;
                        }
                    }
                    if (offset2 - 2 > offset) {
                        offset = offset2 - 2;
                    }
                    if (Math.abs(vec.x - inFront.x) > offset + 2 || Math.abs(vec.y - inFront.y) > offset + 2 || Math.abs(vec.z - inFront.z) > offset + 2) continue;
                }
                int side = 0;
                int bits = vec.sideDoneBits;
                boolean doShine = false;
                do {
                    IBlockState bs;
                    Block b;
                    if ((bits & 1 << side) != 0) continue;
                    BlockVec3 sideVec = vec.newVecSide(side);
                    boolean toAdd = false;
                    if (!this.checkedContains(vec, side)) {
                        this.checkedAdd(sideVec);
                        toAdd = true;
                    }
                    if ((b = (bs = sideVec.getBlockStateSafe_noChunkLoad(world)).func_177230_c()) instanceof BlockAir) {
                        if (!toAdd || side == sideskip1 || side == sideskip2) continue;
                        nextLayer.add(sideVec);
                        continue;
                    }
                    doShine = true;
                    if (side == sideskip1 || side == sideskip2 || !toAdd || b == null || b.getLightOpacity(bs, (IBlockAccess)world, sideVec.toBlockPos()) != 0) continue;
                    nextLayer.add(sideVec);
                } while (++side < 6);
                if (!doShine) continue;
                airNew.add(vec);
                Block id = vec.getBlockStateSafe_noChunkLoad(world).func_177230_c();
                if (Blocks.field_150350_a == id) {
                    this.brightenAir(world, vec, brightAir);
                    index = this.checkLightPartA(EnumSkyBlock.BLOCK, vec.toBlockPos(), index);
                    dirty = true;
                    continue;
                }
                if (id != breatheableAirID) continue;
                this.brightenAir(world, vec, brightBreatheableAir);
                index = this.checkLightPartA(EnumSkyBlock.BLOCK, vec.toBlockPos(), index);
                dirty = true;
            }
            if (nextLayer.size() == 0) break;
            currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
        if (dirty) {
            this.func_70296_d();
            this.checkLightPartB(EnumSkyBlock.BLOCK, index);
        }
        airToRevert.removeAll(airNew);
        index = 0;
        dirty = false;
        for (Object e : airToRevert) {
            BlockVec3 vec;
            vec = (BlockVec3)e;
            this.setDarkerAir(vec);
            index = this.checkLightPartA(EnumSkyBlock.BLOCK, vec.toBlockPos(), index);
            this.airToRestore.remove(vec);
            dirty = true;
        }
        if (dirty) {
            this.func_70296_d();
            this.checkLightPartB(EnumSkyBlock.BLOCK, index);
        }
        this.usingBuckets.set(false);
        this.usingLightList.set(false);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.facing = nbt.func_74762_e("Facing");
        this.airToRestore.clear();
        NBTTagList airBlocks = nbt.func_150295_c("AirBlocks", 10);
        if (airBlocks.func_74745_c() > 0) {
            for (int j = airBlocks.func_74745_c() - 1; j >= 0; --j) {
                NBTTagCompound tag1 = airBlocks.func_150305_b(j);
                if (tag1 == null) continue;
                this.airToRestore.add(BlockVec3.readFromNBT(tag1));
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Facing", this.facing);
        NBTTagList airBlocks = new NBTTagList();
        for (BlockVec3 vec : this.airToRestore) {
            NBTTagCompound tag = new NBTTagCompound();
            vec.writeToNBT(tag);
            airBlocks.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("AirBlocks", (NBTBase)airBlocks);
        return nbt;
    }

    public void facingChanged() {
        this.facing -= 2;
        if (this.facing < 0) {
            this.facing = 1 - this.facing;
        }
        this.updateAllInDimension();
        this.thisAABB = null;
        this.revertAir();
        this.func_70296_d();
        this.ticks = 91;
    }

    private void brightenAir(World world, BlockVec3 vec, IBlockState newState) {
        BlockPos blockpos = vec.toBlockPos();
        Chunk chunk = this.field_145850_b.func_175726_f(blockpos);
        IBlockState oldState = chunk.func_177436_a(blockpos, newState);
        if (this.field_145850_b.field_72995_K && oldState != null) {
            this.field_145850_b.markAndNotifyBlock(blockpos, chunk, oldState, newState, 2);
        }
        this.airToRestore.add(vec);
    }

    private void setDarkerAir(BlockVec3 vec) {
        IBlockState newState;
        BlockPos blockpos = vec.toBlockPos();
        Block b = this.field_145850_b.func_180495_p(blockpos).func_177230_c();
        if (b == GCBlocks.brightAir) {
            newState = Blocks.field_150350_a.func_176223_P();
        } else if (b == GCBlocks.brightBreatheableAir) {
            newState = GCBlocks.breatheableAir.func_176223_P();
        } else {
            return;
        }
        Chunk chunk = this.field_145850_b.func_175726_f(blockpos);
        IBlockState oldState = chunk.func_177436_a(blockpos, newState);
        if (this.field_145850_b.field_72995_K && oldState != null) {
            this.field_145850_b.markAndNotifyBlock(blockpos, chunk, oldState, newState, 2);
        }
    }

    private void revertAir() {
        int index = 0;
        for (BlockVec3 vec : this.airToRestore) {
            this.setDarkerAir(vec);
        }
        if (!this.usingLightList.getAndSet(true)) {
            for (BlockVec3 vec : this.airToRestore) {
                index = this.checkLightPartA(EnumSkyBlock.BLOCK, vec.toBlockPos(), index);
            }
            this.checkLightPartB(EnumSkyBlock.BLOCK, index);
            this.usingLightList.set(false);
        }
        this.airToRestore.clear();
        this.checkLightFor(EnumSkyBlock.BLOCK, this.field_174879_c);
    }

    public boolean checkLightFor(EnumSkyBlock lightType, BlockPos bp) {
        int range;
        BlockPos blockpos;
        int zz;
        int yy;
        int xx;
        int value;
        if (!this.field_145850_b.func_175648_a(bp, 17, false)) {
            return false;
        }
        World world = this.field_145850_b;
        int i = 0;
        int index = 0;
        int savedLight = world.func_175642_b(lightType, bp);
        int rawLight = this.getRawLight(bp, lightType);
        int testx = bp.func_177958_n();
        int testy = bp.func_177956_o();
        int testz = bp.func_177952_p();
        int x = testx - 32;
        int y = testy - 32;
        int z = testz - 32;
        LinkedList<BlockPos> result = new LinkedList<BlockPos>();
        if (rawLight > savedLight) {
            this.lightUpdateBlockList[index++] = 133152;
        } else if (rawLight < savedLight) {
            this.lightUpdateBlockList[index++] = 0x20820 | savedLight << 18;
            while (i < index) {
                value = this.lightUpdateBlockList[i++];
                xx = (value & 0x3F) + x;
                yy = (value >> 6 & 0x3F) + y;
                zz = (value >> 12 & 0x3F) + z;
                int arraylight = value >> 18 & 0xF;
                if (arraylight <= 0 || world.func_175642_b(lightType, blockpos = new BlockPos(xx, yy, zz)) != arraylight) continue;
                this.setLightFor_preChecked(lightType, blockpos, 0);
                range = MathHelper.func_76130_a((int)(xx - testx)) + MathHelper.func_76130_a((int)(yy - testy)) + MathHelper.func_76130_a((int)(zz - testz));
                if (range >= 17) continue;
                GCCoreUtil.getPositionsAdjoining(xx, yy, zz, result);
                for (BlockPos vec : result) {
                    savedLight = world.func_175642_b(lightType, vec);
                    if (savedLight == 0) continue;
                    IBlockState bs = world.func_180495_p(vec);
                    int opacity = bs.func_177230_c().getLightOpacity(bs, (IBlockAccess)world, vec);
                    if (opacity <= 0) {
                        opacity = 1;
                    }
                    if (savedLight != arraylight - opacity || index >= 65536) continue;
                    this.lightUpdateBlockList[index++] = vec.func_177958_n() - x + (((savedLight << 6) + vec.func_177952_p() - z << 6) + vec.func_177956_o() - y << 6);
                }
            }
            i = 0;
        }
        while (i < index) {
            value = this.lightUpdateBlockList[i++];
            xx = (value & 0x3F) + x;
            yy = (value >> 6 & 0x3F) + y;
            zz = (value >> 12 & 0x3F) + z;
            blockpos = new BlockPos(xx, yy, zz);
            savedLight = world.func_175642_b(lightType, blockpos);
            rawLight = this.getRawLight(blockpos, lightType);
            if (rawLight != savedLight) {
                this.setLightFor_preChecked(lightType, blockpos, rawLight);
                if (world.field_72995_K) {
                    world.func_175679_n(blockpos);
                }
                if (rawLight <= savedLight || (range = MathHelper.func_76130_a((int)(xx - testx)) + MathHelper.func_76130_a((int)(yy - testy)) + MathHelper.func_76130_a((int)(zz - testz))) >= 17 || index >= 65530) continue;
                GCCoreUtil.getPositionsAdjoining(xx, yy, zz, result);
                for (BlockPos vec : result) {
                    if (world.func_175642_b(lightType, vec) >= rawLight - 1) continue;
                    this.lightUpdateBlockList[index++] = vec.func_177958_n() - x + ((vec.func_177952_p() - z << 6) + vec.func_177956_o() - y << 6);
                }
                continue;
            }
            if (!world.field_72995_K || savedLight == (value >> 21 & 0xF)) continue;
            world.func_175679_n(blockpos);
        }
        return true;
    }

    public int checkLightPartA(EnumSkyBlock lightType, BlockPos bp, int indexIn) {
        if (indexIn >= 65536) {
            return indexIn;
        }
        World world = this.field_145850_b;
        int i = indexIn;
        boolean iNextStart = false;
        int index = indexIn;
        int savedLight = world.func_175642_b(lightType, bp);
        int rawLight = this.getRawLight(bp, lightType);
        int x = this.field_174879_c.func_177958_n() - 64;
        int y = this.field_174879_c.func_177956_o() - 64;
        int z = this.field_174879_c.func_177952_p() - 64;
        int testx = bp.func_177958_n();
        int testy = bp.func_177956_o();
        int testz = bp.func_177952_p();
        LinkedList<BlockPos> neighbours = new LinkedList<BlockPos>();
        if (rawLight > savedLight) {
            this.lightUpdateBlockList[index++] = ((testz - z << 7) + testy - y << 7) + testx - x;
        } else if (rawLight < savedLight) {
            this.lightUpdateBlockList[index++] = ((testz - z << 7) + testy - y << 7) + testx - x | savedLight << 21;
            this.setLightFor_preChecked(lightType, bp, 0);
            while (i < index) {
                int value = this.lightUpdateBlockList[i++];
                int xx = (value & 0x7F) + x;
                int yy = (value >> 7 & 0x7F) + y;
                int zz = (value >> 14 & 0x7F) + z;
                int range = MathHelper.func_76130_a((int)(xx - testx)) + MathHelper.func_76130_a((int)(yy - testy)) + MathHelper.func_76130_a((int)(zz - testz));
                if (range >= 17) continue;
                int arraylight = value >> 21 & 0xF;
                GCCoreUtil.getPositionsAdjoiningLoaded(xx, yy, zz, neighbours, world);
                for (BlockPos vec : neighbours) {
                    savedLight = world.func_175642_b(lightType, vec);
                    if (savedLight == 0) continue;
                    IBlockState bs = world.func_180495_p(vec);
                    int opacity = bs.func_177230_c().getLightOpacity(bs, (IBlockAccess)world, vec);
                    if (opacity <= 0) {
                        opacity = 1;
                    }
                    if (savedLight != arraylight - opacity || index >= 65536) continue;
                    this.lightUpdateBlockList[index++] = vec.func_177958_n() - x + (((savedLight << 7) + vec.func_177952_p() - z << 7) + vec.func_177956_o() - y << 7);
                    this.setLightFor_preChecked(lightType, vec, 0);
                }
            }
            i = indexIn;
        }
        return index;
    }

    public boolean checkLightPartB(EnumSkyBlock lightType, int index) {
        World world = this.field_145850_b;
        int i = 0;
        int testx = this.field_174879_c.func_177958_n();
        int testy = this.field_174879_c.func_177956_o();
        int testz = this.field_174879_c.func_177952_p();
        int x = testx - 64;
        int y = testy - 64;
        int z = testz - 64;
        LinkedList<BlockPos> neighbours = new LinkedList<BlockPos>();
        while (i < index) {
            int value = this.lightUpdateBlockList[i++];
            int xx = (value & 0x7F) + x;
            int yy = (value >> 7 & 0x7F) + y;
            int zz = (value >> 14 & 0x7F) + z;
            BlockPos blockpos = new BlockPos(xx, yy, zz);
            int savedLight = world.func_175642_b(lightType, blockpos);
            int rawLight = this.getRawLight(blockpos, lightType);
            if (rawLight != savedLight) {
                int range;
                this.setLightFor_preChecked(lightType, blockpos, rawLight);
                if (world.field_72995_K) {
                    world.func_175679_n(blockpos);
                }
                if (rawLight <= savedLight || (range = MathHelper.func_76130_a((int)(xx - testx)) + MathHelper.func_76130_a((int)(yy - testy)) + MathHelper.func_76130_a((int)(zz - testz))) >= 34 || index >= 65530) continue;
                GCCoreUtil.getPositionsAdjoiningLoaded(xx, yy, zz, neighbours, world);
                for (BlockPos vec : neighbours) {
                    if (world.func_175642_b(lightType, vec) >= rawLight - 1) continue;
                    this.lightUpdateBlockList[index++] = vec.func_177958_n() - x + ((vec.func_177952_p() - z << 7) + vec.func_177956_o() - y << 7);
                }
                continue;
            }
            if (!world.field_72995_K || savedLight == (value >> 21 & 0xF)) continue;
            world.func_175679_n(blockpos);
        }
        return true;
    }

    private int getRawLight(BlockPos pos, EnumSkyBlock lightType) {
        int light;
        IBlockState bs = this.field_145850_b.func_180495_p(pos);
        Block block = bs.func_177230_c();
        int blockLight = block.getLightValue(bs, (IBlockAccess)this.field_145850_b, pos);
        int n = light = lightType == EnumSkyBlock.SKY ? 0 : blockLight;
        if (light < 14) {
            int opacity = block.getLightOpacity(bs, (IBlockAccess)this.field_145850_b, pos);
            if (opacity < 1) {
                opacity = 1;
            } else if (opacity >= 15) {
                if (blockLight > 0) {
                    opacity = 1;
                } else {
                    return 0;
                }
            }
            for (BlockPos blockpos : GCCoreUtil.getPositionsAdjoining(pos)) {
                int neighbourLight = this.field_145850_b.func_175642_b(lightType, blockpos) - opacity;
                if (neighbourLight <= light) continue;
                if (neighbourLight >= 14) {
                    return neighbourLight;
                }
                light = neighbourLight;
            }
        }
        return light;
    }

    private void setLightFor_preChecked(EnumSkyBlock type, BlockPos pos, int lightValue) {
        this.field_145850_b.func_72964_e(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4).func_177431_a(type, pos, lightValue);
    }

    public boolean getEnabled() {
        return !RedstoneUtil.isBlockReceivingRedstone(this.field_145850_b, this.func_174877_v());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    private void checkedAdd(BlockVec3 vec) {
        int dx = this.field_174879_c.func_177958_n() - vec.x;
        int dz = this.field_174879_c.func_177952_p() - vec.z;
        if (dx < -8191 || dx > 8192) {
            return;
        }
        if (dz < -8191 || dz > 8192) {
            return;
        }
        intBucket bucket = this.buckets[((dx & 0xF) << 4) + (dz & 0xF)];
        bucket.add(vec.y + ((dx & 0x3FF0) + ((dz & 0x3FF0) << 10) << 4));
    }

    private boolean checkedContains(BlockVec3 vec) {
        int dx = this.field_174879_c.func_177958_n() - vec.x;
        int dz = this.field_174879_c.func_177952_p() - vec.z;
        if (dx < -8191 || dx > 8192) {
            return true;
        }
        if (dz < -8191 || dz > 8192) {
            return true;
        }
        intBucket bucket = this.buckets[((dx & 0xF) << 4) + (dz & 0xF)];
        return bucket.contains(vec.y + ((dx & 0x3FF0) + ((dz & 0x3FF0) << 10) << 4));
    }

    private boolean checkedContains(BlockVec3 vec, int side) {
        int y = vec.y;
        int dx = this.field_174879_c.func_177958_n() - vec.x;
        int dz = this.field_174879_c.func_177952_p() - vec.z;
        switch (side) {
            case 0: {
                if (--y >= 0) break;
                return true;
            }
            case 1: {
                if (++y <= 255) break;
                return true;
            }
            case 2: {
                ++dz;
                break;
            }
            case 3: {
                --dz;
                break;
            }
            case 4: {
                ++dx;
                break;
            }
            case 5: {
                --dx;
            }
        }
        if (dx < -8191 || dx > 8192) {
            return true;
        }
        if (dz < -8191 || dz > 8192) {
            return true;
        }
        intBucket bucket = this.buckets[((dx & 0xF) << 4) + (dz & 0xF)];
        return bucket.contains(y + ((dx & 0x3FF0) + ((dz & 0x3FF0) << 10) << 4));
    }

    private static void checkedInit(intBucket[] buckets) {
        for (int i = 0; i < 256; ++i) {
            buckets[i] = new intBucket();
        }
    }

    private void checkedClear() {
        for (int i = 0; i < 256; ++i) {
            this.buckets[i].clear();
        }
    }

    @Override
    public void buildDataPacket(int[] data) {
        data[0] = this.facing;
    }

    @Override
    public void updateClient(List<Object> data) {
        this.facing = (Integer)data.get(1);
        this.revertAir();
        this.thisAABB = null;
        this.ticks = 86;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 262144.0;
    }

    @Override
    public void getNetworkedData(ArrayList<Object> sendData) {
        for (BlockVec3 vec : this.airToRestore) {
            sendData.add(vec);
        }
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        while (buffer.readableBytes() >= 12) {
            int x = buffer.readInt();
            int y = buffer.readInt();
            int z = buffer.readInt();
            this.airToRestore.add(new BlockVec3(x, y, z));
        }
    }

    static {
        usingBucketsServer = new AtomicBoolean();
        usingBucketsClient = new AtomicBoolean();
        lightUpdateBlockListServer = null;
        lightUpdateBlockListClient = null;
        usingLightListServer = new AtomicBoolean();
        usingLightListClient = new AtomicBoolean();
        bucketsServer = new intBucket[256];
        bucketsClient = new intBucket[256];
        TileEntityArclamp.checkedInit(bucketsServer);
        TileEntityArclamp.checkedInit(bucketsClient);
    }

    public static class intBucket {
        private int maxSize = 12;
        private int size = 0;
        private int[] table = new int[this.maxSize];

        public void add(int i) {
            if (this.contains(i)) {
                return;
            }
            if (this.size >= this.maxSize) {
                int[] newTable = new int[this.maxSize + this.maxSize];
                System.arraycopy(this.table, 0, newTable, 0, this.maxSize);
                this.table = newTable;
                this.maxSize += this.maxSize;
            }
            this.table[this.size] = i;
            ++this.size;
        }

        public boolean contains(int test) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.table[i] != test) continue;
                return true;
            }
            return false;
        }

        public void clear() {
            this.size = 0;
        }

        public int size() {
            return this.size;
        }

        public int[] contents() {
            return this.table;
        }
    }
}

