/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.tile;

import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.ISpecialElectricItem;
import java.util.EnumSet;
import mekanism.api.energy.EnergizedItemManager;
import mekanism.api.energy.IEnergizedItem;
import micdoodle8.mods.galacticraft.api.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.item.IItemElectric;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorageTile;
import micdoodle8.mods.galacticraft.core.tile.ReceiverMode;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class TileBaseUniversalElectrical
extends EnergyStorageTile {
    protected boolean isAddedToEnergyNet;
    protected Object powerHandlerBC;
    private float IC2surplusInGJ = 0.0f;

    @Override
    public double getPacketRange() {
        return 12.0;
    }

    @Override
    public int getPacketCooldown() {
        return 3;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }

    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.allOf(EnumFacing.class);
    }

    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    @Override
    public float getRequest(EnumFacing direction) {
        if (this.getElectricalInputDirections().contains(direction) || direction == null) {
            return super.getRequest(direction);
        }
        return 0.0f;
    }

    @Override
    public float receiveElectricity(EnumFacing from, float receive, int tier, boolean doReceive) {
        if (this.getElectricalInputDirections().contains(from) || from == null) {
            return super.receiveElectricity(from, receive, tier, doReceive);
        }
        return 0.0f;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        return nbt;
    }

    public void discharge(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            float energyToDischarge = this.getRequest(null);
            if (item instanceof IItemElectric) {
                this.storage.receiveEnergyGC(ElectricItemHelper.dischargeItem(itemStack, energyToDischarge));
            } else if (EnergyConfigHandler.isMekanismLoaded() && item instanceof IEnergizedItem && ((IEnergizedItem)item).canSend(itemStack)) {
                this.storage.receiveEnergyGC((float)EnergizedItemManager.discharge((ItemStack)itemStack, (double)(energyToDischarge / EnergyConfigHandler.MEKANISM_RATIO)) * EnergyConfigHandler.MEKANISM_RATIO);
            } else if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
                IElectricItem electricItem;
                if (item instanceof ISpecialElectricItem && item instanceof IElectricItem) {
                    IElectricItem electricItem2 = (IElectricItem)item;
                    ISpecialElectricItem specialElectricItem = (ISpecialElectricItem)item;
                    if (electricItem2.canProvideEnergy(itemStack)) {
                        double energyDischargeIC2 = energyToDischarge / EnergyConfigHandler.IC2_RATIO;
                        double result = specialElectricItem.getManager(itemStack).discharge(itemStack, energyDischargeIC2, 4, false, false, false);
                        float energyDischarged = (float)result * EnergyConfigHandler.IC2_RATIO;
                        this.storage.receiveEnergyGC(energyDischarged);
                    }
                } else if (item instanceof IElectricItem && (electricItem = (IElectricItem)item).canProvideEnergy(itemStack)) {
                    double energyDischargeIC2 = energyToDischarge / EnergyConfigHandler.IC2_RATIO;
                    double result = ElectricItem.manager.discharge(itemStack, energyDischargeIC2, 4, false, false, false);
                    float energyDischarged = (float)result * EnergyConfigHandler.IC2_RATIO;
                    this.storage.receiveEnergyGC(energyDischarged);
                }
            }
        }
    }

    @Override
    public void initiate() {
        super.initiate();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isAddedToEnergyNet) {
                this.initIC();
            }
            if (EnergyConfigHandler.isIndustrialCraft2Loaded() && this.IC2surplusInGJ >= 0.001f) {
                this.IC2surplusInGJ -= this.storage.receiveEnergyGC(this.IC2surplusInGJ);
                if (this.IC2surplusInGJ < 0.001f) {
                    this.IC2surplusInGJ = 0.0f;
                }
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.unloadTileIC2();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.unloadTileIC2();
    }

    protected void initIC() {
        if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            try {
                Object o = CompatibilityManager.classIC2tileEventLoad.getConstructor(IEnergyTile.class).newInstance(this);
                if (o instanceof Event) {
                    MinecraftForge.EVENT_BUS.post((Event)o);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isAddedToEnergyNet = true;
    }

    private void unloadTileIC2() {
        if (this.isAddedToEnergyNet && this.field_145850_b != null) {
            if (EnergyConfigHandler.isIndustrialCraft2Loaded() && !this.field_145850_b.field_72995_K) {
                try {
                    Object o = CompatibilityManager.classIC2tileEventUnload.getConstructor(IEnergyTile.class).newInstance(this);
                    if (o instanceof Event) {
                        MinecraftForge.EVENT_BUS.post((Event)o);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.isAddedToEnergyNet = false;
        }
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="ic2")
    public double getDemandedEnergy() {
        if (EnergyConfigHandler.disableIC2Input) {
            return 0.0;
        }
        try {
            if (this.IC2surplusInGJ < 0.001f) {
                this.IC2surplusInGJ = 0.0f;
                return Math.ceil(this.storage.receiveEnergyGC(2.1474836E9f, true) / EnergyConfigHandler.IC2_RATIO);
            }
            float received = this.storage.receiveEnergyGC(this.IC2surplusInGJ, true);
            if (received == this.IC2surplusInGJ) {
                return Math.ceil((this.storage.receiveEnergyGC(2.1474836E9f, true) - this.IC2surplusInGJ) / EnergyConfigHandler.IC2_RATIO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="ic2")
    public double injectEnergy(EnumFacing direction, double amount, double voltage) {
        if (!EnergyConfigHandler.disableIC2Input && (direction == null || this.getElectricalInputDirections().contains(direction.func_176734_d()))) {
            float convertedEnergy = (float)amount * EnergyConfigHandler.IC2_RATIO;
            int tierFromIC2 = (int)voltage > 120 ? ((int)voltage > 256 ? 4 : 2) : 1;
            float receive = this.receiveElectricity(direction == null ? null : direction.func_176734_d(), convertedEnergy, tierFromIC2, true);
            this.IC2surplusInGJ = convertedEnergy > receive ? convertedEnergy - receive : 0.0f;
            return 0.0;
        }
        return amount;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="ic2")
    public int getSinkTier() {
        return 3;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergyAcceptor", modID="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        if (this.field_145846_f) {
            return false;
        }
        if (emitter instanceof IElectrical || emitter instanceof IConductor || !(emitter instanceof IEnergyTile)) {
            return false;
        }
        return this.getElectricalInputDirections().contains(direction);
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyReceiver", modID="")
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (EnergyConfigHandler.disableRFInput) {
            return 0;
        }
        if (!this.getElectricalInputDirections().contains(from)) {
            return 0;
        }
        return MathHelper.func_76141_d((float)(super.receiveElectricity(from, (float)maxReceive * EnergyConfigHandler.RF_RATIO, 1, !simulate) / EnergyConfigHandler.RF_RATIO));
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="")
    public boolean canConnectEnergy(EnumFacing from) {
        return this.getElectricalInputDirections().contains(from) || this.getElectricalOutputDirections().contains(from);
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="")
    public int getEnergyStored(EnumFacing from) {
        return MathHelper.func_76141_d((float)(this.getEnergyStoredGC() / EnergyConfigHandler.RF_RATIO));
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="")
    public int getMaxEnergyStored(EnumFacing from) {
        return MathHelper.func_76141_d((float)(this.getMaxEnergyStoredGC() / EnergyConfigHandler.RF_RATIO));
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="mekanism")
    public double transferEnergyToAcceptor(EnumFacing from, double amount) {
        if (EnergyConfigHandler.disableMekanismInput) {
            return 0.0;
        }
        if (!this.getElectricalInputDirections().contains(from)) {
            return 0.0;
        }
        return this.receiveElectricity(from, (float)amount * EnergyConfigHandler.MEKANISM_RATIO, 1, true) / EnergyConfigHandler.MEKANISM_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="mekanism")
    public boolean canReceiveEnergy(EnumFacing side) {
        return this.getElectricalInputDirections().contains(side);
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="mekanism")
    public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
        if (EnergyConfigHandler.disableMekanismInput) {
            return 0.0;
        }
        return this.receiveElectricity(side, (float)amount * EnergyConfigHandler.MEKANISM_RATIO, 1, simulate) / EnergyConfigHandler.MEKANISM_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyOutputter", modID="mekanism")
    public boolean canOutputEnergy(EnumFacing side) {
        return false;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyOutputter", modID="mekanism")
    public double pullEnergy(EnumFacing side, double amount, boolean simulate) {
        return 0.0;
    }

    @Override
    public ReceiverMode getModeFromDirection(EnumFacing direction) {
        if (this.getElectricalInputDirections().contains(direction)) {
            return ReceiverMode.RECEIVE;
        }
        if (this.getElectricalOutputDirections().contains(direction)) {
            return ReceiverMode.EXTRACT;
        }
        return null;
    }

    public void updateFacing() {
        if (EnergyConfigHandler.isIndustrialCraft2Loaded() && !this.field_145850_b.field_72995_K) {
            this.unloadTileIC2();
        }
    }

    public static void onUseWrenchBlock(IBlockState state, World world, BlockPos pos, EnumFacing facing) {
        int metadata = state.func_177230_c().func_176201_c(world.func_180495_p(pos));
        int change = facing.func_176746_e().func_176736_b();
        world.func_180501_a(pos, state.func_177230_c().func_176203_a(metadata - metadata % 4 + change), 3);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileBaseUniversalElectrical) {
            ((TileBaseUniversalElectrical)te).updateFacing();
        }
    }
}

