/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.tile;

import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IElectricityNetwork;
import micdoodle8.mods.galacticraft.api.transmission.grid.IGridNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.grid.EnergyNetwork;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileBaseConductor
extends TileEntity
implements IConductor {
    protected IGridNetwork network;
    public TileEntity[] adjacentConnections = null;

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            TickHandlerServer.energyTransmitterUpdates.add(this);
        }
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            this.getNetwork().split(this);
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        super.func_145843_s();
        super.onChunkUnload();
    }

    @Override
    public IElectricityNetwork getNetwork() {
        if (this.network == null) {
            EnergyNetwork network = new EnergyNetwork();
            network.getTransmitters().add(this);
            this.setNetwork(network);
        }
        return (IElectricityNetwork)this.network;
    }

    @Override
    public void setNetwork(IGridNetwork network) {
        this.network = network;
    }

    @Override
    public void refresh() {
        if (!this.field_145850_b.field_72995_K) {
            this.adjacentConnections = null;
            this.getNetwork().refresh();
            BlockVec3 thisVec = new BlockVec3(this);
            for (EnumFacing side : EnumFacing.values()) {
                TileEntity tileEntity = thisVec.getTileEntityOnSide(this.field_145850_b, side);
                if (!(tileEntity instanceof TileBaseConductor) || !((TileBaseConductor)tileEntity).canConnect(side.func_176734_d(), NetworkType.POWER)) continue;
                IGridNetwork otherNet = ((INetworkProvider)tileEntity).getNetwork();
                if (this.getNetwork().equals(otherNet) || otherNet.getTransmitters().isEmpty()) continue;
                otherNet.merge(this.getNetwork());
            }
        }
    }

    @Override
    public TileEntity[] getAdjacentConnections() {
        if (this.adjacentConnections == null) {
            this.adjacentConnections = new TileEntity[6];
            BlockVec3 thisVec = new BlockVec3(this);
            for (int i = 0; i < 6; ++i) {
                EnumFacing side = EnumFacing.func_82600_a((int)i);
                TileEntity tileEntity = thisVec.getTileEntityOnSide(this.field_145850_b, side);
                if (!(tileEntity instanceof IConnector) || !((IConnector)tileEntity).canConnect(side.func_176734_d(), NetworkType.POWER)) continue;
                this.adjacentConnections[i] = tileEntity;
            }
        }
        return this.adjacentConnections;
    }

    @Override
    public boolean hasNetwork() {
        return this.network != null;
    }

    @Override
    public boolean canConnect(EnumFacing direction, NetworkType type) {
        return type == NetworkType.POWER;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    @Override
    public NetworkType getNetworkType() {
        return NetworkType.POWER;
    }

    @Override
    public boolean canTransmit() {
        return true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

