/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.screen;

import micdoodle8.mods.galacticraft.api.client.IGameScreen;
import micdoodle8.mods.galacticraft.api.client.IScreenManager;
import micdoodle8.mods.galacticraft.core.Constants;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.render.RenderPlanet;
import micdoodle8.mods.galacticraft.core.client.screen.DrawGameScreen;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class GameScreenBasic
implements IGameScreen {
    private TextureManager renderEngine;
    private float frameA;
    private float frameBx;
    private float frameBy;
    private float textureAx = 0.0f;
    private float textureAy = 0.0f;
    private float textureBx = 1.0f;
    private float textureBy = 1.0f;

    public GameScreenBasic() {
        if (GCCoreUtil.getEffectiveSide().isClient()) {
            this.renderEngine = FMLClientHandler.instance().getClient().field_71446_o;
        }
    }

    @Override
    public void setFrameSize(float frameSize) {
        this.frameA = frameSize;
    }

    @Override
    public void render(int type, float ticks, float scaleX, float scaleY, IScreenManager scr) {
        this.frameBx = scaleX - this.frameA;
        this.frameBy = scaleY - this.frameA;
        if (scaleX == scaleY) {
            this.textureAx = 0.0f;
            this.textureAy = 0.0f;
            this.textureBx = 1.0f;
            this.textureBy = 1.0f;
        } else if (scaleX < scaleY) {
            this.textureAx = (1.0f - scaleX / scaleY) / 2.0f;
            this.textureAy = 0.0f;
            this.textureBx = 1.0f - this.textureAx;
            this.textureBy = 1.0f;
        } else if (scaleY < scaleX) {
            this.textureAx = 0.0f;
            this.textureAy = (1.0f - scaleY / scaleX) / 2.0f;
            this.textureBx = 1.0f;
            this.textureBy = 1.0f - this.textureAy;
        }
        switch (type) {
            case 0: {
                this.drawBlackBackground(0.09f);
                break;
            }
            case 1: {
                if (scr instanceof DrawGameScreen && ((DrawGameScreen)scr).mapDone) {
                    GL11.glBindTexture((int)3553, (int)DrawGameScreen.reusableMap.func_110552_b());
                    this.draw2DTexture();
                    break;
                }
                if (ClientProxyCore.overworldTexturesValid) {
                    GL11.glPushMatrix();
                    float centreX = scaleX / 2.0f;
                    float centreY = scaleY / 2.0f;
                    GL11.glTranslatef((float)centreX, (float)centreY, (float)0.0f);
                    RenderPlanet.renderPlanet(ClientProxyCore.overworldTextureWide.func_110552_b(), Math.min(scaleX, scaleY) - 0.2f, ticks, 45.0f);
                    GL11.glPopMatrix();
                    break;
                }
                this.renderEngine.func_110577_a(new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/celestialbodies/earth.png"));
                if (!ClientProxyCore.overworldTextureRequestSent) {
                    GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REQUEST_OVERWORLD_IMAGE, GCCoreUtil.getDimensionID((World)FMLClientHandler.instance().getClient().field_71441_e), new Object[0]));
                    ClientProxyCore.overworldTextureRequestSent = true;
                }
                this.draw2DTexture();
            }
        }
    }

    private void draw2DTexture() {
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer worldRenderer = tess.func_178180_c();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)this.frameA, (double)this.frameBy, 0.0).func_187315_a((double)this.textureAx, (double)this.textureBy).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameBx, (double)this.frameBy, 0.0).func_187315_a((double)this.textureBx, (double)this.textureBy).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameBx, (double)this.frameA, 0.0).func_187315_a((double)this.textureBx, (double)this.textureAy).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameA, (double)this.frameA, 0.0).func_187315_a((double)this.textureAx, (double)this.textureAy).func_181675_d();
        tess.func_78381_a();
    }

    private void drawBlackBackground(float greyLevel) {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer worldRenderer = tess.func_178180_c();
        GL11.glColor4f((float)greyLevel, (float)greyLevel, (float)greyLevel, (float)1.0f);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)this.frameA, (double)this.frameBy, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameBx, (double)this.frameBy, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameBx, (double)this.frameA, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameA, (double)this.frameA, (double)0.005f).func_181675_d();
        tess.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }
}

