/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.Constants;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.wrappers.Footprint;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class FootprintRenderer {
    public static Map<Long, List<Footprint>> footprints = new ConcurrentHashMap<Long, List<Footprint>>();
    private static final ResourceLocation footprintTexture = new ResourceLocation(Constants.ASSET_PREFIX, "textures/misc/footprint.png");

    public static void renderFootprints(EntityPlayer player, float partialTicks) {
        GL11.glPushMatrix();
        double interpPosX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double interpPosY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double interpPosZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(footprintTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        Tessellator tessellator = Tessellator.func_178181_a();
        float f7 = 1.0f;
        float f6 = 0.0f;
        float f8 = 0.0f;
        float f9 = 1.0f;
        float f10 = 0.4f;
        GL11.glAlphaFunc((int)516, (float)0.1f);
        for (List<Footprint> footprintList : footprints.values()) {
            for (Footprint footprint : footprintList) {
                if (footprint.dimension != GCCoreUtil.getDimensionID(player.field_70170_p)) continue;
                GL11.glPushMatrix();
                float ageScale = (float)footprint.age / 3200.0f;
                VertexBuffer worldRenderer = tessellator.func_178180_c();
                worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                float f11 = (float)(footprint.position.x - interpPosX);
                float f12 = (float)(footprint.position.y - interpPosY) + 0.001f;
                float f13 = (float)(footprint.position.z - interpPosZ);
                GL11.glTranslatef((float)f11, (float)f12, (float)f13);
                int brightness = (int)(100.0f + ageScale * 155.0f);
                GL11.glColor4f((float)(1.0f - ageScale), (float)(1.0f - ageScale), (float)(1.0f - ageScale), (float)(1.0f - ageScale));
                double footprintScale = 0.5;
                worldRenderer.func_181662_b(Math.sin((double)(45.0f - footprint.rotation) / 57.29577951308232) * footprintScale, 0.0, Math.cos((double)(45.0f - footprint.rotation) / 57.29577951308232) * footprintScale).func_187315_a((double)f7, (double)f9).func_181675_d();
                worldRenderer.func_181662_b(Math.sin((double)(135.0f - footprint.rotation) / 57.29577951308232) * footprintScale, 0.0, Math.cos((double)(135.0f - footprint.rotation) / 57.29577951308232) * footprintScale).func_187315_a((double)f7, (double)f8).func_181675_d();
                worldRenderer.func_181662_b(Math.sin((double)(225.0f - footprint.rotation) / 57.29577951308232) * footprintScale, 0.0, Math.cos((double)(225.0f - footprint.rotation) / 57.29577951308232) * footprintScale).func_187315_a((double)f6, (double)f8).func_181675_d();
                worldRenderer.func_181662_b(Math.sin((double)(315.0f - footprint.rotation) / 57.29577951308232) * footprintScale, 0.0, Math.cos((double)(315.0f - footprint.rotation) / 57.29577951308232) * footprintScale).func_187315_a((double)f6, (double)f9).func_181675_d();
                tessellator.func_78381_a();
                GL11.glPopMatrix();
            }
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    public static void addFootprint(long chunkKey, Footprint footprint) {
        List<Footprint> footprintList = footprints.get(chunkKey);
        if (footprintList == null) {
            footprintList = new ArrayList<Footprint>();
        }
        footprintList.add(new Footprint(footprint.dimension, footprint.position, footprint.rotation, footprint.owner));
        footprints.put(chunkKey, footprintList);
    }

    public static void addFootprint(long chunkKey, int dimension, Vector3 position, float rotation, String owner) {
        FootprintRenderer.addFootprint(chunkKey, new Footprint(dimension, position, rotation, owner));
    }

    public static void setFootprints(long chunkKey, List<Footprint> prints) {
        List<Footprint> footprintList = footprints.get(chunkKey);
        if (footprintList == null) {
            footprintList = new ArrayList<Footprint>();
        }
        Iterator<Footprint> i = footprintList.iterator();
        while (i.hasNext()) {
            Footprint print = i.next();
            if (print.owner.equals(FMLClientHandler.instance().getClient().field_71439_g.func_70005_c_())) continue;
            i.remove();
        }
        footprintList.addAll(prints);
        footprints.put(chunkKey, footprintList);
    }
}

