/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.blocks;

import com.google.common.base.Predicate;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IDetectableResource;
import micdoodle8.mods.galacticraft.api.block.IPlantableBlock;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.planets.venus.VenusBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBasicVenus
extends Block
implements IDetectableResource,
IPlantableBlock,
ITerraformableBlock,
ISortableBlock {
    public static final PropertyEnum BASIC_TYPE_VENUS = PropertyEnum.func_177709_a((String)"basictypevenus", EnumBlockBasicVenus.class);

    public BlockBasicVenus(String assetName) {
        super(Material.field_151576_e);
        this.field_149782_v = 2.2f;
        this.field_149781_w = 2.5f;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BASIC_TYPE_VENUS, (Comparable)((Object)EnumBlockBasicVenus.ROCK_SOFT)));
        this.func_149663_c(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        EnumBlockBasicVenus type = (EnumBlockBasicVenus)((Object)state.func_177229_b((IProperty)BASIC_TYPE_VENUS));
        if (type == EnumBlockBasicVenus.ROCK_MAGMA) {
            worldIn.func_175656_a(pos, Blocks.field_150356_k.func_176223_P());
        }
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        EnumBlockBasicVenus type = (EnumBlockBasicVenus)((Object)world.func_180495_p(pos).func_177229_b((IProperty)BASIC_TYPE_VENUS));
        if (type == EnumBlockBasicVenus.ROCK_HARD) {
            return 6.0f;
        }
        if (type == EnumBlockBasicVenus.DUNGEON_BRICK_1 || type == EnumBlockBasicVenus.DUNGEON_BRICK_2) {
            return 40.0f;
        }
        if (type == EnumBlockBasicVenus.ORE_ALUMINUM || type == EnumBlockBasicVenus.ORE_COPPER || type == EnumBlockBasicVenus.ORE_GALENA || type == EnumBlockBasicVenus.ORE_QUARTZ || type == EnumBlockBasicVenus.ORE_SILICON || type == EnumBlockBasicVenus.ORE_TIN) {
            return 3.0f;
        }
        return this.field_149781_w / 5.0f;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        EnumBlockBasicVenus type = (EnumBlockBasicVenus)((Object)worldIn.func_180495_p(pos).func_177229_b((IProperty)BASIC_TYPE_VENUS));
        if (type == EnumBlockBasicVenus.ROCK_HARD) {
            return 1.5f;
        }
        if (type == EnumBlockBasicVenus.ROCK_SOFT) {
            return 0.9f;
        }
        if (type == EnumBlockBasicVenus.DUNGEON_BRICK_1 || type == EnumBlockBasicVenus.DUNGEON_BRICK_2) {
            return 4.0f;
        }
        if (type == EnumBlockBasicVenus.ORE_ALUMINUM || type == EnumBlockBasicVenus.ORE_COPPER || type == EnumBlockBasicVenus.ORE_GALENA || type == EnumBlockBasicVenus.ORE_QUARTZ || type == EnumBlockBasicVenus.ORE_SILICON || type == EnumBlockBasicVenus.ORE_TIN) {
            return 5.0f;
        }
        return this.field_149782_v;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        EnumBlockBasicVenus type = (EnumBlockBasicVenus)((Object)state.func_177229_b((IProperty)BASIC_TYPE_VENUS));
        switch (type) {
            case ORE_SILICON: {
                return GCItems.basicItem;
            }
            case ORE_QUARTZ: {
                return Items.field_151128_bU;
            }
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        EnumBlockBasicVenus type = (EnumBlockBasicVenus)((Object)state.func_177229_b((IProperty)BASIC_TYPE_VENUS));
        switch (type) {
            case ORE_SILICON: {
                return 2;
            }
            case ORE_QUARTZ: {
                return 0;
            }
        }
        return this.func_176201_c(state);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        EnumBlockBasicVenus type = (EnumBlockBasicVenus)((Object)state.func_177229_b((IProperty)BASIC_TYPE_VENUS));
        switch (type) {
            case ORE_SILICON: {
                if (fortune <= 0) break;
                int j = random.nextInt(fortune + 2) - 1;
                if (j < 0) {
                    j = 0;
                }
                return this.func_149745_a(random) * (j + 1);
            }
        }
        return this.func_149745_a(random);
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        Random rand;
        EnumBlockBasicVenus type = (EnumBlockBasicVenus)((Object)state.func_177229_b((IProperty)BASIC_TYPE_VENUS));
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        if (this.func_180660_a(state, rand, fortune) != Item.func_150898_a((Block)this)) {
            int i;
            switch (type) {
                case ORE_SILICON: {
                    i = MathHelper.func_76136_a((Random)rand, (int)2, (int)5);
                    break;
                }
                default: {
                    i = 0;
                }
            }
            return i;
        }
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumBlockBasicVenus type : EnumBlockBasicVenus.values()) {
            list.add((Object)new ItemStack(itemIn, 1, type.getMeta()));
        }
    }

    public boolean isValueable(IBlockState state) {
        EnumBlockBasicVenus type = (EnumBlockBasicVenus)((Object)state.func_177229_b((IProperty)BASIC_TYPE_VENUS));
        switch (type) {
            case ORE_SILICON: 
            case ORE_QUARTZ: 
            case ORE_ALUMINUM: 
            case ORE_COPPER: 
            case ORE_GALENA: 
            case ORE_TIN: {
                return true;
            }
        }
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return false;
    }

    public int requiredLiquidBlocksNearby() {
        return 4;
    }

    public boolean isPlantable(IBlockState state) {
        return false;
    }

    public boolean isTerraformable(World world, BlockPos pos) {
        EnumBlockBasicVenus type = (EnumBlockBasicVenus)((Object)world.func_180495_p(pos).func_177229_b((IProperty)BASIC_TYPE_VENUS));
        if (type == EnumBlockBasicVenus.ROCK_HARD || type == EnumBlockBasicVenus.ROCK_SOFT) {
            BlockPos above = pos.func_177972_a(EnumFacing.UP);
            IBlockState stateAbove = world.func_180495_p(above);
            return stateAbove.func_177230_c().isAir(stateAbove, (IBlockAccess)world, above);
        }
        return false;
    }

    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        EnumBlockBasicVenus type = (EnumBlockBasicVenus)((Object)world.func_180495_p(pos).func_177229_b((IProperty)BASIC_TYPE_VENUS));
        return type == EnumBlockBasicVenus.ROCK_HARD;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BASIC_TYPE_VENUS, (Comparable)((Object)EnumBlockBasicVenus.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBlockBasicVenus)((Object)state.func_177229_b((IProperty)BASIC_TYPE_VENUS))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BASIC_TYPE_VENUS});
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        EnumBlockBasicVenus type = (EnumBlockBasicVenus)((Object)this.func_176203_a(meta).func_177229_b((IProperty)BASIC_TYPE_VENUS));
        switch (type) {
            case ORE_SILICON: 
            case ORE_QUARTZ: 
            case ORE_ALUMINUM: 
            case ORE_COPPER: 
            case ORE_GALENA: 
            case ORE_TIN: {
                return EnumSortCategoryBlock.ORE;
            }
            case DUNGEON_BRICK_1: 
            case DUNGEON_BRICK_2: {
                return EnumSortCategoryBlock.BRICKS;
            }
        }
        return EnumSortCategoryBlock.GENERAL;
    }

    public static enum EnumBlockBasicVenus implements IStringSerializable
    {
        ROCK_SOFT(0, "venus_rock_0"),
        ROCK_HARD(1, "venus_rock_1"),
        ROCK_MAGMA(2, "venus_rock_2"),
        ROCK_VOLCANIC_DEPOSIT(3, "venus_rock_3"),
        DUNGEON_BRICK_1(4, "dungeon_brick_venus_1"),
        DUNGEON_BRICK_2(5, "dungeon_brick_venus_2"),
        ORE_ALUMINUM(6, "venus_ore_aluminum"),
        ORE_COPPER(7, "venus_ore_copper"),
        ORE_GALENA(8, "venus_ore_galena"),
        ORE_QUARTZ(9, "venus_ore_quartz"),
        ORE_SILICON(10, "venus_ore_silicon"),
        ORE_TIN(11, "venus_ore_tin");

        private final int meta;
        private final String name;

        private EnumBlockBasicVenus(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumBlockBasicVenus byMetadata(int meta) {
            return EnumBlockBasicVenus.values()[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public ItemStack getItemStack() {
            return new ItemStack(VenusBlocks.venusBlock, 1, this.meta);
        }
    }
}

