/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.entities.IBubbleProvider;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.galacticraft.planets.mars.blocks.BlockMachineMars;
import micdoodle8.mods.galacticraft.planets.mars.inventory.ContainerTerraformer;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTerraformer
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IDisableableMachine,
IBubbleProvider,
IFluidHandlerWrapper {
    private final int tankCapacity = 2000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank = new FluidTank(this.tankCapacity);
    public boolean active;
    public boolean lastActive;
    public static final int WATTS_PER_TICK = 1;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)14, (Object)ItemStack.field_190927_a);
    private ArrayList<BlockPos> terraformableBlocksList = new ArrayList();
    private ArrayList<BlockPos> grassBlockList = new ArrayList();
    private ArrayList<BlockPos> grownTreesList = new ArrayList();
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int terraformableBlocksListSize = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int grassBlocksListSize = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean treesDisabled;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean grassDisabled;
    public final double MAX_SIZE = 15.0;
    private int[] useCount = new int[2];
    private int saplingIndex = 6;
    public float bubbleSize;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean shouldRenderBubble = true;

    public TileEntityTerraformer() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 60.0f : 30.0f);
    }

    public int getScaledWaterLevel(int i) {
        double fuelLevel = this.waterTank.getFluid() == null ? 0.0 : (double)this.waterTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / (double)this.tankCapacity);
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public double getDistanceFromServer(double par1, double par3, double par5) {
        double d3 = (double)this.func_174877_v().func_177958_n() + 0.5 - par1;
        double d4 = (double)this.func_174877_v().func_177956_o() + 0.5 - par3;
        double d5 = (double)this.func_174877_v().func_177952_p() + 0.5 - par5;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            FluidStack liquid = FluidUtil.getFluidContained((ItemStack)((ItemStack)this.stacks.get(0)));
            if (FluidUtil.isFluidStrict((FluidStack)liquid, (String)FluidRegistry.WATER.getName())) {
                FluidUtil.loadFromContainer((FluidTank)this.waterTank, (Fluid)FluidRegistry.WATER, this.stacks, (int)0, (int)liquid.amount);
            }
            boolean bl = this.active = (double)this.bubbleSize == this.MAX_SIZE && this.hasEnoughEnergyToRun && !this.getFirstBonemealStack().func_190926_b() && this.waterTank.getFluid() != null && this.waterTank.getFluid().amount > 0;
        }
        if (!(this.field_145850_b.field_72995_K || this.active == this.lastActive && this.ticks % 60 != 0)) {
            this.terraformableBlocksList.clear();
            this.grassBlockList.clear();
            if (this.active) {
                int bubbleSize = (int)Math.ceil(this.bubbleSize);
                double bubbleSizeSq = this.bubbleSize;
                bubbleSizeSq *= bubbleSizeSq;
                boolean doGrass = !this.grassDisabled && !this.getFirstSeedStack().func_190926_b();
                boolean doTrees = !this.treesDisabled && !this.getFirstSaplingStack().func_190926_b();
                for (int x = this.func_174877_v().func_177958_n() - bubbleSize; x < this.func_174877_v().func_177958_n() + bubbleSize; ++x) {
                    for (int y = this.func_174877_v().func_177956_o() - bubbleSize; y < this.func_174877_v().func_177956_o() + bubbleSize; ++y) {
                        for (int z = this.func_174877_v().func_177952_p() - bubbleSize; z < this.func_174877_v().func_177952_p() + bubbleSize; ++z) {
                            BlockPos pos = new BlockPos(x, y, z);
                            Block blockID = this.field_145850_b.func_180495_p(pos).func_177230_c();
                            if (blockID == null || blockID.isAir(this.field_145850_b.func_180495_p(pos), (IBlockAccess)this.field_145850_b, pos) || !(this.getDistanceFromServer(x, y, z) < bubbleSizeSq)) continue;
                            if (doGrass && blockID instanceof ITerraformableBlock && ((ITerraformableBlock)blockID).isTerraformable(this.field_145850_b, pos)) {
                                this.terraformableBlocksList.add(new BlockPos(x, y, z));
                                continue;
                            }
                            if (!doTrees) continue;
                            Block blockIDAbove = this.field_145850_b.func_180495_p(pos.func_177984_a()).func_177230_c();
                            if (blockID != Blocks.field_150349_c || !blockIDAbove.isAir(this.field_145850_b.func_180495_p(pos.func_177984_a()), (IBlockAccess)this.field_145850_b, pos.func_177984_a())) continue;
                            this.grassBlockList.add(new BlockPos(x, y, z));
                        }
                    }
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && this.terraformableBlocksList.size() > 0 && this.ticks % 15 == 0) {
            ArrayList<BlockPos> terraformableBlocks2 = new ArrayList<BlockPos>(this.terraformableBlocksList);
            int randomIndex = this.field_145850_b.field_73012_v.nextInt(this.terraformableBlocksList.size());
            BlockPos vec = terraformableBlocks2.get(randomIndex);
            if (this.field_145850_b.func_180495_p(vec).func_177230_c() instanceof ITerraformableBlock) {
                BlockGrass id;
                switch (this.field_145850_b.field_73012_v.nextInt(40)) {
                    case 0: {
                        if (this.field_145850_b.func_175665_u(new BlockPos(vec.func_177958_n() - 1, vec.func_177956_o(), vec.func_177952_p())) && this.field_145850_b.func_175665_u(new BlockPos(vec.func_177958_n() + 1, vec.func_177956_o(), vec.func_177952_p())) && this.field_145850_b.func_175665_u(new BlockPos(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p() - 1)) && this.field_145850_b.func_175665_u(new BlockPos(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p() + 1))) {
                            id = Blocks.field_150358_i;
                            break;
                        }
                        id = Blocks.field_150349_c;
                        break;
                    }
                    default: {
                        id = Blocks.field_150349_c;
                    }
                }
                this.field_145850_b.func_175656_a(vec, id.func_176223_P());
                if (id == Blocks.field_150349_c) {
                    this.useCount[0] = this.useCount[0] + 1;
                    this.waterTank.drain(1, true);
                    this.checkUsage(1);
                } else if (id == Blocks.field_150358_i) {
                    this.checkUsage(2);
                }
            }
            this.terraformableBlocksList.remove(randomIndex);
        }
        if (!this.field_145850_b.field_72995_K && !this.treesDisabled && this.grassBlockList.size() > 0 && this.ticks % 50 == 0) {
            int randomIndex = this.field_145850_b.field_73012_v.nextInt(this.grassBlockList.size());
            BlockPos vecGrass = this.grassBlockList.get(randomIndex);
            if (this.field_145850_b.func_180495_p(vecGrass).func_177230_c() == Blocks.field_150349_c) {
                BlockPos vecSapling = vecGrass.func_177982_a(0, 1, 0);
                ItemStack sapling = this.getFirstSaplingStack();
                boolean flag = false;
                for (BlockPos testVec : this.grownTreesList) {
                    if (!(testVec.func_177951_i((Vec3i)vecSapling) < 9.0)) continue;
                    flag = true;
                    break;
                }
                if (!flag && sapling != null) {
                    Block b = Block.func_149634_a((Item)sapling.func_77973_b());
                    this.field_145850_b.func_180501_a(vecSapling, b.func_176203_a(sapling.func_77952_i()), 3);
                    if (b instanceof BlockSapling) {
                        if (this.field_145850_b.func_175671_l(vecSapling) >= 9) {
                            ((BlockSapling)b).func_176478_d(this.field_145850_b, vecSapling, this.field_145850_b.func_180495_p(vecSapling), this.field_145850_b.field_73012_v);
                            this.grownTreesList.add(new BlockPos(vecSapling.func_177958_n(), vecSapling.func_177956_o(), vecSapling.func_177952_p()));
                        }
                    } else if (b instanceof BlockBush && this.field_145850_b.func_175671_l(vecSapling) >= 5) {
                        for (int j = 0; j < 12; ++j) {
                            if (this.field_145850_b.func_180495_p(vecSapling).func_177230_c() != b) {
                                this.grownTreesList.add(new BlockPos(vecSapling.func_177958_n(), vecSapling.func_177956_o(), vecSapling.func_177952_p()));
                                break;
                            }
                            ((BlockBush)b).func_180650_b(this.field_145850_b, vecSapling, this.field_145850_b.func_180495_p(vecSapling), this.field_145850_b.field_73012_v);
                        }
                    }
                    this.useCount[1] = this.useCount[1] + 1;
                    this.waterTank.drain(50, true);
                    this.checkUsage(0);
                }
            }
            this.grassBlockList.remove(randomIndex);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.terraformableBlocksListSize = this.terraformableBlocksList.size();
            this.grassBlocksListSize = this.grassBlockList.size();
        }
        this.bubbleSize = this.hasEnoughEnergyToRun && (!this.grassDisabled || !this.treesDisabled) ? (float)Math.min((double)Math.max(0.0f, this.bubbleSize + 0.1f), this.MAX_SIZE) : (float)Math.min((double)Math.max(0.0f, this.bubbleSize - 0.1f), this.MAX_SIZE);
        this.lastActive = this.active;
    }

    public void addExtraNetworkedData(List<Object> networkedList) {
        if (!this.field_145850_b.field_72995_K) {
            networkedList.add(Float.valueOf(this.bubbleSize));
        }
    }

    public void readExtraNetworkedData(ByteBuf dataStream) {
        if (this.field_145850_b.field_72995_K) {
            this.bubbleSize = dataStream.readFloat();
        }
    }

    private void checkUsage(int type) {
        ItemStack stack = null;
        if ((this.useCount[0] + this.useCount[1]) % 4 == 0 && !(stack = this.getFirstBonemealStack()).func_190926_b()) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                this.stacks.set(this.getSelectiveStack(2, 6), (Object)ItemStack.field_190927_a);
            }
        }
        switch (type) {
            case 0: {
                stack = (ItemStack)this.stacks.get(this.saplingIndex);
                if (stack.func_190926_b()) break;
                stack.func_190918_g(1);
                if (!stack.func_190926_b()) break;
                this.stacks.set(this.saplingIndex, (Object)ItemStack.field_190927_a);
                break;
            }
            case 1: {
                if (this.useCount[0] % 4 != 0 || (stack = this.getFirstSeedStack()).func_190926_b()) break;
                stack.func_190918_g(1);
                if (!stack.func_190926_b()) break;
                this.stacks.set(this.getSelectiveStack(10, 14), (Object)ItemStack.field_190927_a);
                break;
            }
            case 2: {
                this.waterTank.drain(50, true);
            }
        }
    }

    private int getSelectiveStack(int start, int end) {
        for (int i = start; i < end; ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    private int getRandomStack(int start, int end) {
        int stackcount = 0;
        for (int i = start; i < end; ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
            ++stackcount;
        }
        if (stackcount == 0) {
            return -1;
        }
        int random = this.field_145850_b.field_73012_v.nextInt(stackcount);
        for (int i = start; i < end; ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
            if (random == 0) {
                return i;
            }
            --random;
        }
        return -1;
    }

    public ItemStack getFirstBonemealStack() {
        int index = this.getSelectiveStack(2, 6);
        if (index != -1) {
            return (ItemStack)this.stacks.get(index);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getFirstSaplingStack() {
        int index = this.getRandomStack(6, 10);
        if (index != -1) {
            this.saplingIndex = index;
            return (ItemStack)this.stacks.get(index);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getFirstSeedStack() {
        int index = this.getSelectiveStack(10, 14);
        if (index != -1) {
            return (ItemStack)this.stacks.get(index);
        }
        return ItemStack.field_190927_a;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.stacks = this.readStandardItemsFromNBT(nbt);
        this.bubbleSize = nbt.func_74760_g("BubbleSize");
        this.useCount = nbt.func_74759_k("UseCountArray");
        if (this.useCount.length == 0) {
            this.useCount = new int[2];
        }
        if (nbt.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(nbt.func_74775_l("waterTank"));
        }
        if (nbt.func_74764_b("bubbleVisible")) {
            this.setBubbleVisible(nbt.func_74767_n("bubbleVisible"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeStandardItemsToNBT(nbt, this.stacks);
        nbt.func_74776_a("BubbleSize", this.bubbleSize);
        nbt.func_74783_a("UseCountArray", this.useCount);
        if (this.waterTank.getFluid() != null) {
            nbt.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74757_a("bubbleVisible", this.shouldRenderBubble);
        return nbt;
    }

    public NonNullList<ItemStack> getContainingItems() {
        return this.stacks;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"container.tile_terraformer.name");
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 0) {
            return FluidUtil.isEmptyContainer((ItemStack)itemstack);
        }
        if (slotID == 1) {
            return ((ItemElectricBase)itemstack.func_77973_b()).getElectricityStored(itemstack) <= 0.0f;
        }
        return false;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                FluidStack stack = net.minecraftforge.fluids.FluidUtil.getFluidContained((ItemStack)itemstack);
                return stack != null && stack.getFluid() == FluidRegistry.WATER;
            }
            case 1: {
                return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return itemstack.func_77973_b() == Items.field_151100_aR && itemstack.func_77952_i() == 15;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return ContainerTerraformer.isOnSaplingList(itemstack);
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return itemstack.func_77973_b() == Items.field_151014_N;
            }
        }
        return false;
    }

    public boolean shouldUseEnergy() {
        return !this.grassDisabled || !this.treesDisabled;
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(1);
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown <= 0) {
            switch (index) {
                case 0: {
                    this.treesDisabled = !this.treesDisabled;
                    break;
                }
                case 1: {
                    this.grassDisabled = !this.grassDisabled;
                }
            }
            this.disableCooldown = 10;
        }
    }

    public boolean getDisabled(int index) {
        switch (index) {
            case 0: {
                return this.treesDisabled;
            }
            case 1: {
                return this.grassDisabled;
            }
        }
        return false;
    }

    public void setBubbleVisible(boolean shouldRender) {
        this.shouldRenderBubble = shouldRender;
    }

    public double getPacketRange() {
        return 64.0;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return (fluid == null || "water".equals(fluid.getName())) && from != this.getElectricInputDirection();
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (resource != null && this.canFill(from, resource.getFluid())) {
            used = this.waterTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)((float)this.func_174877_v().func_177958_n() - this.bubbleSize), (double)((float)this.func_174877_v().func_177956_o() - this.bubbleSize), (double)((float)this.func_174877_v().func_177952_p() - this.bubbleSize), (double)((float)this.func_174877_v().func_177958_n() + this.bubbleSize), (double)((float)this.func_174877_v().func_177956_o() + this.bubbleSize), (double)((float)this.func_174877_v().func_177952_p() + this.bubbleSize));
    }

    public float getBubbleSize() {
        return this.bubbleSize;
    }

    public boolean getBubbleVisible() {
        return this.shouldRenderBubble;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockMachineMars) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockMachineMars.FACING);
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing getElectricInputDirection() {
        return this.getFront().func_176746_e();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        if (type == NetworkType.FLUID) {
            return direction != this.getElectricInputDirection();
        }
        return false;
    }
}

