/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.tile;

import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IOxygenReceiver;
import micdoodle8.mods.galacticraft.api.transmission.tile.IOxygenStorage;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.fluid.FluidNetwork;
import micdoodle8.mods.galacticraft.core.fluid.NetworkHelper;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.asteroids.items.ItemAtmosphericValve;
import micdoodle8.mods.galacticraft.planets.mars.blocks.BlockMachineMarsT2;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityMethaneSynthesizer;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityElectrolyzer
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IDisableableMachine,
IFluidHandlerWrapper,
IOxygenStorage,
IOxygenReceiver {
    private final int tankCapacity = 4000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank = new FluidTank(this.tankCapacity);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank liquidTank = new FluidTank(this.tankCapacity);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank liquidTank2 = new FluidTank(this.tankCapacity);
    public int processTimeRequired = 3;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);

    public TileEntityElectrolyzer() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 150.0f : 120.0f);
        this.setTierGC(2);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            FluidStack liquid = FluidUtil.getFluidContained((ItemStack)((ItemStack)this.stacks.get(1)));
            if (FluidUtil.isFluidStrict((FluidStack)liquid, (String)FluidRegistry.WATER.getName())) {
                FluidUtil.loadFromContainer((FluidTank)this.waterTank, (Fluid)FluidRegistry.WATER, this.stacks, (int)1, (int)liquid.amount);
            }
            this.checkFluidTankTransfer(2, this.liquidTank);
            this.checkFluidTankTransfer(3, this.liquidTank2);
            if (this.hasEnoughEnergyToRun && this.canProcess()) {
                if (this.tierGC == 2) {
                    this.processTimeRequired = Math.max(1, 4 - this.poweredByTierGC);
                }
                if (this.processTicks == 0) {
                    this.processTicks = this.processTimeRequired;
                } else if (--this.processTicks <= 0) {
                    this.doElectrolysis();
                    this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                }
            } else {
                this.processTicks = 0;
            }
            this.produceOxygen(this.getOxygenOutputDirection());
            this.produceHydrogen(this.getHydrogenOutputDirection());
        }
    }

    private void doElectrolysis() {
        int waterAmount = this.waterTank.getFluid().amount;
        if (waterAmount == 0) {
            return;
        }
        this.placeIntoFluidTanks(2);
        this.waterTank.drain(1, true);
    }

    private int placeIntoFluidTanks(int amountToDrain) {
        int fuelSpace = this.liquidTank.getCapacity() - this.liquidTank.getFluidAmount();
        int fuelSpace2 = this.liquidTank2.getCapacity() - this.liquidTank2.getFluidAmount();
        int amountToDrain2 = amountToDrain * 2;
        if (amountToDrain > fuelSpace) {
            amountToDrain = fuelSpace;
        }
        this.liquidTank.fill(FluidRegistry.getFluidStack((String)"oxygen", (int)amountToDrain), true);
        if (amountToDrain2 > fuelSpace2) {
            amountToDrain2 = fuelSpace2;
        }
        this.liquidTank2.fill(FluidRegistry.getFluidStack((String)"hydrogen", (int)amountToDrain2), true);
        return amountToDrain;
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        if (!((ItemStack)this.stacks.get(slot)).func_190926_b() && ((ItemStack)this.stacks.get(slot)).func_77973_b() instanceof ItemAtmosphericValve) {
            tank.drain(4, true);
        }
    }

    public int getScaledGasLevel(int i) {
        return this.waterTank.getFluid() != null ? this.waterTank.getFluid().amount * i / this.waterTank.getCapacity() : 0;
    }

    public int getScaledFuelLevel(int i) {
        return this.liquidTank.getFluid() != null ? this.liquidTank.getFluid().amount * i / this.liquidTank.getCapacity() : 0;
    }

    public int getScaledFuelLevel2(int i) {
        return this.liquidTank2.getFluid() != null ? this.liquidTank2.getFluid().amount * i / this.liquidTank2.getCapacity() : 0;
    }

    public boolean canProcess() {
        if (this.waterTank.getFluid() == null || this.waterTank.getFluid().amount <= 0 || this.getDisabled(0)) {
            return false;
        }
        boolean tank1HasSpace = this.liquidTank.getFluidAmount() < this.liquidTank.getCapacity();
        boolean tank2HasSpace = this.liquidTank2.getFluidAmount() < this.liquidTank2.getCapacity();
        return tank1HasSpace || tank2HasSpace;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("processTicks");
        this.stacks = this.readStandardItemsFromNBT(nbt);
        if (nbt.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(nbt.func_74775_l("waterTank"));
        }
        if (nbt.func_74764_b("gasTank")) {
            this.liquidTank.readFromNBT(nbt.func_74775_l("gasTank"));
        }
        if (nbt.func_74764_b("gasTank2")) {
            this.liquidTank2.readFromNBT(nbt.func_74775_l("gasTank2"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("processTicks", this.processTicks);
        this.writeStandardItemsToNBT(nbt, this.stacks);
        if (this.waterTank.getFluid() != null) {
            nbt.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.liquidTank.getFluid() != null) {
            nbt.func_74782_a("gasTank", (NBTBase)this.liquidTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.liquidTank2.getFluid() != null) {
            nbt.func_74782_a("gasTank2", (NBTBase)this.liquidTank2.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    protected NonNullList<ItemStack> getContainingItems() {
        return this.stacks;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"tile.mars_machine.6.name");
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
                }
                case 1: {
                    return itemstack.func_77973_b() == Items.field_151131_as;
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return itemstack.func_77973_b() instanceof ItemElectricBase && ((ItemElectricBase)itemstack.func_77973_b()).getElectricityStored(itemstack) <= 0.0f;
                }
                case 1: {
                    return itemstack.func_77973_b() == Items.field_151133_ar;
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItem((Item)item);
            }
            case 1: {
                return item == Items.field_151133_ar || item == Items.field_151131_as;
            }
        }
        return false;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public double getPacketRange() {
        return 320.0;
    }

    public EnumFacing getElectricInputDirection() {
        return EnumFacing.DOWN;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (from == this.getHydrogenOutputDirection()) {
            return this.liquidTank2.getFluid() != null && this.liquidTank2.getFluidAmount() > 0;
        }
        if (from == this.getOxygenOutputDirection()) {
            return this.liquidTank.getFluid() != null && this.liquidTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (from == this.getHydrogenOutputDirection() && resource != null && resource.isFluidEqual(this.liquidTank2.getFluid())) {
            return this.liquidTank2.drain(resource.amount, doDrain);
        }
        if (from == this.getOxygenOutputDirection() && resource != null && resource.isFluidEqual(this.liquidTank.getFluid())) {
            return this.liquidTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (from == this.getHydrogenOutputDirection()) {
            return this.liquidTank2.drain(maxDrain, doDrain);
        }
        if (from == this.getOxygenOutputDirection()) {
            return this.liquidTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (from == this.getFront().func_176746_e()) {
            return fluid == null || fluid.getName().equals(FluidRegistry.WATER.getName());
        }
        return false;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (resource != null && this.canFill(from, resource.getFluid())) {
            used = this.waterTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{};
        if (from == this.getFront().func_176746_e()) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
        } else if (from == this.getHydrogenOutputDirection()) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.liquidTank2)};
        } else if (from == this.getOxygenOutputDirection()) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.liquidTank)};
        }
        return tankInfo;
    }

    public int func_145832_p() {
        return this.func_145838_q().func_176201_c(this.field_145850_b.func_180495_p(this.func_174877_v()));
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        return 0;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public int receiveGas(EnumFacing side, GasStack stack) {
        return 0;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public GasStack drawGas(EnumFacing from, int amount, boolean doTransfer) {
        if (from == this.getHydrogenOutputDirection() && this.liquidTank2.getFluid() != null) {
            int amountH = Math.min(8, this.liquidTank2.getFluidAmount());
            amountH = this.liquidTank2.drain((int)amountH, (boolean)doTransfer).amount;
            return new GasStack((Gas)EnergyConfigHandler.gasHydrogen, amountH);
        }
        if (from == this.getOxygenOutputDirection() && this.liquidTank.getFluid() != null) {
            int amountO = Math.min(8, this.liquidTank.getFluidAmount());
            amountO = this.liquidTank.drain((int)amountO, (boolean)doTransfer).amount;
            return new GasStack((Gas)EnergyConfigHandler.gasOxygen, amountO);
        }
        return null;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public GasStack drawGas(EnumFacing from, int amount) {
        return this.drawGas(from, amount, true);
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return false;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public boolean canDrawGas(EnumFacing from, Gas type) {
        if (from == this.getHydrogenOutputDirection()) {
            return type.getName().equals("hydrogen");
        }
        if (from == this.getOxygenOutputDirection()) {
            return type.getName().equals("oxygen");
        }
        return false;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.ITubeConnection", modID="mekanism")
    public boolean canTubeConnect(EnumFacing from) {
        if (from == this.getHydrogenOutputDirection()) {
            return true;
        }
        return from == this.getOxygenOutputDirection();
    }

    public void setOxygenStored(int amount) {
        this.liquidTank.setFluid(new FluidStack(AsteroidsModule.fluidOxygenGas, amount));
    }

    public int getOxygenStored() {
        return this.liquidTank.getFluidAmount();
    }

    public int getHydrogenStored() {
        return this.liquidTank2.getFluidAmount();
    }

    public int getMaxOxygenStored() {
        return this.liquidTank.getCapacity();
    }

    private EnumFacing getOxygenOutputDirection() {
        return this.getFront().func_176734_d();
    }

    private EnumFacing getHydrogenOutputDirection() {
        return this.getFront().func_176735_f();
    }

    private boolean produceOxygen(EnumFacing outputDirection) {
        int provide = this.getOxygenProvide(outputDirection);
        if (provide > 0) {
            float requestedOxygen;
            TileEntity outputTile = new BlockVec3((TileEntity)this).modifyPositionFromSide(outputDirection).getTileEntity((IBlockAccess)this.field_145850_b);
            FluidNetwork outputNetwork = NetworkHelper.getFluidNetworkFromTile((TileEntity)outputTile, (EnumFacing)outputDirection);
            if (outputNetwork != null) {
                int gasRequested = outputNetwork.getRequest();
                if (gasRequested > 0) {
                    int usedGas = outputNetwork.emitToBuffer(new FluidStack(GCFluids.fluidOxygenGas, Math.min(gasRequested, provide)), true);
                    this.drawOxygen(usedGas, true);
                    return true;
                }
            } else if (outputTile instanceof IOxygenReceiver && (requestedOxygen = (float)((IOxygenReceiver)outputTile).getOxygenRequest(outputDirection.func_176734_d())) > 0.0f) {
                int toSend = Math.min(this.getOxygenStored(), provide);
                int acceptedOxygen = ((IOxygenReceiver)outputTile).receiveOxygen(outputDirection.func_176734_d(), toSend, true);
                this.drawOxygen(acceptedOxygen, true);
                return true;
            }
        }
        return false;
    }

    private boolean produceHydrogen(EnumFacing outputDirection) {
        int provide = this.getHydrogenProvide(outputDirection);
        if (provide > 0) {
            float requestedHydrogen;
            TileEntity outputTile = new BlockVec3((TileEntity)this).modifyPositionFromSide(outputDirection).getTileEntity((IBlockAccess)this.field_145850_b);
            FluidNetwork outputNetwork = NetworkHelper.getFluidNetworkFromTile((TileEntity)outputTile, (EnumFacing)outputDirection);
            if (outputNetwork != null) {
                int gasRequested = outputNetwork.getRequest();
                if (gasRequested > 0) {
                    int usedGas = outputNetwork.emitToBuffer(new FluidStack(FluidRegistry.getFluid((String)"hydrogen"), Math.min(gasRequested, provide)), true);
                    this.drawHydrogen(usedGas, true);
                    return true;
                }
            } else if (outputTile instanceof TileEntityMethaneSynthesizer && (requestedHydrogen = (float)((TileEntityMethaneSynthesizer)outputTile).getHydrogenRequest(outputDirection.func_176734_d())) > 0.0f) {
                int toSend = Math.min(this.getHydrogenStored(), provide);
                int acceptedHydrogen = ((TileEntityMethaneSynthesizer)outputTile).receiveHydrogen(outputDirection.func_176734_d(), toSend, true);
                this.drawHydrogen(acceptedHydrogen, true);
                return true;
            }
        }
        return false;
    }

    public int provideOxygen(EnumFacing from, int request, boolean doProvide) {
        if (this.getOxygenOutputDirection() == from) {
            return this.drawOxygen(request, doProvide);
        }
        return 0;
    }

    public int drawOxygen(int request, boolean doProvide) {
        if (request > 0) {
            int requestedOxygen = Math.min(request, this.liquidTank.getFluidAmount());
            if (doProvide) {
                this.setOxygenStored(this.liquidTank.getFluidAmount() - requestedOxygen);
            }
            return requestedOxygen;
        }
        return 0;
    }

    public int drawHydrogen(int request, boolean doProvide) {
        if (request > 0) {
            int currentHydrogen = this.liquidTank2.getFluidAmount();
            int requestedHydrogen = Math.min(request, currentHydrogen);
            if (doProvide) {
                this.liquidTank2.setFluid(new FluidStack(FluidRegistry.getFluid((String)"hydrogen"), currentHydrogen - requestedHydrogen));
            }
            return requestedHydrogen;
        }
        return 0;
    }

    public int getOxygenProvide(EnumFacing direction) {
        return this.getOxygenOutputDirection() == direction ? Math.min(500, this.getOxygenStored()) : 0;
    }

    public int getHydrogenProvide(EnumFacing direction) {
        return this.getHydrogenOutputDirection() == direction ? Math.min(500, this.getHydrogenStored()) : 0;
    }

    public boolean shouldPullOxygen() {
        return false;
    }

    public int receiveOxygen(EnumFacing from, int receive, boolean doReceive) {
        return 0;
    }

    public int getOxygenRequest(EnumFacing direction) {
        return 0;
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.FLUID) {
            return this.getOxygenOutputDirection() == direction || this.getHydrogenOutputDirection() == direction || direction == this.getFront().func_176746_e();
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockMachineMarsT2) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockMachineMarsT2.FACING);
        }
        return EnumFacing.NORTH;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }
}

