/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.blocks;

import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntitySlimelingEgg;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSlimelingEgg
extends Block
implements ITileEntityProvider,
IShiftDescription,
ISortableBlock {
    public static final PropertyEnum EGG_COLOR = PropertyEnum.func_177709_a((String)"eggcolor", EnumEggColor.class);
    public static final PropertyBool BROKEN = PropertyBool.func_177716_a((String)"broken");
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.625, 0.75);

    public BlockSlimelingEgg(String assetName) {
        super(Material.field_151576_e);
        this.func_149663_c(assetName);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)EGG_COLOR, (Comparable)((Object)EnumEggColor.RED)).func_177226_a((IProperty)BROKEN, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos);
    }

    private boolean beginHatch(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        int l = state.func_177230_c().func_176201_c(state);
        if (l < 3) {
            world.func_180501_a(pos, state.func_177230_c().func_176203_a(l + 3), 2);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntitySlimelingEgg) {
                ((TileEntitySlimelingEgg)tile).timeToHatch = world.field_73012_v.nextInt(50) + 20;
                ((TileEntitySlimelingEgg)tile).lastTouchedPlayerUUID = player.func_110124_au().toString();
                ((TileEntitySlimelingEgg)tile).lastTouchedPlayerName = player.func_70005_c_();
            }
            world.func_175704_b(pos, pos);
            return true;
        }
        world.func_175704_b(pos, pos);
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        ItemStack currentStack = player.func_184607_cu();
        if (currentStack != null && currentStack.func_77973_b() instanceof ItemPickaxe) {
            return world.func_175698_g(pos);
        }
        if (player.field_71075_bZ.field_75098_d) {
            return world.func_175698_g(pos);
        }
        this.beginHatch(world, pos, player);
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.beginHatch(worldIn, pos, playerIn);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        ItemStack currentStack = player.func_184607_cu();
        if (!currentStack.func_190926_b() && currentStack.func_77973_b() instanceof ItemPickaxe) {
            player.func_71029_a(StatList.func_188055_a((Block)this));
            player.func_71020_j(0.025f);
            this.func_176226_b(worldIn, pos, state.func_177230_c().func_176203_a(state.func_177230_c().func_176201_c(state) % 3), 0);
            if (currentStack.func_77973_b() == MarsItems.deshPickaxe && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
                ItemStack itemstack = new ItemStack(MarsItems.deshPickSlime, 1, currentStack.func_77952_i());
                if (currentStack.func_77978_p() != null) {
                    itemstack.func_77982_d(currentStack.func_77978_p().func_74737_b());
                }
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, itemstack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int var4 = 0; var4 < EnumEggColor.values().length; ++var4) {
            list.add((Object)new ItemStack(itemIn, 1, var4));
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySlimelingEgg();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int metadata = state.func_177230_c().func_176201_c(state);
        if (metadata == 3) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, 0);
        }
        if (metadata == 4) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, 1);
        }
        if (metadata == 5) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, 2);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate((String)(this.func_149739_a() + ".description"));
    }

    public boolean showDescription(int meta) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)EGG_COLOR, (Comparable)((Object)EnumEggColor.values()[meta % 3])).func_177226_a((IProperty)BROKEN, (Comparable)Boolean.valueOf(meta - 3 >= 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumEggColor)((Object)state.func_177229_b((IProperty)EGG_COLOR))).getMeta() + ((Boolean)state.func_177229_b((IProperty)BROKEN) != false ? 3 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EGG_COLOR, BROKEN});
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.EGG;
    }

    public static enum EnumEggColor implements IStringSerializable
    {
        RED(0, "red"),
        BLUE(1, "blue"),
        YELLOW(2, "yellow");

        private final int meta;
        private final String name;

        private EnumEggColor(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

