/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.tile;

import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityAstroMiner;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMinerBase
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IMultiBlock,
IMachineSides {
    public static final int HOLDSIZE = 72;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)73, (Object)ItemStack.field_190927_a);
    private int[] slotArray;
    public boolean isMaster = false;
    public EnumFacing facing = EnumFacing.NORTH;
    private BlockPos mainBlockPosition;
    private LinkedList<BlockVec3> targetPoints = new LinkedList();
    private WeakReference<TileEntityMinerBase> masterTile = null;
    public boolean updateClientFlag;
    public boolean findTargetPointsFlag;
    public int linkCountDown = 0;
    public static Map<Integer, List<BlockPos>> newMinerBases = new HashMap<Integer, List<BlockPos>>();
    private AxisAlignedBB renderAABB;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int linkedMinerDataAIState;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int linkedMinerDataDX;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int linkedMinerDataDY;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int linkedMinerDataDZ;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int linkedMinerDataCount;
    public int numUsingPlayers;
    private int ticksSinceSync;
    private boolean spawnedMiner = false;
    public EntityAstroMiner linkedMiner = null;
    public UUID linkedMinerID = null;
    private boolean initialised;

    public static void checkNewMinerBases() {
        Iterator<Map.Entry<Integer, List<BlockPos>>> entries = newMinerBases.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<Integer, List<BlockPos>> entry = entries.next();
            if (entry.getValue().isEmpty()) continue;
            WorldServer w = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(entry.getKey().intValue());
            if (w == null) {
                GCLog.severe((String)("Astro Miner Base placement: Unable to find server world for dim " + entry.getKey()));
                entries.remove();
                continue;
            }
            for (BlockPos posMain : entry.getValue()) {
                BlockPos master = new BlockPos((Vec3i)posMain);
                for (int x = 0; x < 2; ++x) {
                    for (int y = 0; y < 2; ++y) {
                        for (int z = 0; z < 2; ++z) {
                            BlockPos pos = posMain.func_177982_a(x, y, z);
                            w.func_180501_a(pos, AsteroidBlocks.minerBaseFull.func_176223_P(), 2);
                            TileEntity tile = w.func_175625_s(pos);
                            if (!(tile instanceof TileEntityMinerBase)) continue;
                            ((TileEntityMinerBase)tile).setMainBlockPos(master);
                            ((TileEntityMinerBase)tile).updateClientFlag = true;
                        }
                    }
                }
            }
            entry.getValue().clear();
        }
    }

    public static void addNewMinerBase(int dimID, BlockPos blockPos) {
        if (newMinerBases.containsKey(dimID)) {
            newMinerBases.get(dimID).add(blockPos);
        } else {
            ArrayList blockPositions = Lists.newArrayList();
            newMinerBases.put(dimID, blockPositions);
            blockPositions.add(blockPos);
        }
    }

    public void setMainBlockPosition(BlockPos mainBlockPosition) {
        this.mainBlockPosition = mainBlockPosition;
    }

    public TileEntityMinerBase() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 20.0f : 12.0f);
        this.slotArray = new int[72];
        for (int i = 0; i < 72; ++i) {
            this.slotArray[i] = i + 1;
        }
    }

    public void func_73660_a() {
        TileEntityMinerBase master;
        super.func_73660_a();
        if (!this.initialised) {
            this.initialised = true;
            if (!this.field_145850_b.field_72995_K && !this.isMaster && this.getMaster() == null) {
                this.field_145850_b.func_180501_a(this.func_174877_v(), AsteroidBlocks.blockMinerBase.func_176223_P(), 2);
            }
        }
        if (this.updateClientFlag) {
            assert (!this.field_145850_b.field_72995_K);
            this.updateAllInDimension();
            this.updateClientFlag = false;
        }
        if (this.findTargetPointsFlag) {
            if (this.isMaster && this.linkedMiner != null) {
                this.findTargetPoints();
            }
            this.findTargetPointsFlag = false;
        }
        if (!this.isMaster && (master = this.getMaster()) != null) {
            float energyLimit = master.storage.getCapacityGC() - master.storage.getEnergyStoredGC();
            if (energyLimit < 0.0f) {
                energyLimit = 0.0f;
            }
            this.storage.setCapacity(energyLimit);
            this.storage.setMaxExtract(energyLimit);
            this.storage.setMaxReceive(energyLimit);
            float hasEnergy = this.getEnergyStoredGC();
            if (hasEnergy > 0.0f) {
                this.extractEnergyGC(null, master.receiveEnergyGC(null, hasEnergy, false), false);
            }
        }
        if (this.linkCountDown > 0) {
            --this.linkCountDown;
        }
        if (this.isMaster && !this.field_145850_b.field_72995_K) {
            this.updateGUIstate();
        }
    }

    public void updateGUIstate() {
        if (this.linkedMinerID == null) {
            this.linkedMinerDataAIState = -3;
            return;
        }
        EntityAstroMiner miner = this.linkedMiner;
        if (miner == null || miner.field_70128_L) {
            this.linkedMinerDataAIState = -3;
            return;
        }
        if (this.linkCountDown > 0) {
            this.linkedMinerDataAIState = -2;
            return;
        }
        this.linkedMinerDataAIState = miner.AIstate;
        this.linkedMinerDataDX = MathHelper.func_76128_c((double)this.linkedMiner.field_70165_t) - this.func_174877_v().func_177958_n() - 1;
        this.linkedMinerDataDY = MathHelper.func_76128_c((double)this.linkedMiner.field_70163_u) - this.func_174877_v().func_177956_o() - 1;
        this.linkedMinerDataDZ = MathHelper.func_76128_c((double)this.linkedMiner.field_70161_v) - this.func_174877_v().func_177952_p() - 1;
        this.linkedMinerDataCount = miner.mineCount;
    }

    protected void initialiseMultiTiles(BlockPos pos, World world) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(pos, positions);
        for (BlockPos vecToAdd : positions) {
            TileEntity tile = world.func_175625_s(vecToAdd);
            if (!(tile instanceof TileEntityMinerBase)) continue;
            ((TileEntityMinerBase)tile).mainBlockPosition = pos;
        }
    }

    public boolean spawnMiner(EntityPlayerMP player) {
        if (this.isMaster) {
            if (this.linkedMiner != null && this.linkedMiner.field_70128_L) {
                this.unlinkMiner();
            }
            if (this.linkedMinerID == null && EntityAstroMiner.spawnMinerAtBase(this.field_145850_b, this.func_174877_v().func_177958_n() + 1, this.func_174877_v().func_177956_o() + 1, this.func_174877_v().func_177952_p() + 1, this.facing, new BlockVec3((TileEntity)this), player)) {
                this.findTargetPoints();
                return true;
            }
            return false;
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.spawnMiner(player);
        }
        return false;
    }

    public TileEntityMinerBase getMaster() {
        TileEntityMinerBase master;
        if (this.mainBlockPosition == null) {
            return null;
        }
        if (this.masterTile == null) {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.mainBlockPosition);
            if (tileEntity instanceof TileEntityMinerBase) {
                this.masterTile = new WeakReference<TileEntityMinerBase>((TileEntityMinerBase)tileEntity);
            }
            if (this.masterTile == null) {
                return null;
            }
        }
        if ((master = (TileEntityMinerBase)((Object)this.masterTile.get())) != null && master.isMaster) {
            return master;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.stacks = this.readStandardItemsFromNBT(nbt);
        this.isMaster = nbt.func_74767_n("isMaster");
        if (this.isMaster) {
            this.updateClientFlag = true;
        } else {
            NBTTagCompound tagCompound = nbt.func_74775_l("masterpos");
            if (tagCompound.func_150296_c().isEmpty()) {
                this.setMainBlockPosition(null);
            } else {
                this.setMainBlockPosition(new BlockPos(tagCompound.func_74762_e("x"), tagCompound.func_74762_e("y"), tagCompound.func_74762_e("z")));
                this.updateClientFlag = true;
            }
        }
        this.facing = EnumFacing.func_176731_b((int)nbt.func_74762_e("facing"));
        this.linkedMinerID = nbt.func_150297_b("LinkedUUIDMost", 4) && nbt.func_150297_b("LinkedUUIDLeast", 4) ? new UUID(nbt.func_74763_f("LinkedUUIDMost"), nbt.func_74763_f("LinkedUUIDLeast")) : null;
        if (nbt.func_74764_b("TargetPoints")) {
            this.targetPoints.clear();
            NBTTagList mpList = nbt.func_150295_c("TargetPoints", 10);
            for (int j = 0; j < mpList.func_74745_c(); ++j) {
                NBTTagCompound bvTag = mpList.func_150305_b(j);
                this.targetPoints.add(BlockVec3.readFromNBT((NBTTagCompound)bvTag));
            }
        } else {
            this.findTargetPointsFlag = this.isMaster;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeStandardItemsToNBT(nbt, this.stacks);
        nbt.func_74757_a("isMaster", this.isMaster);
        if (!this.isMaster && this.mainBlockPosition != null) {
            NBTTagCompound masterTag = new NBTTagCompound();
            masterTag.func_74768_a("x", this.mainBlockPosition.func_177958_n());
            masterTag.func_74768_a("y", this.mainBlockPosition.func_177956_o());
            masterTag.func_74768_a("z", this.mainBlockPosition.func_177952_p());
            nbt.func_74782_a("masterpos", (NBTBase)masterTag);
        }
        nbt.func_74768_a("facing", this.facing.func_176736_b());
        if (this.isMaster && this.linkedMinerID != null) {
            nbt.func_74772_a("LinkedUUIDMost", this.linkedMinerID.getMostSignificantBits());
            nbt.func_74772_a("LinkedUUIDLeast", this.linkedMinerID.getLeastSignificantBits());
        }
        NBTTagList mpList = new NBTTagList();
        for (int j = 0; j < this.targetPoints.size(); ++j) {
            mpList.func_74742_a((NBTBase)this.targetPoints.get(j).writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("TargetPoints", (NBTBase)mpList);
        return nbt;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean addToInventory(ItemStack itemstack) {
        ItemStack existingStack;
        int k;
        boolean flag1 = false;
        int invSize = this.func_70302_i_();
        if (itemstack.func_77985_e()) {
            for (k = 1; !itemstack.func_190926_b() && k < invSize; ++k) {
                existingStack = (ItemStack)this.stacks.get(k);
                if (existingStack.func_190926_b() || existingStack.func_77973_b() != itemstack.func_77973_b() || itemstack.func_77981_g() && itemstack.func_77952_i() != existingStack.func_77952_i() || !ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)existingStack)) continue;
                int combined = existingStack.func_190916_E() + itemstack.func_190916_E();
                if (combined <= itemstack.func_77976_d()) {
                    itemstack.func_190920_e(0);
                    existingStack.func_190920_e(combined);
                    flag1 = true;
                    continue;
                }
                if (existingStack.func_190916_E() >= itemstack.func_77976_d()) continue;
                itemstack.func_190918_g(itemstack.func_77976_d() - existingStack.func_190916_E());
                existingStack.func_190920_e(itemstack.func_77976_d());
                flag1 = true;
            }
        }
        if (!itemstack.func_190926_b()) {
            for (k = 1; k < invSize; ++k) {
                existingStack = (ItemStack)this.stacks.get(k);
                if (!existingStack.func_190926_b()) continue;
                this.stacks.set(k, (Object)itemstack.func_77946_l());
                itemstack.func_190920_e(0);
                flag1 = true;
                break;
            }
        }
        this.func_70296_d();
        return flag1;
    }

    public void onLoad() {
        this.clientOnLoad();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"tile.miner_base.name");
    }

    public double getPacketRange() {
        return 20.0;
    }

    public int getPacketCooldown() {
        return 3;
    }

    public boolean isNetworkedTile() {
        return true;
    }

    protected NonNullList<ItemStack> getContainingItems() {
        if (this.isMaster) {
            return this.stacks;
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.getContainingItems();
        }
        return this.stacks;
    }

    public boolean shouldUseEnergy() {
        return false;
    }

    public void setMainBlockPos(BlockPos master) {
        this.masterTile = null;
        if (this.func_174877_v().equals((Object)master)) {
            this.isMaster = true;
            this.setMainBlockPosition(null);
            return;
        }
        this.isMaster = false;
        this.setMainBlockPosition(master);
        this.func_70296_d();
    }

    public void onBlockRemoval() {
        if (this.isMaster) {
            this.func_145843_s();
            this.onDestroy((TileEntity)this);
            return;
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null && !master.func_145837_r()) {
            this.field_145850_b.func_175655_b(master.func_174877_v(), false);
        }
    }

    public boolean onActivated(EntityPlayer entityPlayer) {
        if (this.isMaster) {
            ItemStack holding = entityPlayer.func_184607_cu();
            if (holding != null && holding.func_77973_b() == AsteroidsItems.astroMiner) {
                return false;
            }
            entityPlayer.openGui((Object)GalacticraftPlanets.instance, 3, this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            return true;
        }
        TileEntityMinerBase master = this.getMaster();
        return master != null && master.onActivated(entityPlayer);
    }

    public void onCreate(World world, BlockPos placedPosition) {
    }

    public BlockMulti.EnumBlockMultiType getMultiType() {
        return BlockMulti.EnumBlockMultiType.MINER_BASE;
    }

    public void getPositions(BlockPos placedPosition, List<BlockPos> positions) {
        for (int y = 0; y < 2 && placedPosition.func_177956_o() + y < this.field_145850_b.func_72800_K(); ++y) {
            for (int x = 0; x < 2; ++x) {
                for (int z = 0; z < 2; ++z) {
                    if (x + y + z == 0) continue;
                    positions.add(new BlockPos(placedPosition.func_177958_n() + x, placedPosition.func_177956_o() + y, placedPosition.func_177952_p() + z));
                }
            }
        }
    }

    public void onDestroy(TileEntity callingBlock) {
        BlockPos thisBlock = this.func_174877_v();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(thisBlock, positions);
        for (BlockPos pos : positions) {
            IBlockState stateAt = this.field_145850_b.func_180495_p(pos);
            if (stateAt.func_177230_c() != AsteroidBlocks.minerBaseFull) continue;
            if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
                FMLClientHandler.instance().getClient().field_71452_i.func_180533_a(pos, this.field_145850_b.func_180495_p(pos));
            }
            this.field_145850_b.func_175655_b(pos, false);
        }
        this.field_145850_b.func_175655_b(thisBlock, true);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(2, 2, 2));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 262144.0;
    }

    public void updateFacing() {
        if (this.isMaster && this.linkedMinerID == null) {
            switch (this.facing) {
                case SOUTH: {
                    this.facing = EnumFacing.WEST;
                    break;
                }
                case EAST: {
                    this.facing = EnumFacing.SOUTH;
                    break;
                }
                case WEST: {
                    this.facing = EnumFacing.NORTH;
                    break;
                }
                case NORTH: {
                    this.facing = EnumFacing.EAST;
                }
            }
            super.updateFacing();
        } else {
            TileEntityMinerBase master = this.getMaster();
            if (master != null) {
                master.updateFacing();
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.updateAllInDimension();
        }
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos offset = this.func_174877_v().func_177972_a(facing);
            TileEntity tileOffset = this.field_145850_b.func_175625_s(offset);
            if (tileOffset == null || tileOffset instanceof TileEntityMinerBase) continue;
            IBlockState state = this.field_145850_b.func_180495_p(offset);
            state.func_177230_c().func_189540_a(state, this.field_145850_b, offset, this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c(), this.func_174877_v());
            this.field_145850_b.func_175704_b(offset, offset);
        }
        this.func_70296_d();
    }

    public void buildDataPacket(int[] data) {
        int z;
        int y;
        int x;
        if (this.mainBlockPosition != null) {
            x = this.mainBlockPosition.func_177958_n();
            y = this.mainBlockPosition.func_177956_o();
            z = this.mainBlockPosition.func_177952_p();
        } else {
            x = this.func_174877_v().func_177958_n();
            y = this.func_174877_v().func_177956_o();
            z = this.func_174877_v().func_177952_p();
        }
        int link = this.linkedMinerID != null ? 8 : 0;
        data[0] = link + this.facing.ordinal();
        data[1] = x;
        data[2] = y;
        data[3] = z;
    }

    public EnumFacing getElectricInputDirection() {
        if (this.isMaster) {
            return this.facing.func_176734_d();
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.facing.func_176734_d();
        }
        return null;
    }

    public void linkMiner(EntityAstroMiner entityAstroMiner) {
        this.linkedMiner = entityAstroMiner;
        this.linkedMinerID = this.linkedMiner.func_110124_au();
        this.updateClientFlag = true;
        this.func_70296_d();
    }

    public void unlinkMiner() {
        this.linkedMiner = null;
        this.linkedMinerID = null;
        this.updateClientFlag = true;
        this.func_70296_d();
    }

    public UUID getLinkedMiner() {
        if (this.isMaster) {
            return this.linkedMinerID;
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.linkedMinerID;
        }
        return null;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (this.isMaster) {
            return side != this.facing ? this.slotArray : new int[]{};
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.func_180463_a(side);
        }
        return new int[0];
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (this.isMaster) {
            if (side != this.facing) {
                return slotID > 0 || ItemElectricBase.isElectricItemEmpty((ItemStack)itemstack);
            }
            return false;
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.func_180461_b(slotID, itemstack, side);
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (this.isMaster) {
            return slotID > 0 || ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.func_94041_b(slotID, itemstack);
        }
        return false;
    }

    public ItemStack func_70301_a(int par1) {
        if (this.isMaster) {
            return super.func_70301_a(par1);
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.func_70301_a(par1);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.isMaster) {
            return super.func_70298_a(par1, par2);
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.func_70298_a(par1, par2);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.isMaster) {
            return super.func_70304_b(par1);
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.func_70304_b(par1);
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        if (this.isMaster) {
            super.func_70299_a(par1, par2ItemStack);
            return;
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            master.func_70299_a(par1, par2ItemStack);
        }
    }

    public ItemStack getBatteryInSlot() {
        if (this.isMaster) {
            return this.func_70301_a(0);
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            master.getBatteryInSlot();
        }
        return null;
    }

    public int func_70302_i_() {
        return 73;
    }

    public BlockVec3 findNextTarget() {
        if (!this.targetPoints.isEmpty()) {
            BlockVec3 pos = this.targetPoints.removeFirst();
            this.func_70296_d();
            if (pos != null) {
                return pos.clone();
            }
        }
        return null;
    }

    private void findTargetPoints() {
        ArrayList<BlockVec3> roids;
        this.targetPoints.clear();
        BlockVec3 posnTarget = new BlockVec3((TileEntity)this);
        if (this.field_145850_b.field_73011_w instanceof WorldProviderAsteroids && (roids = ((WorldProviderAsteroids)this.field_145850_b.field_73011_w).getClosestAsteroidsXZ(posnTarget.x, posnTarget.y, posnTarget.z, this.facing.func_176745_a(), 100)) != null && roids.size() > 0) {
            this.targetPoints.addAll(roids);
            return;
        }
        posnTarget.modifyPositionFromSide(this.facing, this.field_145850_b.field_73012_v.nextInt(16) + 32);
        int miny = Math.min(this.func_174877_v().func_177956_o() * 2 - 90, this.func_174877_v().func_177956_o() - 22);
        if (miny < 5) {
            miny = 5;
        }
        posnTarget.y = miny + 5 + this.field_145850_b.field_73012_v.nextInt(4);
        this.targetPoints.add(posnTarget);
        EnumFacing lateral = EnumFacing.NORTH;
        EnumFacing inLine = this.facing;
        if (inLine.func_176740_k() == EnumFacing.Axis.Z) {
            lateral = EnumFacing.WEST;
        }
        this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, 13));
        this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, -13));
        if (posnTarget.y > 17) {
            this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, 7).modifyPositionFromSide(EnumFacing.DOWN, 11));
            this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, -7).modifyPositionFromSide(EnumFacing.DOWN, 11));
        } else {
            this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, 26));
            this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, -26));
        }
        this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, 7).modifyPositionFromSide(EnumFacing.UP, 11));
        this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, -7).modifyPositionFromSide(EnumFacing.UP, 11));
        if (posnTarget.y < this.func_174877_v().func_177956_o() - 38) {
            this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, 13).modifyPositionFromSide(EnumFacing.UP, 22));
            this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(EnumFacing.UP, 22));
            this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, -13).modifyPositionFromSide(EnumFacing.UP, 22));
        }
        int s = this.targetPoints.size();
        for (int i = 0; i < s; ++i) {
            this.targetPoints.add(this.targetPoints.get(i).clone().modifyPositionFromSide(inLine, 30));
        }
        this.func_70296_d();
    }

    public void setDisabled(int index, boolean disabled) {
        TileEntityMinerBase master;
        if (!this.isMaster) {
            master = this.getMaster();
            if (master == null) {
                return;
            }
        } else {
            master = this;
        }
        if (master.linkedMiner != null) {
            master.linkedMiner.recall();
        }
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public EnumFacing getFront() {
        return this.facing;
    }

    public void updateClient(List<Object> data) {
        int data1 = (Integer)data.get(1);
        this.facing = EnumFacing.func_82600_a((int)(data1 & 7));
        this.setMainBlockPos(new BlockPos(((Integer)data.get(2)).intValue(), ((Integer)data.get(3)).intValue(), ((Integer)data.get(4)).intValue()));
        this.linkedMinerID = data1 > 7 ? UUID.randomUUID() : null;
    }

    public IMachineSidesProperties getConfigurationType() {
        return IMachineSidesProperties.NOT_CONFIGURABLE;
    }

    public IMachineSides.MachineSide[] listConfigurableSides() {
        return null;
    }

    public IMachineSides.Face[] listDefaultFaces() {
        return null;
    }

    public IMachineSides.MachineSidePack[] getAllMachineSides() {
        return null;
    }

    public void setupMachineSides(int length) {
    }
}

