/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.tile;

import com.google.common.collect.Lists;
import java.util.List;
import micdoodle8.mods.galacticraft.api.power.EnergySource;
import micdoodle8.mods.galacticraft.api.power.IEnergyHandlerGC;
import micdoodle8.mods.galacticraft.api.power.ILaserNode;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorage;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorageTile;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseConductor;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.tile.ReceiverMode;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamOutput;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBeamReceiver
extends TileEntityBeamOutput
implements IEnergyHandlerGC,
ILaserNode {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public EnumFacing facing = null;
    private int preLoadFacing = -1;
    private float maxRate = 1500.0f;
    private EnergyStorage storage = new EnergyStorage(10.0f * this.maxRate, this.maxRate);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int modeReceive = ReceiverMode.UNDEFINED.ordinal();
    public Vector3 color = new Vector3(0.0, 1.0, 0.0);
    private AxisAlignedBB renderAABB;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.preLoadFacing != -1) {
            this.setFacing(EnumFacing.func_82600_a((int)this.preLoadFacing));
            this.preLoadFacing = -1;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.getTarget() != null && this.modeReceive == ReceiverMode.EXTRACT.ordinal() && this.facing != null) {
                float availableToSend;
                TileEntity tile = this.getAttachedTile();
                if (tile instanceof TileBaseUniversalElectricalSource) {
                    TileBaseUniversalElectricalSource electricalTile = (TileBaseUniversalElectricalSource)tile;
                    if (electricalTile.storage.getEnergyStoredGC() > 0.0f) {
                        EnergySource.EnergySourceAdjacent source = new EnergySource.EnergySourceAdjacent(EnumFacing.func_82600_a((int)(this.facing.func_176745_a() ^ 1)));
                        float toSend = Math.min(electricalTile.storage.getMaxExtract(), electricalTile.storage.getEnergyStoredGC());
                        float transmitted = this.getTarget().receiveEnergyGC((EnergySource)new EnergySource.EnergySourceWireless((List)Lists.newArrayList((Object[])new ILaserNode[]{this})), toSend, false);
                        electricalTile.extractEnergyGC((EnergySource)source, transmitted, false);
                    }
                } else if (!(tile instanceof EnergyStorageTile) && !(tile instanceof TileBaseConductor) && (availableToSend = EnergyUtil.otherModsEnergyExtract((TileEntity)tile, (EnumFacing)this.facing, (float)this.maxRate, (boolean)true)) > 0.0f) {
                    float transmitted = this.getTarget().receiveEnergyGC((EnergySource)new EnergySource.EnergySourceWireless((List)Lists.newArrayList((Object[])new ILaserNode[]{this})), availableToSend, false);
                    EnergyUtil.otherModsEnergyExtract((TileEntity)tile, (EnumFacing)this.facing, (float)transmitted, (boolean)false);
                }
            } else if (this.modeReceive == ReceiverMode.RECEIVE.ordinal() && this.storage.getEnergyStoredGC() > 0.0f) {
                float maxTransfer = Math.min(this.storage.getEnergyStoredGC(), this.maxRate * 5.0f);
                if (maxTransfer < 0.01f) {
                    this.storage.extractEnergyGCnoMax(maxTransfer, false);
                } else {
                    float otherModTransferred;
                    TileEntity tileAdj = this.getAttachedTile();
                    if (tileAdj instanceof TileBaseUniversalElectrical) {
                        TileBaseUniversalElectrical electricalTile = (TileBaseUniversalElectrical)tileAdj;
                        EnergySource.EnergySourceAdjacent source = new EnergySource.EnergySourceAdjacent(this.facing.func_176734_d());
                        this.storage.extractEnergyGCnoMax(electricalTile.receiveEnergyGC((EnergySource)source, maxTransfer, false), false);
                    } else if (!(tileAdj instanceof EnergyStorageTile) && !(tileAdj instanceof TileBaseConductor) && (otherModTransferred = EnergyUtil.otherModsEnergyTransfer((TileEntity)tileAdj, (EnumFacing)this.facing, (float)maxTransfer, (boolean)false)) > 0.0f) {
                        this.storage.extractEnergyGCnoMax(otherModTransferred, false);
                    }
                }
            }
        }
    }

    public double getPacketRange() {
        return 24.0;
    }

    public int getPacketCooldown() {
        return 3;
    }

    public boolean isNetworkedTile() {
        return true;
    }

    public Vector3 getInputPoint() {
        Vector3 headVec = new Vector3((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        if (this.facing != null) {
            headVec.x += (double)((float)this.facing.func_82601_c() * 0.1f);
            headVec.y += (double)((float)this.facing.func_96559_d() * 0.1f);
            headVec.z += (double)((float)this.facing.func_82599_e() * 0.1f);
        }
        return headVec;
    }

    public Vector3 getOutputPoint(boolean offset) {
        Vector3 headVec = new Vector3((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        if (this.facing != null) {
            headVec.x += (double)((float)this.facing.func_82601_c() * 0.1f);
            headVec.y += (double)((float)this.facing.func_96559_d() * 0.1f);
            headVec.z += (double)((float)this.facing.func_82599_e() * 0.1f);
        }
        return headVec;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    public TileEntity getAttachedTile() {
        if (this.facing == null) {
            return null;
        }
        TileEntity tile = new BlockVec3((TileEntity)this).getTileEntityOnSide(this.field_145850_b, this.facing);
        if (tile == null || tile.func_145837_r()) {
            this.setFacing(null);
        }
        if (tile instanceof IConductor) {
            this.setFacing(null);
            return null;
        }
        if (tile instanceof EnergyStorageTile) {
            EnergyStorage attachedStorage = ((EnergyStorageTile)tile).storage;
            this.storage.setCapacity(attachedStorage.getCapacityGC() - attachedStorage.getEnergyStoredGC());
            this.storage.setMaxExtract(attachedStorage.getMaxExtract());
            this.storage.setMaxReceive(attachedStorage.getMaxReceive());
        }
        return tile;
    }

    public float receiveEnergyGC(EnergySource from, float amount, boolean simulate) {
        if (this.modeReceive != ReceiverMode.RECEIVE.ordinal()) {
            return 0.0f;
        }
        this.getAttachedTile();
        if (this.facing == null) {
            return 0.0f;
        }
        return this.storage.receiveEnergyGC(amount, simulate);
    }

    public float extractEnergyGC(EnergySource from, float amount, boolean simulate) {
        if (this.modeReceive != ReceiverMode.EXTRACT.ordinal()) {
            return 0.0f;
        }
        TileEntity tile = this.getAttachedTile();
        if (this.facing == null) {
            return 0.0f;
        }
        float extracted = this.storage.extractEnergyGC(amount, simulate);
        if (extracted < amount && tile instanceof EnergyStorageTile) {
            extracted += ((EnergyStorageTile)tile).storage.extractEnergyGC(amount - extracted, simulate);
        }
        return extracted;
    }

    public float getEnergyStoredGC(EnergySource from) {
        TileEntity tile = this.getAttachedTile();
        if (this.facing == null) {
            return 0.0f;
        }
        return this.storage.getEnergyStoredGC();
    }

    public float getMaxEnergyStoredGC(EnergySource from) {
        TileEntity tile = this.getAttachedTile();
        if (this.facing == null) {
            return 0.0f;
        }
        return this.storage.getCapacityGC();
    }

    public boolean nodeAvailable(EnergySource from) {
        TileEntity tile = this.getAttachedTile();
        return this.facing != null;
    }

    public void setFacing(EnumFacing newDirection) {
        if (newDirection != this.facing) {
            if (newDirection == null) {
                this.modeReceive = ReceiverMode.UNDEFINED.ordinal();
            } else {
                TileEntity tile = new BlockVec3((TileEntity)this).getTileEntityOnSide(this.field_145850_b, newDirection);
                if (tile == null) {
                    this.modeReceive = ReceiverMode.UNDEFINED.ordinal();
                } else if (tile instanceof EnergyStorageTile) {
                    ReceiverMode mode = ((EnergyStorageTile)tile).getModeFromDirection(newDirection.func_176734_d());
                    this.modeReceive = mode != null ? mode.ordinal() : ReceiverMode.UNDEFINED.ordinal();
                } else if (EnergyUtil.otherModCanReceive((TileEntity)tile, (EnumFacing)newDirection.func_176734_d())) {
                    this.modeReceive = ReceiverMode.RECEIVE.ordinal();
                } else if (EnergyUtil.otherModCanProduce((TileEntity)tile, (EnumFacing)newDirection.func_176734_d())) {
                    this.modeReceive = ReceiverMode.EXTRACT.ordinal();
                }
            }
        }
        this.facing = newDirection;
    }

    public boolean canConnectTo(ILaserNode laserNode) {
        if (this.modeReceive != ReceiverMode.UNDEFINED.ordinal() && this.color.equals((Object)laserNode.getColor())) {
            if (laserNode instanceof TileEntityBeamReceiver) {
                return ((TileEntityBeamReceiver)laserNode).modeReceive != this.modeReceive;
            }
            return true;
        }
        return false;
    }

    public Vector3 getColor() {
        return new Vector3(0.0, 1.0, 0.0);
    }

    @Override
    public ILaserNode getTarget() {
        if (this.modeReceive == ReceiverMode.EXTRACT.ordinal()) {
            return super.getTarget();
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.preLoadFacing = nbt.func_74762_e("FacingSide");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("FacingSide", this.facing.ordinal());
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 16384.0;
    }
}

