/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.ShortRangeTelepadHandler;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityShortRangeTelepad;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockShortRangeTelepad
extends BlockTileGC
implements IShiftDescription,
ISortableBlock {
    protected static final AxisAlignedBB AABB_TELEPAD = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.45f, 1.0);

    protected BlockShortRangeTelepad(String assetName) {
        super(Material.field_151573_f);
        this.field_149782_v = 3.0f;
        this.func_149663_c(assetName);
        this.func_149672_a(SoundType.field_185852_e);
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityShortRangeTelepad();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_TELEPAD;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tile = worldIn.func_175625_s(pos);
        boolean validSpot = true;
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y < 3; y += 2) {
                for (int z = -1; z <= 1; ++z) {
                    IBlockState stateAt;
                    if (x == 0 && y == 0 && z == 0 || (stateAt = worldIn.func_180495_p(pos.func_177982_a(x, y, z))).func_177230_c().func_149688_o(stateAt).func_76222_j()) continue;
                    validSpot = false;
                }
            }
        }
        if (!validSpot) {
            worldIn.func_175698_g(pos);
            if (placer instanceof EntityPlayer) {
                if (!worldIn.field_72995_K) {
                    ((EntityPlayer)placer).func_145747_a((ITextComponent)new TextComponentString(EnumColor.RED + GCCoreUtil.translate((String)"gui.warning.noroom")));
                }
                ((EntityPlayer)placer).field_71071_by.func_70441_a(new ItemStack(Item.func_150898_a((Block)this), 1, 0));
            }
            return;
        }
        if (tile instanceof TileEntityShortRangeTelepad) {
            ((TileEntityShortRangeTelepad)tile).onCreate(worldIn, pos);
            ((TileEntityShortRangeTelepad)tile).setOwner(((EntityPlayer)placer).func_146103_bH().getName());
        }
    }

    public boolean onMachineActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return ((IMultiBlock)worldIn.func_175625_s(pos)).onActivated(playerIn);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileAt = worldIn.func_175625_s(pos);
        int fakeBlockCount = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y < 3; y += 2) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0 || worldIn.func_180495_p(pos.func_177982_a(x, y, z)).func_177230_c() != AsteroidBlocks.fakeTelepad) continue;
                    ++fakeBlockCount;
                }
            }
        }
        if (tileAt instanceof TileEntityShortRangeTelepad) {
            if (fakeBlockCount > 0) {
                ((TileEntityShortRangeTelepad)tileAt).onDestroy(tileAt);
            }
            ShortRangeTelepadHandler.removeShortRangeTeleporter((TileEntityShortRangeTelepad)tileAt);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tileAt = worldIn.func_175625_s(pos);
        if (tileAt instanceof TileEntityShortRangeTelepad) {
            TileEntityShortRangeTelepad telepad = (TileEntityShortRangeTelepad)tileAt;
            float teleportTimeScaled = Math.min(1.0f, (float)telepad.teleportTime / 150.0f);
            for (int i = 0; i < 6; ++i) {
                float b;
                float g;
                float r;
                float f;
                for (int j = 0; j < 4; ++j) {
                    f = rand.nextFloat() * 0.6f + 0.4f;
                    r = f * 0.3f;
                    g = f * (0.3f + teleportTimeScaled * 0.7f);
                    b = f * (1.0f - teleportTimeScaled * 0.7f);
                    GalacticraftPlanets.spawnParticle("portalBlue", new Vector3((double)pos.func_177958_n() + 0.2 + rand.nextDouble() * 0.6, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.2 + rand.nextDouble() * 0.6), new Vector3(0.0, 1.4, 0.0), new Object[]{telepad, false});
                }
                f = rand.nextFloat() * 0.6f + 0.4f;
                r = f * 0.3f;
                g = f * (0.3f + teleportTimeScaled * 0.7f);
                b = f * (1.0f - teleportTimeScaled * 0.7f);
                GalacticraftPlanets.spawnParticle("portalBlue", new Vector3((double)pos.func_177958_n() + 0.0 + rand.nextDouble() * 0.2, (double)pos.func_177956_o() + 2.9, (double)pos.func_177952_p() + rand.nextDouble()), new Vector3(0.0, -2.95, 0.0), new Object[]{telepad, true});
                GalacticraftPlanets.spawnParticle("portalBlue", new Vector3((double)pos.func_177958_n() + 0.8 + rand.nextDouble() * 0.2, (double)pos.func_177956_o() + 2.9, (double)pos.func_177952_p() + rand.nextDouble()), new Vector3(0.0, -2.95, 0.0), new Object[]{telepad, true});
                GalacticraftPlanets.spawnParticle("portalBlue", new Vector3((double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o() + 2.9, (double)pos.func_177952_p() + 0.2 + rand.nextDouble() * 0.2), new Vector3(0.0, -2.95, 0.0), new Object[]{telepad, true});
                GalacticraftPlanets.spawnParticle("portalBlue", new Vector3((double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o() + 2.9, (double)pos.func_177952_p() + 0.8 + rand.nextDouble() * 0.2), new Vector3(0.0, -2.95, 0.0), new Object[]{telepad, true});
            }
        }
    }

    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate((String)(this.func_149739_a() + ".description"));
    }

    public boolean showDescription(int meta) {
        return true;
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }
}

