/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.rwtema.funkylocomotion.EntityMovingEventHandler;
import com.rwtema.funkylocomotion.Proxy;
import java.util.HashSet;
import java.util.List;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;

public abstract class TileMovingBase
extends TileEntity
implements ITickable {
    private static final AxisAlignedBB[] blank = new AxisAlignedBB[0];
    public final Side side;
    public AxisAlignedBB[] collisions = blank;
    public boolean isAir = true;
    public int time = 0;
    public int maxTime = 0;
    public NBTTagCompound block;
    public NBTTagCompound desc;
    public int dir = -1;
    public int lightLevel = 0;
    public int lightOpacity = 0;
    public int scheduledTickTime = -1;
    public int scheduledTickPriority;

    public TileMovingBase(Side side) {
        this.side = side;
    }

    public static boolean _Immovable() {
        return true;
    }

    private static NBTTagCompound NBTAxis(AxisAlignedBB bb) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("a", (float)bb.field_72340_a);
        tag.func_74776_a("b", (float)bb.field_72338_b);
        tag.func_74776_a("c", (float)bb.field_72339_c);
        tag.func_74776_a("d", (float)bb.field_72336_d);
        tag.func_74776_a("e", (float)bb.field_72337_e);
        tag.func_74776_a("f", (float)bb.field_72334_f);
        return tag;
    }

    private static AxisAlignedBB AxisNBT(NBTTagCompound tag) {
        return new AxisAlignedBB((double)tag.func_74760_g("a"), (double)tag.func_74760_g("b"), (double)tag.func_74760_g("c"), (double)tag.func_74760_g("d"), (double)tag.func_74760_g("e"), (double)tag.func_74760_g("f"));
    }

    protected static AxisAlignedBB[] AxisTags(NBTTagList tagList) {
        int n = tagList.func_74745_c();
        AxisAlignedBB[] bbs = new AxisAlignedBB[n];
        for (int i = 0; i < n; ++i) {
            bbs[i] = TileMovingBase.AxisNBT(tagList.func_150305_b(i));
        }
        return bbs;
    }

    protected static NBTTagList TagsAxis(AxisAlignedBB[] bbs) {
        NBTTagList tagList = new NBTTagList();
        for (AxisAlignedBB bb : bbs) {
            tagList.func_74742_a((NBTBase)TileMovingBase.NBTAxis(bb));
        }
        return tagList;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.block = tag.func_74775_l("BlockTag");
        this.desc = tag.func_74775_l("DescTag");
        this.time = tag.func_74762_e("Time");
        this.maxTime = tag.func_74762_e("MaxTime");
        this.dir = tag.func_74771_c("Dir");
        this.isAir = this.block.func_82582_d();
        if (tag.func_150297_b("Collisions", 10)) {
            this.collisions = TileMovingBase.AxisTags(tag.func_150295_c("Collisions", 10));
        }
        this.lightLevel = tag.func_74771_c("Light");
        this.lightOpacity = tag.func_74765_d("Opacity");
        if (tag.func_150297_b("TimeTime", 3)) {
            this.scheduledTickTime = tag.func_74762_e("TickTime");
            this.scheduledTickPriority = tag.func_74762_e("TickPriority");
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.block != null) {
            tag.func_74782_a("BlockTag", (NBTBase)this.block);
        }
        if (this.desc != null) {
            tag.func_74782_a("DescTag", (NBTBase)this.desc);
        }
        tag.func_74768_a("Time", this.time);
        tag.func_74768_a("MaxTime", this.maxTime);
        tag.func_74774_a("Dir", (byte)this.dir);
        if (this.collisions.length > 0) {
            tag.func_74782_a("Collisions", (NBTBase)TileMovingBase.TagsAxis(this.collisions));
        }
        if (this.lightLevel != 0) {
            tag.func_74774_a("Light", (byte)this.lightLevel);
        }
        if (this.lightOpacity != 0) {
            tag.func_74777_a("Opacity", (short)this.lightOpacity);
        }
        if (this.scheduledTickTime != -1) {
            tag.func_74768_a("TickTime", this.scheduledTickTime);
            tag.func_74768_a("TickPriority", this.scheduledTickPriority);
        }
        return tag;
    }

    @Nullable
    public EnumFacing getDir() {
        if (this.dir < 0 || this.dir >= 6) {
            return null;
        }
        return EnumFacing.values()[this.dir];
    }

    public Vec3d getMovVec() {
        double d = 1.0 / (double)this.maxTime;
        if (this.dir < 0 || this.dir >= 6) {
            return Vec3d.field_186680_a;
        }
        EnumFacing dir = EnumFacing.values()[this.dir];
        return new Vec3d((double)dir.func_82601_c() * d, (double)dir.func_96559_d() * d, (double)dir.func_82599_e() * d);
    }

    public void func_73660_a() {
        if (this.maxTime == 0) {
            return;
        }
        if (this.func_145831_w().field_72995_K) {
            this.time = this.time + 1 - 1;
        }
        Vec3d mov = this.getMovVec();
        HashSet entityList = new HashSet();
        ++this.time;
        for (AxisAlignedBB bb : this.getTransformedColisions()) {
            List entities = this.func_145831_w().func_72872_a(Entity.class, bb.func_72321_a(0.0, 0.1, 0.0));
            entityList.addAll(entities);
        }
        for (Entity a : entityList) {
            WeakHashMap<Entity, Vec3d> map;
            if (a.field_70128_L || (map = EntityMovingEventHandler.getMovementMap(this.side)).containsKey(a)) continue;
            for (AxisAlignedBB bb : this.getTransformedColisions()) {
                AxisAlignedBB boundingBox = a.func_174813_aQ();
                if (boundingBox.func_72326_a(bb)) {
                    if (!(boundingBox.field_72338_b > bb.field_72337_e - 0.2)) continue;
                    a.func_174826_a(boundingBox.func_72317_d(0.0, bb.field_72337_e - boundingBox.field_72338_b, 0.0));
                    continue;
                }
                if (this.dir != 0 || !(a.field_70181_x <= 0.0) || !boundingBox.func_72326_a(bb.func_72317_d(0.0, 0.2, 0.0))) continue;
                a.func_174826_a(boundingBox.func_72317_d(0.0, bb.field_72337_e - boundingBox.field_72338_b, 0.0));
            }
            EntityMovingEventHandler.moveEntity(a, mov.field_72450_a, mov.field_72448_b, mov.field_72449_c);
            map.put(a, null);
        }
    }

    public AxisAlignedBB getCombinedCollisions(boolean renderOffset, boolean shrink) {
        TileEntity other;
        if (this.isAir) {
            return Block.field_185506_k;
        }
        AxisAlignedBB bb = null;
        for (AxisAlignedBB collision : this.collisions) {
            bb = bb == null ? collision : bb.func_111270_a(collision);
        }
        EnumFacing dir = this.getDir();
        if (dir != null && (other = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(dir))) instanceof TileMovingBase) {
            AxisAlignedBB bbs1;
            for (AxisAlignedBB bb1 : bbs1 = ((TileMovingBase)other).collisions) {
                bb = bb == null ? bb1.func_72317_d((double)dir.func_82601_c(), (double)dir.func_96559_d(), (double)dir.func_82599_e()) : bb.func_111270_a(bb1.func_72317_d((double)dir.func_82601_c(), (double)dir.func_96559_d(), (double)dir.func_82599_e()));
            }
        }
        if (bb == null) {
            return null;
        }
        double h = this.offset(renderOffset);
        if (dir != null) {
            bb = bb.func_72317_d(h * (double)dir.func_82601_c(), h * (double)dir.func_96559_d(), h * (double)dir.func_82599_e());
        } else if (shrink) {
            double mult = this.dir == 6 ? h + 1.0 : -h;
            bb = new AxisAlignedBB(0.5 + mult * (bb.field_72340_a - 0.5), 0.5 + mult * (bb.field_72338_b - 0.5), 0.5 + mult * (bb.field_72339_c - 0.5), 0.5 + mult * (bb.field_72336_d - 0.5), 0.5 + mult * (bb.field_72337_e - 0.5), 0.5 + mult * (bb.field_72334_f - 0.5));
        }
        return bb;
    }

    public AxisAlignedBB[] getTransformedColisions() {
        double h = this.offset(false);
        EnumFacing dir = this.getDir();
        if (dir != null && h != 0.0) {
            AxisAlignedBB[] tbbs = new AxisAlignedBB[this.collisions.length];
            for (int i = 0; i < this.collisions.length; ++i) {
                tbbs[i] = this.collisions[i].func_72317_d(h * (double)dir.func_82601_c(), h * (double)dir.func_96559_d(), h * (double)dir.func_82599_e()).func_186670_a(this.field_174879_c);
            }
            return tbbs;
        }
        return this.collisions;
    }

    public float progress() {
        return this.time >= this.maxTime ? 1.0f : ((float)this.time + Proxy.renderTimeOffset) / (float)this.maxTime;
    }

    public double offset(boolean t) {
        if (this.time >= this.maxTime) {
            return 0.0;
        }
        float f = t ? Proxy.renderTimeOffset : 0.0f;
        return ((float)this.time + f) / (float)this.maxTime - 1.0f;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }
}

