/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.event;

import java.io.File;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Properties;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FMLPreInitializationEvent
extends FMLStateEvent {
    private ModMetadata modMetadata;
    private File sourceFile;
    private File configurationDir;
    private File suggestedConfigFile;
    private ASMDataTable asmData;
    private ModContainer modContainer;

    public FMLPreInitializationEvent(Object ... data) {
        super(data);
        this.asmData = (ASMDataTable)data[0];
        this.configurationDir = (File)data[1];
    }

    @Override
    public LoaderState.ModState getModState() {
        return LoaderState.ModState.PREINITIALIZED;
    }

    @Override
    public void applyModContainer(ModContainer activeContainer) {
        this.modContainer = activeContainer;
        this.modMetadata = activeContainer.getMetadata();
        this.sourceFile = activeContainer.getSource();
        this.suggestedConfigFile = new File(this.configurationDir, activeContainer.getModId() + ".cfg");
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public ModMetadata getModMetadata() {
        return this.modMetadata;
    }

    public File getModConfigurationDirectory() {
        return this.configurationDir;
    }

    public File getSuggestedConfigurationFile() {
        return this.suggestedConfigFile;
    }

    public ASMDataTable getAsmData() {
        return this.asmData;
    }

    @Nullable
    public Properties getVersionProperties() {
        if (this.modContainer instanceof FMLModContainer) {
            return ((FMLModContainer)this.modContainer).searchForVersionProperties();
        }
        return null;
    }

    public Logger getModLog() {
        Logger log = LogManager.getLogger((String)this.modContainer.getModId());
        return log;
    }

    @Deprecated
    public Certificate[] getFMLSigningCertificates() {
        CodeSource codeSource = this.getClass().getClassLoader().getParent().getClass().getProtectionDomain().getCodeSource();
        Certificate[] certs = codeSource.getCertificates();
        if (certs == null) {
            return new Certificate[0];
        }
        return certs;
    }
}

