/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import java.io.File;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;

public class PlayerEvent
extends LivingEvent {
    private final aay entityPlayer;

    public PlayerEvent(aay player) {
        super((sw)player);
        this.entityPlayer = player;
    }

    public aay getEntityPlayer() {
        return this.entityPlayer;
    }

    public static class Visibility
    extends PlayerEvent {
        private double visibilityModifier = 1.0;

        public Visibility(aay player) {
            super(player);
        }

        public void modifyVisibility(double mod) {
            this.visibilityModifier *= mod;
        }

        public double getVisibilityModifier() {
            return this.visibilityModifier;
        }
    }

    public static class SaveToFile
    extends PlayerEvent {
        private final File playerDirectory;
        private final String playerUUID;

        public SaveToFile(aay player, File originDirectory, String playerUUID) {
            super(player);
            this.playerDirectory = originDirectory;
            this.playerUUID = playerUUID;
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.getPlayerDirectory(), this.getPlayerUUID() + "." + suffix);
        }

        public File getPlayerDirectory() {
            return this.playerDirectory;
        }

        public String getPlayerUUID() {
            return this.playerUUID;
        }
    }

    public static class LoadFromFile
    extends PlayerEvent {
        private final File playerDirectory;
        private final String playerUUID;

        public LoadFromFile(aay player, File originDirectory, String playerUUID) {
            super(player);
            this.playerDirectory = originDirectory;
            this.playerUUID = playerUUID;
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.getPlayerDirectory(), this.getPlayerUUID() + "." + suffix);
        }

        public File getPlayerDirectory() {
            return this.playerDirectory;
        }

        public String getPlayerUUID() {
            return this.playerUUID;
        }
    }

    public static class StopTracking
    extends PlayerEvent {
        private final sn target;

        public StopTracking(aay player, sn target) {
            super(player);
            this.target = target;
        }

        public sn getTarget() {
            return this.target;
        }
    }

    public static class StartTracking
    extends PlayerEvent {
        private final sn target;

        public StartTracking(aay player, sn target) {
            super(player);
            this.target = target;
        }

        public sn getTarget() {
            return this.target;
        }
    }

    public static class Clone
    extends PlayerEvent {
        private final aay original;
        private final boolean wasDeath;

        public Clone(aay _new, aay oldPlayer, boolean wasDeath) {
            super(_new);
            this.original = oldPlayer;
            this.wasDeath = wasDeath;
        }

        public aay getOriginal() {
            return this.original;
        }

        public boolean isWasDeath() {
            return this.wasDeath;
        }
    }

    public static class NameFormat
    extends PlayerEvent {
        private final String username;
        private String displayname;

        public NameFormat(aay player, String username) {
            super(player);
            this.username = username;
            this.setDisplayname(username);
        }

        public String getUsername() {
            return this.username;
        }

        public String getDisplayname() {
            return this.displayname;
        }

        public void setDisplayname(String displayname) {
            this.displayname = displayname;
        }
    }

    @Cancelable
    public static class BreakSpeed
    extends PlayerEvent {
        private final atl state;
        private final float originalSpeed;
        private float newSpeed = 0.0f;
        private final co pos;

        public BreakSpeed(aay player, atl state, float original, co pos) {
            super(player);
            this.state = state;
            this.originalSpeed = original;
            this.setNewSpeed(original);
            this.pos = pos;
        }

        public atl getState() {
            return this.state;
        }

        public float getOriginalSpeed() {
            return this.originalSpeed;
        }

        public float getNewSpeed() {
            return this.newSpeed;
        }

        public void setNewSpeed(float newSpeed) {
            this.newSpeed = newSpeed;
        }

        public co getPos() {
            return this.pos;
        }
    }

    public static class HarvestCheck
    extends PlayerEvent {
        private final atl state;
        private boolean success;

        public HarvestCheck(aay player, atl state, boolean success) {
            super(player);
            this.state = state;
            this.success = success;
        }

        public atl getTargetBlock() {
            return this.state;
        }

        public boolean canHarvest() {
            return this.success;
        }

        public void setCanHarvest(boolean success) {
            this.success = success;
        }
    }
}

