/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.ItemStackHolderRef;

public enum ItemStackHolderInjector {
    INSTANCE;

    private List<ItemStackHolderRef> itemStackHolders = Lists.newArrayList();

    public void inject() {
        FMLLog.log.info("Injecting itemstacks");
        for (ItemStackHolderRef ishr : this.itemStackHolders) {
            ishr.apply();
        }
        FMLLog.log.info("Itemstack injection complete");
    }

    public void findHolders(ASMDataTable table) {
        FMLLog.log.info("Identifying ItemStackHolder annotations");
        Set<ASMDataTable.ASMData> allItemStackHolders = table.getAll(GameRegistry.ItemStackHolder.class.getName());
        HashMap classCache = Maps.newHashMap();
        for (ASMDataTable.ASMData data : allItemStackHolders) {
            String className = data.getClassName();
            String annotationTarget = data.getObjectName();
            String value = (String)data.getAnnotationInfo().get("value");
            int meta = data.getAnnotationInfo().containsKey("meta") ? (Integer)data.getAnnotationInfo().get("meta") : 0;
            String nbt = data.getAnnotationInfo().containsKey("nbt") ? (String)data.getAnnotationInfo().get("nbt") : "";
            this.addHolder(classCache, className, annotationTarget, value, meta, nbt);
        }
        FMLLog.log.info("Found {} ItemStackHolder annotations", new Object[]{allItemStackHolders.size()});
    }

    private void addHolder(Map<String, Class<?>> classCache, String className, String annotationTarget, String value, Integer meta, String nbt) {
        Class<?> clazz;
        if (classCache.containsKey(className)) {
            clazz = classCache.get(className);
        } else {
            try {
                clazz = Class.forName(className, true, ((Object)((Object)this)).getClass().getClassLoader());
                classCache.put(className, clazz);
            }
            catch (Exception ex2) {
                throw Throwables.propagate((Throwable)ex2);
            }
        }
        try {
            Field f2 = clazz.getField(annotationTarget);
            this.itemStackHolders.add(new ItemStackHolderRef(f2, value, meta, nbt));
        }
        catch (Exception ex3) {
            throw Throwables.propagate((Throwable)ex3);
        }
    }
}

