/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse;

import forestry.api.climate.EnumClimatiserModes;
import forestry.api.climate.EnumClimatiserTypes;
import forestry.api.climate.IClimateInfo;
import forestry.api.climate.IClimatePosition;
import forestry.api.climate.IClimateRegion;
import forestry.api.climate.IClimatiserDefinition;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.climate.ClimateSource;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.tiles.TileGreenhouseClimatiser;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class GreenhouseClimateSource<P extends TileGreenhouseClimatiser>
extends ClimateSource<P> {
    private static final int COOLDOWN = 10;
    private int currentCooldown;

    public GreenhouseClimateSource(int ticksForChange) {
        super(ticksForChange);
    }

    @Override
    public boolean changeClimate(int tickCount, IClimateRegion region) {
        if (this.provider == null) {
            return false;
        }
        if (this.currentCooldown > 0) {
            --this.currentCooldown;
            return false;
        }
        IClimatiserDefinition definition = ((TileGreenhouseClimatiser)this.provider).getDefinition();
        Object logic = ((TileGreenhouseClimatiser)this.provider).getMultiblockLogic();
        IMultiblockController controller = logic.getController();
        Set<BlockPos> positionsInRange = ((TileGreenhouseClimatiser)this.provider).getPositionsInRange();
        boolean hasChange = false;
        boolean isActive = false;
        if (logic.isConnected() && controller.isAssembled() && controller instanceof IGreenhouseControllerInternal && positionsInRange.iterator().hasNext()) {
            IGreenhouseControllerInternal greenhouseInternal = (IGreenhouseControllerInternal)controller;
            IClimateInfo climateInfo = this.getClimateControl(greenhouseInternal);
            float controlTemp = climateInfo.getTemperature();
            float controlHum = climateInfo.getHumidity();
            isActive = greenhouseInternal.canWork() && ((TileGreenhouseClimatiser)this.provider).canWork();
            EnumClimatiserTypes type = definition.getType();
            EnumClimatiserModes mode = definition.getMode();
            float maxChange = definition.getChange();
            if (isActive) {
                if (this.canChange(type, EnumClimatiserTypes.TEMPERATURE)) {
                    if (region.getAverageTemperature() < controlTemp) {
                        if (!this.canChange(mode, EnumClimatiserModes.POSITIVE)) {
                            isActive = false;
                        }
                    } else if (region.getAverageTemperature() > controlTemp && !this.canChange(mode, EnumClimatiserModes.NEGATIVE)) {
                        isActive = false;
                    }
                }
                if (this.canChange(type, EnumClimatiserTypes.HUMIDITY)) {
                    if (region.getAverageTemperature() < controlHum) {
                        if (!this.canChange(mode, EnumClimatiserModes.POSITIVE)) {
                            isActive = false;
                        }
                    } else if (region.getAverageTemperature() > controlHum && !this.canChange(mode, EnumClimatiserModes.NEGATIVE)) {
                        isActive = false;
                    }
                }
            }
            if (isActive) {
                for (BlockPos pos : positionsInRange) {
                    IClimatePosition position = region.getPosition(pos);
                    if (position == null) continue;
                    double distance = pos.func_177951_i((Vec3i)((TileGreenhouseClimatiser)this.provider).getCoordinates());
                    double range = definition.getRange();
                    float change = maxChange;
                    if (distance > 0.0) {
                        change = (float)((double)maxChange / distance);
                    }
                    if (this.canChange(type, EnumClimatiserTypes.TEMPERATURE)) {
                        if (position.getTemperature() < controlTemp) {
                            if (this.canChange(mode, EnumClimatiserModes.POSITIVE)) {
                                position.addTemperature(Math.min(change, controlTemp - position.getTemperature()));
                                hasChange = true;
                            }
                        } else if (position.getTemperature() > controlTemp && this.canChange(mode, EnumClimatiserModes.NEGATIVE)) {
                            position.addTemperature(-Math.min(position.getTemperature() - controlTemp, change));
                            hasChange = true;
                        }
                    }
                    if (!this.canChange(type, EnumClimatiserTypes.HUMIDITY)) continue;
                    if (position.getHumidity() < controlHum) {
                        if (!this.canChange(mode, EnumClimatiserModes.POSITIVE)) continue;
                        position.addHumidity(Math.min(change, controlHum - position.getHumidity()));
                        hasChange = true;
                        continue;
                    }
                    if (!(position.getHumidity() > controlHum) || !this.canChange(mode, EnumClimatiserModes.NEGATIVE)) continue;
                    position.addHumidity(-Math.min(position.getHumidity() - controlHum, change));
                    hasChange = true;
                }
            }
        }
        if (!hasChange) {
            this.currentCooldown = 10;
            if (isActive) {
                isActive = false;
            }
        }
        if (((TileGreenhouseClimatiser)this.provider).isActive() != isActive) {
            ((TileGreenhouseClimatiser)this.provider).setActive(isActive);
        }
        return hasChange;
    }

    protected boolean canChange(EnumClimatiserTypes climatiserType, EnumClimatiserTypes type) {
        return type == climatiserType || climatiserType == EnumClimatiserTypes.BOTH;
    }

    protected boolean canChange(EnumClimatiserModes climatiserMode, EnumClimatiserModes mode) {
        return mode == climatiserMode || climatiserMode == EnumClimatiserModes.BOTH;
    }

    protected IClimateInfo getClimateControl(IGreenhouseControllerInternal greenhouseInternal) {
        return greenhouseInternal.getControlClimate();
    }
}

