/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.mojang.authlib.GameProfile;
import forestry.core.utils.Translator;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;

public abstract class PlayerUtil {
    private static final UUID emptyUUID = new UUID(0L, 0L);

    public static boolean isSameGameProfile(GameProfile player1, GameProfile player2) {
        UUID id1 = player1.getId();
        UUID id2 = player2.getId();
        if (id1 != null && id2 != null && !id1.equals(emptyUUID) && !id2.equals(emptyUUID)) {
            return id1.equals(id2);
        }
        return player1.getName() != null && player1.getName().equals(player2.getName());
    }

    public static String getOwnerName(@Nullable GameProfile profile) {
        if (profile == null) {
            return Translator.translateToLocal("for.gui.derelict");
        }
        return profile.getName();
    }

    @Nullable
    public static EntityPlayer getPlayer(World world, @Nullable GameProfile profile) {
        if (profile == null || profile.getName() == null) {
            if (world instanceof WorldServer) {
                return FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
            }
            return null;
        }
        EntityPlayer player = world.func_72924_a(profile.getName());
        if (player == null && world instanceof WorldServer) {
            player = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)profile);
        }
        return player;
    }

    public static void writeGameProfile(NBTTagCompound tagCompound, GameProfile profile) {
        if (!StringUtils.func_151246_b((String)profile.getName())) {
            tagCompound.func_74778_a("Name", profile.getName());
        }
        if (profile.getId() != null) {
            tagCompound.func_74778_a("Id", profile.getId().toString());
        }
    }

    @Nullable
    public static GameProfile readGameProfileFromNBT(NBTTagCompound compound) {
        return NBTUtil.func_152459_a((NBTTagCompound)compound);
    }
}

