/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.apiculture.hives.IHiveGen;
import forestry.api.apiculture.hives.IHiveRegistry;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.tiles.TileHive;
import forestry.apiculture.worldgen.HiveGenGround;
import forestry.core.tiles.TileUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class HiveDescriptionSwarmer
implements IHiveDescription {
    private final List<ItemStack> bees;

    public HiveDescriptionSwarmer(ItemStack ... bees) {
        this.bees = Arrays.asList(bees);
    }

    @Override
    public IHiveGen getHiveGen() {
        return new HiveGenGround(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c});
    }

    @Override
    public IBlockState getBlockState() {
        return PluginApiculture.getBlocks().beehives.getStateForType(IHiveRegistry.HiveType.SWARM);
    }

    @Override
    public boolean isGoodBiome(Biome biome) {
        return true;
    }

    @Override
    public boolean isGoodHumidity(EnumHumidity humidity) {
        return true;
    }

    @Override
    public boolean isGoodTemperature(EnumTemperature temperature) {
        return true;
    }

    @Override
    public float getGenChance() {
        return 128.0f;
    }

    @Override
    public void postGen(World world, Random rand, BlockPos pos) {
        TileUtil.actOnTile((IBlockAccess)world, pos, TileHive.class, tile -> tile.setContained(this.bees));
    }
}

