/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.worldgen.Hive;
import forestry.core.config.Config;
import forestry.core.utils.Log;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public abstract class HiveDecorator {
    private static final PopulateChunkEvent.Populate.EventType EVENT_TYPE = (PopulateChunkEvent.Populate.EventType)EnumHelper.addEnum(PopulateChunkEvent.Populate.EventType.class, (String)"FORESTRY_HIVES", (Class[])new Class[0], (Object[])new Object[0]);

    public static void decorateHives(IChunkGenerator chunkProvider, World world, Random rand, int chunkX, int chunkZ, boolean hasVillageGenerated) {
        if (!TerrainGen.populate((IChunkGenerator)chunkProvider, (World)world, (Random)rand, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)EVENT_TYPE)) {
            return;
        }
        HiveDecorator.decorateHives(world, rand, chunkX, chunkZ);
    }

    public static void decorateHives(World world, Random rand, int chunkX, int chunkZ) {
        List<Hive> hives = PluginApiculture.getHiveRegistry().getHives();
        if (Config.generateBeehivesDebug) {
            HiveDecorator.decorateHivesDebug(world, rand, chunkX, chunkZ, hives);
            return;
        }
        int worldX = (chunkX << 4) + 8;
        int worldZ = (chunkZ << 4) + 8;
        Collections.shuffle(hives, rand);
        for (int tries = 0; tries < 4; ++tries) {
            int z;
            int x = worldX + rand.nextInt(16);
            BlockPos pos = new BlockPos(x, 0, z = worldZ + rand.nextInt(16));
            if (!world.func_175667_e(pos)) {
                Log.error("tried to generate a hive in an unloaded area.", new Object[0]);
                return;
            }
            Biome biome = world.func_180494_b(pos);
            EnumHumidity humidity = EnumHumidity.getFromValue(biome.func_76727_i());
            for (Hive hive : hives) {
                if (!((double)hive.genChance() * Config.getBeehivesAmount() >= (double)(rand.nextFloat() * 100.0f)) || !hive.isGoodBiome(biome) || !hive.isGoodHumidity(humidity) || !HiveDecorator.tryGenHive(world, rand, x, z, hive)) continue;
                return;
            }
        }
    }

    private static void decorateHivesDebug(World world, Random rand, int chunkX, int chunkZ, List<Hive> hives) {
        int worldX = (chunkX << 4) + 8;
        int worldZ = (chunkZ << 4) + 8;
        Biome biome = world.func_180494_b(new BlockPos(chunkX, 0, chunkZ));
        EnumHumidity humidity = EnumHumidity.getFromValue(biome.func_76727_i());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Collections.shuffle(hives, world.field_73012_v);
                for (Hive hive : hives) {
                    if (!hive.isGoodBiome(biome) || !hive.isGoodHumidity(humidity)) continue;
                    HiveDecorator.tryGenHive(world, rand, worldX + x, worldZ + z, hive);
                }
            }
        }
    }

    public static boolean tryGenHive(World world, Random rand, int x, int z, Hive hive) {
        BlockPos hivePos = hive.getPosForHive(world, x, z);
        if (hivePos == null) {
            return false;
        }
        if (!hive.canReplace(world, hivePos)) {
            return false;
        }
        Biome biome = world.func_180494_b(hivePos);
        EnumTemperature temperature = EnumTemperature.getFromValue(biome.func_180626_a(hivePos));
        if (!hive.isGoodTemperature(temperature)) {
            return false;
        }
        if (!hive.isValidLocation(world, hivePos)) {
            return false;
        }
        return HiveDecorator.setHive(world, rand, hivePos, hive);
    }

    private static boolean setHive(World world, Random rand, BlockPos pos, Hive hive) {
        IBlockState hiveState = hive.getHiveBlockState();
        Block hiveBlock = hiveState.func_177230_c();
        boolean placed = world.func_180501_a(pos, hiveState, 2);
        if (!placed) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block placedBlock = state.func_177230_c();
        if (!Block.func_149680_a((Block)hiveBlock, (Block)placedBlock)) {
            return false;
        }
        hiveBlock.func_176213_c(world, pos, state);
        if (!Config.generateBeehivesDebug) {
            hive.postGen(world, rand, pos);
        }
        if (Config.logHivePlacement) {
            Log.info("Placed {} at {}", hive, pos);
        }
        return true;
    }
}

