/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores.blocks;

import com.google.common.base.Throwables;
import com.rwtema.denseores.DenseOre;
import com.rwtema.denseores.blockaccess.BlockAccessSingleOverride;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockDenseOre
extends Block {
    public boolean init = false;
    DenseOre denseOre;
    IBlockState baseBlockState;
    private boolean isValid;
    private Block baseBlock;

    public BlockDenseOre(DenseOre denseOre) {
        super(Material.field_151576_e);
        this.denseOre = denseOre;
        this.func_149647_a(CreativeTabs.field_78030_b);
    }

    public static Block getBlock(DenseOre ore) {
        return ore != null ? (Block)Block.field_149771_c.func_82594_a((Object)ore.baseBlock) : null;
    }

    public static Block getNullOverride(IBlockAccess world, BlockPos pos) {
        if (world == null) {
            return Blocks.field_150348_b;
        }
        Biome biome = world.func_180494_b(pos);
        if (biome == Biomes.field_76778_j) {
            return Blocks.field_150424_aL;
        }
        if (biome == Biomes.field_76779_k) {
            return Blocks.field_150377_bs;
        }
        return BlockDenseOre.getNullOverride(world);
    }

    public static Block getNullOverride(IBlockAccess blockAccess) {
        if (!(blockAccess instanceof World)) {
            return Blocks.field_150348_b;
        }
        World world = (World)blockAccess;
        return BlockDenseOre.getBlock(world);
    }

    public static Block getBlock(World world) {
        if (world.field_73011_w == null) {
            return Blocks.field_150348_b;
        }
        if (world.field_73011_w.getDimension() == -1) {
            return Blocks.field_150424_aL;
        }
        if (world.field_73011_w.getDimension() == 1) {
            return Blocks.field_150377_bs;
        }
        return Blocks.field_150348_b;
    }

    public Block getUnderlyingBlock(IBlockAccess world, BlockPos pos) {
        if ("blocks/stone".equals(this.denseOre.underlyingBlockTexture)) {
            return Blocks.field_150348_b;
        }
        if ("blocks/netherrack".equals(this.denseOre.underlyingBlockTexture)) {
            return Blocks.field_150424_aL;
        }
        if ("blocks/end_stone".equals(this.denseOre.underlyingBlockTexture)) {
            return Blocks.field_150377_bs;
        }
        return BlockDenseOre.getNullOverride(world, pos);
    }

    public boolean isValid() {
        if (!this.init) {
            this.init();
        }
        return this.isValid;
    }

    public void init() {
        this.init = true;
        this.baseBlock = this.denseOre.getBaseBlock();
        this.baseBlockState = this.baseBlock.func_176203_a(this.denseOre.metadata);
        this.isValid = this.baseBlock != null && this.baseBlock != Blocks.field_150350_a;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[0]);
    }

    public Block getBlock() {
        if (!this.init) {
            this.init();
        }
        return this.baseBlock;
    }

    public IBlockState getBaseBlockState() {
        if (!this.init) {
            this.init();
        }
        return this.baseBlockState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (!this.isValid()) {
            return;
        }
        try {
            world.func_180501_a(pos, this.getBaseBlockState(), 0);
            for (int i = 0; i < 1 + rand.nextInt(3); ++i) {
                this.getBlock().func_180655_c(this.getBaseBlockState(), world, pos, rand);
            }
        }
        finally {
            world.func_180501_a(pos, state, 0);
        }
    }

    public void func_180653_a(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, float chance, int fortune) {
        IBlockState base;
        if (worldIn.field_72995_K || worldIn.restoringBlockSnapshots) {
            return;
        }
        List<ItemStack> items = this.getDrops((IBlockAccess)worldIn, pos, state, fortune);
        chance = ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
        if (chance == 0.0f) {
            return;
        }
        if (this.isValid() && (base = this.getBaseBlockState()) != null) {
            chance = ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)base, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
        }
        if (chance == 0.0f) {
            return;
        }
        for (ItemStack item : items) {
            if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
            BlockDenseOre.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
        }
    }

    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (this.isValid()) {
            Block base = this.getBlock();
            if (base == null) {
                return list;
            }
            IBlockState m = this.getBaseBlockState();
            BlockAccessSingleOverride delegate = new BlockAccessSingleOverride(world, m, pos);
            Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
            for (int j = 0; j < 3; ++j) {
                list.addAll(base.getDrops((IBlockAccess)delegate, pos, m, fortune));
            }
        } else {
            Block block = BlockDenseOre.getNullOverride(world, pos);
            BlockAccessSingleOverride delegate = new BlockAccessSingleOverride(world, block.func_176223_P(), pos);
            return block.getDrops((IBlockAccess)delegate, pos, block.func_176223_P(), fortune);
        }
        return list;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return 1.0f;
        }
        if (!this.isValid()) {
            return 1.0f;
        }
        TileEntity tile = world.func_175625_s(pos);
        try {
            IBlockState baseBlockState = this.getBaseBlockState();
            world.func_180501_a(pos, baseBlockState, 0);
            float blockHardness = this.getBlock().func_176195_g(baseBlockState, world, pos);
            world.func_180501_a(pos, state, 0);
            if (tile != null) {
                NBTTagCompound tag = new NBTTagCompound();
                tile.func_189515_b(tag);
                TileEntity newTile = world.func_175625_s(pos);
                newTile.func_145839_a(tag);
            }
            return blockHardness;
        }
        catch (Throwable throwable) {
            world.func_180501_a(pos, state, 0);
            if (tile != null) {
                NBTTagCompound tag = new NBTTagCompound();
                tile.func_189515_b(tag);
                TileEntity newTile = world.func_175625_s(pos);
                newTile.func_145839_a(tag);
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public int getExpDrop(IBlockState state, IBlockAccess iBlockAccess, BlockPos pos, int fortune) {
        if (!(iBlockAccess instanceof World) || !this.isValid()) {
            return 0;
        }
        World world = (World)iBlockAccess;
        IBlockState baseState = this.getBaseBlockState();
        BlockAccessSingleOverride delegate = new BlockAccessSingleOverride(iBlockAccess, baseState, pos);
        return baseState.func_177230_c().getExpDrop(baseState, (IBlockAccess)delegate, pos, fortune);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, @Nonnull IBlockState state, EntityPlayer player) {
        return state.func_177230_c() == this && this.isValid();
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    public boolean hasTileEntity(IBlockState state) {
        return false;
    }

    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        if (world.field_72995_K) {
            return null;
        }
        return null;
    }

    public int getHarvestLevel(@Nonnull IBlockState state) {
        IBlockState baseState = this.getBaseBlockState();
        return baseState.func_177230_c().getHarvestLevel(baseState);
    }

    public String getHarvestTool(@Nonnull IBlockState state) {
        IBlockState baseState = this.getBaseBlockState();
        return baseState.func_177230_c().getHarvestTool(baseState);
    }
}

