/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores;

import com.rwtema.denseores.DenseOre;
import com.rwtema.denseores.DenseOresRegistry;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldGenOres
implements IWorldGenerator {
    private static final String DENSEORES = "DenseOres";
    private static Random rand = new Random();

    public static boolean overrideChunkBlock(Chunk chunk, BlockPos pos, IBlockState state, boolean retroGen) {
        Map map;
        TileEntity te;
        if (!retroGen) {
            return chunk.func_177412_p().func_175656_a(pos, state);
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        IBlockState oldState = chunk.func_177435_g(pos);
        if (oldState == state || y < 0) {
            return false;
        }
        ExtendedBlockStorage[] storageArray = chunk.func_76587_i();
        ExtendedBlockStorage extendedblockstorage = storageArray[y >> 4];
        if (extendedblockstorage == null) {
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(y >> 4 << 4, !chunk.func_177412_p().field_73011_w.func_177495_o());
            storageArray[y >> 4] = extendedBlockStorage;
            extendedblockstorage = extendedBlockStorage;
        }
        extendedblockstorage.func_177484_a(x & 0xF, y & 0xF, z & 0xF, state);
        if (oldState.func_177230_c().hasTileEntity(oldState) && (te = (TileEntity)(map = chunk.func_177434_r()).remove(pos)) != null) {
            te.func_145843_s();
        }
        return extendedblockstorage.func_177485_a(x & 0xF, y & 0xF, z & 0xF) == state;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        for (DenseOre denseOre : DenseOresRegistry.ores.values()) {
            this.genChunk(chunk, random, denseOre, false);
        }
    }

    public void genChunk(Chunk chunk, Random random, DenseOre denseOre, boolean retroGen) {
        IBlockState replaceState = denseOre.block.func_176223_P();
        for (int i = 0; i < 1000; ++i) {
            int z;
            int y;
            int x = chunk.field_76635_g << 4 | random.nextInt(16);
            BlockPos pos = new BlockPos(x, y = 1 + random.nextInt(80), z = chunk.field_76647_h << 4 | random.nextInt(16));
            IBlockState state = chunk.func_177435_g(pos);
            if (state != denseOre.getBaseState()) continue;
            WorldGenOres.overrideChunkBlock(chunk, pos, replaceState, retroGen);
        }
    }

    @SubscribeEvent
    public void retroGen(ChunkDataEvent.Load event) {
        NBTTagCompound chunkData = event.getData();
        NBTTagCompound rgen = chunkData.func_74775_l(DENSEORES);
        boolean regen = false;
        long worldSeed = event.getWorld().func_72905_C();
        rand.setSeed(worldSeed);
        long xSeed = rand.nextLong() >> 3;
        long zSeed = rand.nextLong() >> 3;
        long chunkSeed = xSeed * (long)event.getChunk().field_76635_g + zSeed * (long)event.getChunk().field_76647_h ^ worldSeed;
        rand.setSeed(chunkSeed);
        for (DenseOre denseOre : DenseOresRegistry.ores.values()) {
            if (rgen.func_74764_b(denseOre.name.toString()) && denseOre.retroGenId == rgen.func_74762_e(denseOre.name.toString())) continue;
            this.genChunk(event.getChunk(), rand, denseOre, true);
            regen = true;
        }
        if (regen) {
            event.getChunk().func_76630_e();
        }
    }

    @SubscribeEvent
    public void retroGenSave(ChunkDataEvent.Save event) {
        NBTTagCompound chunkData = event.getData();
        NBTTagCompound rgen = chunkData.func_74775_l(DENSEORES);
        for (DenseOre denseOre : DenseOresRegistry.ores.values()) {
            rgen.func_74768_a(denseOre.name.toString(), denseOre.retroGenId);
        }
        chunkData.func_74782_a(DENSEORES, (NBTBase)rgen);
    }
}

