/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealthmod;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.torocraft.torohealthmod.CommonProxy;
import net.torocraft.torohealthmod.config.ConfigurationHandler;
import net.torocraft.torohealthmod.gui.GuiEntityStatus;
import net.torocraft.torohealthmod.render.DamageParticle;

public class ClientProxy
extends CommonProxy {
    GuiEntityStatus entityStatusGUI;
    private Minecraft mc = Minecraft.func_71410_x();
    private Entity pointedEntity;

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        this.entityStatusGUI = new GuiEntityStatus();
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        MinecraftForge.EVENT_BUS.register((Object)this.entityStatusGUI);
    }

    @Override
    public void displayDamageDealt(EntityLivingBase entity) {
        int entityHealth;
        if (!entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!ConfigurationHandler.showDamageParticles) {
            return;
        }
        int currentHealth = (int)Math.ceil(entity.func_110143_aJ());
        if (entity.getEntityData().func_74764_b("health") && (entityHealth = ((NBTTagInt)entity.getEntityData().func_74781_a("health")).func_150287_d()) != currentHealth) {
            this.displayParticle((Entity)entity, entityHealth - currentHealth);
        }
        entity.getEntityData().func_74782_a("health", (NBTBase)new NBTTagInt(currentHealth));
    }

    private void displayParticle(Entity entity, int damage) {
        if (damage == 0) {
            return;
        }
        World world = entity.field_70170_p;
        double motionX = world.field_73012_v.nextGaussian() * 0.02;
        double motionY = 0.5;
        double motionZ = world.field_73012_v.nextGaussian() * 0.02;
        DamageParticle damageIndicator = new DamageParticle(damage, world, entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v, motionX, motionY, motionZ);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)damageIndicator);
    }

    @Override
    public void setEntityInCrosshairs() {
        RayTraceResult r = this.getMouseOver(1.0f);
        if (r != null && RayTraceResult.Type.ENTITY.equals((Object)r.field_72313_a) && r.field_72308_g instanceof EntityLivingBase) {
            this.entityStatusGUI.setEntity((EntityLivingBase)r.field_72308_g);
        }
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public RayTraceResult rayTrace(Entity e, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = e.func_174824_e(partialTicks);
        Vec3d vec3d1 = e.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return this.mc.field_71441_e.func_147447_a(vec3d, vec3d2, false, true, true);
    }

    public RayTraceResult getMouseOver(float partialTicks) {
        RayTraceResult objectMouseOver = null;
        Entity observer = this.mc.func_175606_aa();
        if (observer == null || this.mc.field_71441_e == null) {
            return objectMouseOver;
        }
        this.mc.field_147125_j = null;
        double reachDistance = 50.0;
        objectMouseOver = this.rayTrace(observer, reachDistance, partialTicks);
        Vec3d observerPositionEyes = observer.func_174824_e(partialTicks);
        double distance = reachDistance;
        if (objectMouseOver != null) {
            distance = objectMouseOver.field_72307_f.func_72438_d(observerPositionEyes);
        }
        Vec3d lookVector = observer.func_70676_i(partialTicks);
        Vec3d lookVectorFromEyePosition = observerPositionEyes.func_72441_c(lookVector.field_72450_a * reachDistance, lookVector.field_72448_b * reachDistance, lookVector.field_72449_c * reachDistance);
        this.pointedEntity = null;
        Vec3d hitVector = null;
        List list = this.mc.field_71441_e.func_175674_a(observer, observer.func_174813_aQ().func_72321_a(lookVector.field_72450_a * reachDistance, lookVector.field_72448_b * reachDistance, lookVector.field_72449_c * reachDistance).func_72314_b(1.0, 1.0, 1.0), EntitySelectors.field_180132_d);
        double d2 = distance;
        for (int j = 0; j < list.size(); ++j) {
            double d3;
            Entity entity1 = (Entity)list.get(j);
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            RayTraceResult raytraceresult = axisalignedbb.func_72327_a(observerPositionEyes, lookVectorFromEyePosition);
            if (axisalignedbb.func_72318_a(observerPositionEyes)) {
                if (!(d2 >= 0.0)) continue;
                this.pointedEntity = entity1;
                hitVector = raytraceresult == null ? observerPositionEyes : raytraceresult.field_72307_f;
                d2 = 0.0;
                continue;
            }
            if (raytraceresult == null || !((d3 = observerPositionEyes.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
            if (entity1.func_184208_bv() == observer.func_184208_bv() && !observer.canRiderInteract()) {
                if (d2 != 0.0) continue;
                this.pointedEntity = entity1;
                hitVector = raytraceresult.field_72307_f;
                continue;
            }
            this.pointedEntity = entity1;
            hitVector = raytraceresult.field_72307_f;
            d2 = d3;
        }
        objectMouseOver = new RayTraceResult(this.pointedEntity, hitVector);
        if (this.pointedEntity instanceof EntityLivingBase || this.pointedEntity instanceof EntityItemFrame) {
            this.mc.field_147125_j = this.pointedEntity;
        }
        return objectMouseOver;
    }
}

