/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.util;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;

public final class WorldHelper {
    public static boolean calledByLogicalServer(World world) {
        return !world.field_72995_K;
    }

    public static boolean calledByLogicalClient(World world) {
        return world.field_72995_K;
    }

    public static String getWorldSideName(World world) {
        return world.field_72995_K ? "CLIENT" : "SERVER";
    }

    public static boolean isEntityInRange(Entity entity, double x, double y, double z, double range) {
        return entity.func_70092_e(x + 0.5, y + 0.5, z + 0.5) < range * range;
    }

    public static boolean isEntityInRange(Entity entity, BlockPos position, double range) {
        return entity.func_70092_e((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5) < range * range;
    }

    public static void spawnVanillaParticles(World world, EnumParticleTypes particle, int minCount, int maxCount, int x, int y, int z, int offsetX, int offsetY, int offsetZ) {
        if (null == world) {
            return;
        }
        Random rand = world.field_73012_v;
        int howMany = MathHelper.func_76136_a((Random)rand, (int)minCount, (int)maxCount);
        double px1 = (double)(x - offsetX) + 0.5;
        double px2 = (double)(x + offsetX) + 0.5;
        double py1 = y;
        double py2 = y + offsetY;
        double pz1 = (double)(z - offsetZ) + 0.5;
        double pz2 = (double)(z + offsetZ) + 0.5;
        if (world instanceof WorldServer) {
            WorldServer ws = (WorldServer)world;
            double motionX = rand.nextGaussian() * 0.02;
            double motionY = rand.nextGaussian() * 0.02;
            double motionZ = rand.nextGaussian() * 0.02;
            double pX = MathHelper.func_82716_a((Random)rand, (double)px1, (double)px2);
            double pY = MathHelper.func_82716_a((Random)rand, (double)py1, (double)py2);
            double pZ = MathHelper.func_82716_a((Random)rand, (double)pz1, (double)pz2);
            ws.func_175739_a(particle, pX, pY, pZ, howMany, motionX, motionY, motionZ, rand.nextGaussian() * 0.02, new int[0]);
        } else {
            for (int i = 0; i < howMany; ++i) {
                double motionX = rand.nextGaussian() * 0.02;
                double motionY = rand.nextGaussian() * 0.02;
                double motionZ = rand.nextGaussian() * 0.02;
                double pX = MathHelper.func_82716_a((Random)rand, (double)px1, (double)px2);
                double pY = MathHelper.func_82716_a((Random)rand, (double)py1, (double)py2);
                double pZ = MathHelper.func_82716_a((Random)rand, (double)pz1, (double)pz2);
                world.func_175688_a(particle, pX, pY, pZ, motionX, motionY, motionZ, new int[0]);
            }
        }
    }

    public static void spawnItemStack(ItemStack stack, World world, double x, double y, double z, boolean withMomentum) {
        float z2;
        float y2;
        float x2;
        if (withMomentum) {
            x2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            y2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            z2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        } else {
            x2 = 0.5f;
            y2 = 0.0f;
            z2 = 0.5f;
        }
        EntityItem entity = new EntityItem(world, x + (double)x2, y + (double)y2, z + (double)z2, stack.func_77946_l());
        if (withMomentum) {
            entity.field_70159_w = (float)world.field_73012_v.nextGaussian() * 0.05f;
            entity.field_70181_x = (float)world.field_73012_v.nextGaussian() * 0.05f + 0.2f;
            entity.field_70179_y = (float)world.field_73012_v.nextGaussian() * 0.05f;
        } else {
            entity.field_70181_x = -0.05f;
            entity.field_70159_w = 0.0;
            entity.field_70179_y = 0.0;
        }
        world.func_72838_d((Entity)entity);
    }

    public static int getChunkXFromBlock(int blockX) {
        return blockX >> 4;
    }

    public static int getChunkXFromBlock(BlockPos position) {
        return position.func_177958_n() >> 4;
    }

    public static int getChunkZFromBlock(int blockZ) {
        return blockZ >> 4;
    }

    public static int getChunkZFromBlock(BlockPos position) {
        return position.func_177952_p() >> 4;
    }

    public static long getChunkXZHashFromBlock(int blockX, int blockZ) {
        return ChunkPos.func_77272_a((int)WorldHelper.getChunkXFromBlock(blockX), (int)WorldHelper.getChunkZFromBlock(blockZ));
    }

    public static long getChunkXZHashFromBlock(BlockPos position) {
        return ChunkPos.func_77272_a((int)WorldHelper.getChunkXFromBlock(position), (int)WorldHelper.getChunkZFromBlock(position));
    }

    @Deprecated
    public static boolean blockChunkExists(IChunkProvider chunkProvider, BlockPos position) {
        return null != chunkProvider.func_186026_b(WorldHelper.getChunkXFromBlock(position), WorldHelper.getChunkZFromBlock(position));
    }

    public static void notifyBlockUpdate(World world, BlockPos position, IBlockState oldState, IBlockState newState) {
        if (null == oldState) {
            oldState = world.func_180495_p(position);
        }
        if (null == newState) {
            newState = oldState;
        }
        world.func_184138_a(position, oldState, newState, 3);
    }

    public static void notifyNeighborsOfStateChange(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block blockType) {
        world.func_175685_c(pos, blockType, false);
    }

    private WorldHelper() {
    }
}

