/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client;

import it.zerono.mods.zerocore.util.CodeHelper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class VersionChecker {
    private static List<ModVersionData> s_pendingNotifications;

    public static void scheduleCheck(String url) {
        URL checkURL;
        ModContainer mc = Loader.instance().activeModContainer();
        if (null == mc || null == url || url.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder(url);
        sb.append("?mod=");
        sb.append(mc.getModId());
        sb.append("&mc=");
        sb.append("1.11.2");
        try {
            checkURL = new URL(sb.toString());
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return;
        }
        new VersionCheckerThread(new ModVersionData(mc, checkURL)).start();
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent evt) {
        List<ModVersionData> notifications = VersionChecker.getPendingNotifications();
        if (null == notifications) {
            return;
        }
        for (ModVersionData versionData : notifications) {
            if (null == versionData || !versionData.isNewVersionAvailable()) continue;
            String updateMessage = versionData.getUpdateMessage();
            TextComponentTranslation msg = null == updateMessage || updateMessage.isEmpty() ? new TextComponentTranslation("zerocore:vercheck.update1", new Object[]{versionData.getLastVersion(), versionData.getName()}) : new TextComponentTranslation("zerocore:vercheck.update2", new Object[]{versionData.getLastVersion(), versionData.getName(), updateMessage});
            CodeHelper.sendChatMessage((ICommandSender)evt.player, (ITextComponent)msg);
        }
    }

    private static synchronized void addNotification(ModVersionData data) {
        if (null == s_pendingNotifications) {
            s_pendingNotifications = new ArrayList<ModVersionData>();
        }
        s_pendingNotifications.add(data);
    }

    private static synchronized List<ModVersionData> getPendingNotifications() {
        List<ModVersionData> notifications = s_pendingNotifications;
        s_pendingNotifications = null;
        return notifications;
    }

    private static class VersionCheckerThread
    extends Thread {
        private final ModVersionData _modData;

        public VersionCheckerThread(ModVersionData modVersionData) {
            this.setName("Zero CORE version checker thread");
            this._modData = modVersionData;
        }

        @Override
        public void run() {
            HttpURLConnection cn = this.openConnection();
            String reply = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(cn.getInputStream()));){
                reply = reader.readLine();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (null == reply || reply.isEmpty()) {
                return;
            }
            String[] tokens = reply.split(";");
            if (0 == tokens.length) {
                return;
            }
            if (0 == tokens[0].compareToIgnoreCase("OK") && tokens.length > 1) {
                String lastVersion = tokens[1];
                String updateMessage = tokens.length > 2 ? tokens[2] : "";
                this._modData.update(lastVersion, updateMessage);
                VersionChecker.addNotification(this._modData);
            } else {
                FMLLog.warning((String)"Update check for mod %s failed : %s", (Object[])new Object[]{this._modData.getName(), reply});
            }
        }

        private HttpURLConnection openConnection() {
            try {
                HttpURLConnection cn = (HttpURLConnection)this._modData.getCheckURL().openConnection();
                cn.setConnectTimeout(3000);
                cn.setReadTimeout(3000);
                cn.setRequestMethod("GET");
                return cn;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }

    private static class ModVersionData {
        private final ModContainer _container;
        private final URL _checkURL;
        private String _lastVersion;
        private String _updateMessage;

        public ModVersionData(ModContainer container, URL url) {
            this._container = container;
            this._checkURL = url;
            this._updateMessage = null;
            this._lastVersion = null;
        }

        public String getName() {
            return this._container.getName();
        }

        public URL getCheckURL() {
            return this._checkURL;
        }

        public String getCurrentVersion() {
            return this._container.getVersion();
        }

        public String getLastVersion() {
            return this._lastVersion;
        }

        public String getUpdateMessage() {
            return this._updateMessage;
        }

        public void update(String lastVersion, String updateMessage) {
            this._lastVersion = lastVersion;
            this._updateMessage = updateMessage;
        }

        public boolean isNewVersionAvailable() {
            ComparableVersion current = new ComparableVersion(this.getCurrentVersion());
            ComparableVersion last = new ComparableVersion(this.getLastVersion());
            return last.compareTo(current) > 0;
        }
    }
}

