/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.common.item;

import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.IGameObject;
import it.zerono.mods.zerocore.util.CodeHelper;
import it.zerono.mods.zerocore.util.OreDictionaryHelper;
import it.zerono.mods.zerocore.util.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDebugTool
extends Item
implements IGameObject {
    public ItemDebugTool(String itemName) {
        this.setRegistryName(itemName);
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    @Override
    public void onPostRegister() {
    }

    @Override
    public void onPostClientRegister() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    @Override
    public void registerOreDictionaryEntries() {
    }

    @Override
    public void registerRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 1, 0), (Object[])new Object[]{"IDI", "CGX", "IRI", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('D'), Items.field_151114_aO, Character.valueOf('C'), Items.field_151132_bS, Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('X'), Items.field_151111_aL, Character.valueOf('R'), Items.field_151137_ax});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"zerocore:debugTool.block.tooltip1", (Object[])new Object[0]));
        tooltip.add("");
        tooltip.add(I18n.func_135052_a((String)"zerocore:debugTool.block.tooltip2", (Object[])new Object[]{TextFormatting.ITALIC.toString()}));
        tooltip.add(I18n.func_135052_a((String)"zerocore:debugTool.block.tooltip3", (Object[])new Object[]{TextFormatting.GREEN, TextFormatting.GRAY.toString() + TextFormatting.ITALIC.toString()}));
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (player.func_70093_af() != WorldHelper.calledByLogicalClient(world)) {
            return EnumActionResult.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IDebuggable) {
            IDebuggable debugee = (IDebuggable)te;
            MessagesPool pool = new MessagesPool();
            debugee.getDebugMessages(pool);
            if (pool.MESSAGES.size() > 0) {
                this.sendMessages(player, (ITextComponent)new TextComponentTranslation("zerocore:debugTool.tile.header", new Object[]{WorldHelper.getWorldSideName(world), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}), pool);
                return EnumActionResult.SUCCESS;
            }
        }
        if (!world.func_175623_d(pos)) {
            IBlockState blockState = world.func_180495_p(pos);
            String[] names = OreDictionaryHelper.getOreNames(blockState);
            MessagesPool pool = new MessagesPool();
            TextComponentTranslation header = new TextComponentTranslation("zerocore:debugTool.block.header", new Object[]{WorldHelper.getWorldSideName(world), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
            if (null != names && names.length > 0) {
                pool.add("zerocore:debugTool.block.intro", names.length, blockState.func_177230_c().func_149739_a());
                for (String name : names) {
                    pool.add("zerocore:debugTool.block.nameentry", name);
                }
            } else {
                pool.add("zerocore:debugTool.block.notfound", new Object[0]);
            }
            this.sendMessages(player, (ITextComponent)header, pool);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private void sendMessages(EntityPlayer player, ITextComponent header, MessagesPool pool) {
        CodeHelper.sendChatMessage((ICommandSender)player, header);
        for (ITextComponent message : pool.MESSAGES) {
            CodeHelper.sendChatMessage((ICommandSender)player, message);
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    private static final class MessagesPool
    implements IDebugMessages {
        final List<ITextComponent> MESSAGES = new ArrayList<ITextComponent>(2);

        @Override
        public void add(ITextComponent message) {
            this.MESSAGES.add(message);
        }

        @Override
        public void add(String messageFormatStringResourceKey, Object ... messageParameters) {
            this.MESSAGES.add((ITextComponent)new TextComponentTranslation(messageFormatStringResourceKey, messageParameters));
        }
    }
}

