/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.tileentities;

import java.awt.Color;
import java.util.List;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.capabilities.hud.HudInfoLine;
import net.ndrei.teslacorelib.compatibility.ItemStackUtil;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.containers.FilteredSlot;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.WorkEnergyIndicatorPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.inventory.EnergyStorage;
import net.ndrei.teslacorelib.items.BaseAddon;
import net.ndrei.teslacorelib.items.SpeedUpgradeTier1;
import net.ndrei.teslacorelib.items.SpeedUpgradeTier2;
import net.ndrei.teslacorelib.tileentities.ElectricTileEntity;
import net.ndrei.teslacorelib.tileentities.IWorkEnergyProvider;

public abstract class ElectricMachine
extends ElectricTileEntity
implements IWorkEnergyProvider {
    private int lastWorkTicks = 0;
    private int workTick = 0;
    protected boolean outOfPower = false;
    private ItemStackHandler energyItems;
    private EnergyStorage workEnergy;

    protected ElectricMachine(int typeId) {
        super(typeId);
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.energyItems = new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                ElectricMachine.this.func_70296_d();
            }
        };
        super.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.energyItems, EnumDyeColor.CYAN, "Energy Items", new BoundingRectangle(25, 25, 18, 54)){

            @Override
            public boolean canInsertItem(int slot, ItemStack stack) {
                return ElectricMachine.this.canInsertEnergyItem(slot, stack);
            }

            @Override
            public boolean canExtractItem(int slot) {
                return slot != 0;
            }

            @Override
            public List<Slot> getSlots(BasicTeslaContainer container) {
                List<Slot> slots = super.getSlots(container);
                slots.add((Slot)new FilteredSlot(this.getItemHandlerForContainer(), 0, 26, 26));
                slots.add((Slot)new FilteredSlot(this.getItemHandlerForContainer(), 1, 26, 62));
                return slots;
            }

            @Override
            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
                pieces.add(new BasicRenderedGuiPiece(25, 25, 18, 54, BasicTeslaGuiContainer.MACHINE_BACKGROUND, 78, 189));
                return pieces;
            }
        });
        super.addInventoryToStorage(this.energyItems, "inv_energy_items");
    }

    private boolean canInsertEnergyItem(int slot, ItemStack stack) {
        ITeslaProducer tesla;
        if (slot != 0) {
            return false;
        }
        ITeslaProducer iTeslaProducer = tesla = stack.hasCapability(TeslaCapabilities.CAPABILITY_PRODUCER, null) ? (ITeslaProducer)stack.getCapability(TeslaCapabilities.CAPABILITY_PRODUCER, null) : null;
        if (tesla != null) {
            ITeslaHolder holder;
            ITeslaHolder iTeslaHolder = holder = stack.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, null) ? (ITeslaHolder)stack.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, null) : null;
            if (holder == null || holder.getStoredPower() > 0L) {
                return true;
            }
        }
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("tick_work", this.workTick);
        compound.func_74768_a("tick_lastWork", this.lastWorkTicks);
        compound.func_74757_a("out_of_power", this.outOfPower);
        if (this.workEnergy != null) {
            compound.func_74782_a("work_energy", (NBTBase)this.workEnergy.serializeNBT());
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.lastWorkTicks = compound.func_74762_e("tick_lastWork");
        this.workTick = compound.func_74762_e("tick_work");
        this.outOfPower = compound.func_74767_n("out_of_power");
        if (compound.func_74764_b("work_energy")) {
            if (this.workEnergy == null) {
                this.workEnergy = new EnergyStorage(this.getEnergyForWork(), this.getEnergyForWorkRate(), 0L);
            }
            this.workEnergy.deserializeNBT(compound.func_74775_l("work_energy"));
        }
    }

    @Override
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        pieces.add(new WorkEnergyIndicatorPiece(this, 7, 20));
        return pieces;
    }

    @Override
    public List<HudInfoLine> getHUDLines() {
        List<HudInfoLine> list = super.getHUDLines();
        if (this.outOfPower) {
            list.add(new HudInfoLine(Color.RED, new Color(255, 0, 0, 42), "out of power").setTextAlignment(HudInfoLine.TextAlignment.CENTER));
        }
        return list;
    }

    protected int getMinimumWorkTicks() {
        return 10;
    }

    protected int getEnergyForWork() {
        return 600;
    }

    protected int getEnergyForWorkRate() {
        return 20;
    }

    protected float getEnergyForWorkRateMultiplier() {
        float ratio = 1.0f;
        if (this.hasAddon(SpeedUpgradeTier1.class)) {
            ratio *= 1.5f;
            if (this.hasAddon(SpeedUpgradeTier2.class)) {
                ratio *= 1.5f;
            }
        }
        return ratio;
    }

    public boolean supportsSpeedUpgrades() {
        return true;
    }

    public boolean supportsEnergyUpgrades() {
        return true;
    }

    @Override
    public long getWorkEnergyCapacity() {
        return this.workEnergy != null ? this.workEnergy.getCapacity() : 0L;
    }

    @Override
    public long getWorkEnergyStored() {
        return this.workEnergy != null ? (long)this.workEnergy.getEnergyStored() : 0L;
    }

    @Override
    public long getWorkEnergyTick() {
        return this.workEnergy != null ? this.workEnergy.getInputRate() : 0L;
    }

    private int getFinalEnergyForWork() {
        float energy = this.getEnergyForWork();
        for (BaseAddon addon : this.getAddons()) {
            if (!addon.isValid(this)) continue;
            energy *= addon.getWorkEnergyMultiplier();
        }
        return Math.round(energy);
    }

    protected void resetWorkEnergyBuffer() {
        this.workEnergy = new EnergyStorage(this.getFinalEnergyForWork(), Math.round((float)this.getEnergyForWorkRate() * this.getEnergyForWorkRateMultiplier()), 0L);
    }

    public void updateWorkEnergyRate() {
        if (this.workEnergy != null) {
            this.workEnergy.setInputRate(Math.round((float)this.getEnergyForWorkRate() * this.getEnergyForWorkRateMultiplier()));
        }
    }

    public void updateWorkEnergyCapacity() {
        if (this.workEnergy != null) {
            this.workEnergy.setCapacity(this.getFinalEnergyForWork());
        }
    }

    @Override
    public void protectedUpdate() {
        if (this.workEnergy == null) {
            this.resetWorkEnergyBuffer();
        }
        if (!this.workEnergy.isFull()) {
            long toTransfer = Math.min(this.workEnergy.getCapacity() - this.workEnergy.getStoredPower(), this.workEnergy.getInputRate());
            long transferred = this.energyStorage.takePower(toTransfer);
            this.workEnergy.givePower(transferred);
        }
        this.workTick = Math.min(this.lastWorkTicks + 1, this.workTick + 1);
        if (this.workEnergy.isFull() && this.workTick >= this.lastWorkTicks && !this.func_145831_w().field_72995_K) {
            float work = this.performWork();
            long oldCapacity = this.workEnergy.getCapacity();
            this.resetWorkEnergyBuffer();
            this.workEnergy.givePower(Math.round((float)oldCapacity * (1.0f - Math.max(0.0f, Math.min(1.0f, work)))));
            this.workTick = 0;
            this.lastWorkTicks = this.getMinimumWorkTicks();
            this.forceSync();
        }
    }

    protected abstract float performWork();

    @Override
    protected void processImmediateInventories() {
        ItemStack stack;
        super.processImmediateInventories();
        if (this.energyItems != null && !ItemStackUtil.isEmpty(stack = this.energyItems.getStackInSlot(0))) {
            ITeslaProducer producer = (ITeslaProducer)stack.getCapability(TeslaCapabilities.CAPABILITY_PRODUCER, null);
            if (producer != null) {
                long power = producer.takePower(this.energyStorage.getInputRate(), true);
                if (power == 0L) {
                    this.discardUsedEnergyItem();
                } else {
                    long accepted = this.energyStorage.givePower(power, false);
                    producer.takePower(accepted, false);
                }
            } else {
                this.discardUsedEnergyItem();
            }
        }
    }

    private void discardUsedEnergyItem() {
        ItemStack stack = this.energyItems.getStackInSlot(0);
        ItemStack remaining = this.energyItems.insertItem(1, stack, false);
        this.energyItems.setStackInSlot(0, remaining);
    }
}

