/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.tileentities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.compatibility.ItemStackUtil;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.containers.FilteredSlot;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.inventory.EnergyStorage;
import net.ndrei.teslacorelib.tileentities.ElectricTileEntity;

public abstract class ElectricGenerator
extends ElectricTileEntity {
    private EnergyStorage generatedPower = null;
    private ItemStackHandler chargePadItems;

    protected ElectricGenerator(int typeId) {
        super(typeId);
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.chargePadItems = new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                ElectricGenerator.this.func_70296_d();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
        super.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.chargePadItems, EnumDyeColor.BROWN, "Charge Pad", new BoundingRectangle(34, 34, 18, 36)){

            @Override
            public boolean canInsertItem(int slot, ItemStack stack) {
                return !ItemStackUtil.isEmpty(stack) && stack.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, null);
            }

            @Override
            public boolean canExtractItem(int slot) {
                ItemStack stack = this.getStackInSlot(slot);
                if (!ItemStackUtil.isEmpty(stack)) {
                    ITeslaHolder holder = (ITeslaHolder)stack.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, null);
                    if (holder != null) {
                        return holder.getCapacity() == holder.getStoredPower();
                    }
                    ITeslaConsumer consumer = (ITeslaConsumer)stack.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, null);
                    if (consumer != null) {
                        long consumed = consumer.givePower(1L, true);
                        return consumed == 0L;
                    }
                }
                return true;
            }

            @Override
            public List<Slot> getSlots(BasicTeslaContainer container) {
                List<Slot> slots = super.getSlots(container);
                slots.add((Slot)new FilteredSlot(this.getItemHandlerForContainer(), 0, 35, 35));
                slots.add((Slot)new FilteredSlot(this.getItemHandlerForContainer(), 1, 35, 53));
                return slots;
            }

            @Override
            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
                pieces.add(new BasicRenderedGuiPiece(25, 26, 27, 52, BasicTeslaGuiContainer.MACHINE_BACKGROUND, 206, 4));
                return pieces;
            }
        });
        super.addInventoryToStorage(this.chargePadItems, "inv_charge_pad");
    }

    @Override
    protected long getMaxEnergy() {
        return 100000L;
    }

    @Override
    protected long getEnergyInputRate() {
        return 0L;
    }

    @Override
    protected long getEnergyOutputRate() {
        return 80L;
    }

    protected long getEnergyFillRate() {
        return 160L;
    }

    protected abstract long consumeFuel();

    protected void fuelConsumed() {
    }

    protected boolean isGeneratedPowerLostIfFull() {
        return true;
    }

    @Override
    public void protectedUpdate() {
        List<EnumFacing> powerSides;
        long power;
        if (this.generatedPower != null && !this.generatedPower.isEmpty()) {
            power = this.generatedPower.takePower(this.generatedPower.getOutputRate(), !this.isGeneratedPowerLostIfFull());
            long consumed = this.energyStorage.givePower(power);
            if (consumed > 0L && this.isGeneratedPowerLostIfFull()) {
                this.generatedPower.takePower(consumed);
            }
            if (this.generatedPower.isEmpty()) {
                this.fuelConsumed();
            }
        }
        if (!(this.generatedPower != null && !this.generatedPower.isEmpty() || this.energyStorage.isFull() || this.func_145831_w().field_72995_K)) {
            this.generatedPower = null;
            power = this.consumeFuel();
            if (power > 0L) {
                this.generatedPower = new EnergyStorage(power, 0L, this.getEnergyFillRate());
                this.generatedPower.givePower(power);
                this.forceSync();
            }
        }
        if (!this.energyStorage.isEmpty() && (powerSides = this.sideConfig.getSidesForColor(this.energyStorage.getColor())) != null && powerSides.size() > 0) {
            ArrayList consumers = Lists.newArrayList();
            BlockPos pos = this.func_174877_v();
            EnumFacing facing = this.getFacing();
            for (EnumFacing side : powerSides) {
                ITeslaConsumer consumer;
                TileEntity entity;
                EnumFacing oriented = this.orientFacing(side);
                if (oriented != EnumFacing.DOWN && oriented != EnumFacing.UP && (facing == EnumFacing.EAST || facing == EnumFacing.WEST)) {
                    oriented = oriented.func_176734_d();
                }
                if ((entity = this.func_145831_w().func_175625_s(pos.func_177972_a(oriented))) == null || !entity.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, oriented.func_176734_d()) || (consumer = (ITeslaConsumer)entity.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, oriented.func_176734_d())) == null) continue;
                consumers.add(consumer);
            }
            if (consumers.size() > 0) {
                long total = this.energyStorage.getOutputRate();
                total = this.energyStorage.takePower(total, true);
                long totalConsumed = 0L;
                int consumerCount = consumers.size();
                for (ITeslaConsumer consumer : consumers) {
                    long consumed;
                    long perConsumer = total / (long)consumerCount;
                    --consumerCount;
                    if (perConsumer <= 0L || (consumed = consumer.givePower(perConsumer, false)) <= 0L) continue;
                    totalConsumed += consumed;
                }
                if (totalConsumed > 0L) {
                    this.energyStorage.takePower(totalConsumed);
                }
            }
        }
    }

    @Override
    protected void processImmediateInventories() {
        super.processImmediateInventories();
        for (int index = 0; index < 2; ++index) {
            long consumed;
            ItemStack stack = this.chargePadItems.getStackInSlot(index);
            if (ItemStackUtil.isEmpty(stack)) continue;
            long available = this.energyStorage.takePower(this.energyStorage.getOutputRate(), true);
            if (available == 0L) break;
            ITeslaConsumer consumer = (ITeslaConsumer)stack.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, null);
            if (consumer == null || (consumed = consumer.givePower(available, false)) <= 0L) continue;
            this.energyStorage.takePower(consumed, false);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        if (this.generatedPower != null) {
            compound.func_74782_a("generated_energy", (NBTBase)this.generatedPower.serializeNBT());
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("generated_energy")) {
            if (this.generatedPower == null) {
                this.generatedPower = new EnergyStorage(0L, 0L, 0L);
            }
            this.generatedPower.deserializeNBT(compound.func_74775_l("generated_energy"));
        }
    }

    public long getGeneratedPowerCapacity() {
        return this.generatedPower == null ? 0L : this.generatedPower.getCapacity();
    }

    public long getGeneratedPowerStored() {
        return this.generatedPower == null ? 0L : this.generatedPower.getStoredPower();
    }

    public long getGeneratedPowerReleaseRate() {
        return this.generatedPower == null ? 0L : this.generatedPower.getOutputRate();
    }
}

