/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.items;

import java.util.HashMap;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.ndrei.teslacorelib.items.BaseAddon;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;

public class BaseTieredAddon
extends BaseAddon {
    public BaseTieredAddon(String modId, CreativeTabs tab, String registryName) {
        super(modId, tab, registryName);
    }

    protected boolean hasSameFunction(BaseTieredAddon other) {
        return other != null && (((Object)((Object)this)).getClass().isAssignableFrom(((Object)((Object)other)).getClass()) || this.getAddonFunction().equals(other.getAddonFunction()));
    }

    protected String getAddonFunction() {
        return this.getRegistryName().toString();
    }

    protected int getTier() {
        return 1;
    }

    public boolean isTierValid(SidedTileEntity machine, int tier, boolean ignoreSameTier) {
        if (tier == 1 && ignoreSameTier) {
            return true;
        }
        HashMap<Integer, BaseTieredAddon> tiers = new HashMap<Integer, BaseTieredAddon>();
        List<BaseAddon> addons = machine.getAddons();
        if (addons != null) {
            for (BaseAddon addon : addons) {
                if (!(addon instanceof BaseTieredAddon)) break;
                BaseTieredAddon tiered = (BaseTieredAddon)addon;
                if (!this.hasSameFunction(tiered)) continue;
                if (tiered.getTier() == tier && !ignoreSameTier) {
                    return false;
                }
                tiers.put(tiered.getTier(), tiered);
            }
        }
        for (int index = 1; index < tier; ++index) {
            if (tiers.containsKey(index)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canBeAddedTo(SidedTileEntity machine) {
        return this.isTierValid(machine, this.getTier(), false);
    }

    @Override
    public boolean isValid(SidedTileEntity machine) {
        return super.isValid(machine) && this.isTierValid(machine, this.getTier(), true);
    }
}

