/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.inventory;

import java.util.Arrays;
import java.util.List;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import net.ndrei.teslacorelib.capabilities.inventory.SidedItemHandlerConfig;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.inventory.ISidedItemHandler;
import net.ndrei.teslacorelib.inventory.MultiItemHandler;
import net.ndrei.teslacorelib.inventory.SidedItemHandlerWrapper;

public class SidedItemHandler
extends MultiItemHandler
implements ISidedItemHandler {
    private SidedItemHandlerConfig sidedConfig = null;

    public SidedItemHandler(SidedItemHandlerConfig config) {
        this(null, config);
    }

    public SidedItemHandler(List<IItemHandler> handlers, SidedItemHandlerConfig config) {
        super(handlers);
        this.sidedConfig = config;
    }

    @Override
    public int[] getSlotsForFace(EnumFacing side) {
        int[] result = new int[]{};
        int index = 0;
        for (int i = 0; i < this.getInventories(); ++i) {
            EnumDyeColor color;
            IItemHandler handler = this.getInventory(i);
            int size = handler.getSlots();
            if (handler instanceof ColoredItemHandler && this.sidedConfig.isSideSet(color = ((ColoredItemHandler)handler).getColor(), side)) {
                int startIndex = result.length;
                result = Arrays.copyOf(result, result.length + size);
                for (int x = 0; x < size; ++x) {
                    result[startIndex + x] = index + x;
                }
            }
            index += size;
        }
        return result;
    }

    public SidedItemHandlerWrapper getSideWrapper(EnumFacing side) {
        return new SidedItemHandlerWrapper(this, side);
    }
}

