/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.inventory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.ndrei.teslacorelib.capabilities.inventory.ISidedItemHandlerConfig;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.FluidTankPiece;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.IGuiContainerPiecesProvider;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredFluidHandler;
import net.ndrei.teslacorelib.inventory.FluidStorage;

public class SidedFluidHandler
extends FluidStorage
implements ICapabilityProvider,
IGuiContainerPiecesProvider {
    private ISidedItemHandlerConfig sidedConfig;

    public SidedFluidHandler(ISidedItemHandlerConfig sidedConfig) {
        this.sidedConfig = sidedConfig;
    }

    private List<IFluidTank> getTanksForSide(EnumFacing facing) {
        ArrayList list = Lists.newArrayList();
        for (IFluidTank tank : this.getTanks()) {
            EnumDyeColor color;
            if (!(tank instanceof ColoredFluidHandler) || (color = ((ColoredFluidHandler)tank).getColor()) == null || facing != null && !this.sidedConfig.isSideSet(color, facing)) continue;
            list.add(tank);
        }
        return list;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            List<IFluidTank> tanks = this.getTanksForSide(facing);
            return tanks.size() > 0;
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            List<IFluidTank> tanks = this.getTanksForSide(facing);
            FluidStorage tempStorage = new FluidStorage();
            for (IFluidTank tank : tanks) {
                tempStorage.addTank(tank);
            }
            return (T)tempStorage;
        }
        return null;
    }

    @Override
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        ArrayList list = Lists.newArrayList();
        for (IFluidTank tank : this.getTanks()) {
            BoundingRectangle box;
            if (!(tank instanceof ColoredFluidHandler) || (box = ((ColoredFluidHandler)tank).getBoundingBox()) == null) continue;
            list.add(new FluidTankPiece(tank, box.getLeft(), box.getTop()));
        }
        return list;
    }
}

