/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.inventory;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.ndrei.teslacorelib.compatibility.ItemStackUtil;
import net.ndrei.teslacorelib.inventory.IFilteredItemHandler;

public class FilteredItemHandler
implements IFilteredItemHandler {
    protected final IItemHandler handler;

    protected FilteredItemHandler(IItemHandler handler) {
        this.handler = handler;
        if (null == this.handler) {
            throw new RuntimeException("No inner IItemHandler provided.");
        }
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public boolean canExtractItem(int slot) {
        return true;
    }

    public final int getSlots() {
        return this.handler.getSlots();
    }

    @Nonnull
    public final ItemStack getStackInSlot(int slot) {
        return this.handler.getStackInSlot(slot);
    }

    @Nonnull
    public final ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.canInsertItem(slot, stack)) {
            return stack;
        }
        return this.handler.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public final ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.canExtractItem(slot)) {
            return ItemStackUtil.getEmptyStack();
        }
        return this.handler.extractItem(slot, amount, simulate);
    }

    public final int getSlotLimit(int slot) {
        return this.handler.getSlotLimit(slot);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (!(this.handler instanceof IItemHandlerModifiable)) {
            throw new RuntimeException("Inner item handler is not modifiable.");
        }
        ((IItemHandlerModifiable)this.handler).setStackInSlot(slot, stack);
    }
}

