/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.gui;

import com.google.common.collect.Lists;
import java.util.List;
import net.ndrei.teslacorelib.capabilities.inventory.SidedItemHandlerConfig;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.gui.BasicContainerGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.SideConfigurator;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandlerInfo;

public class SideConfigSelector
extends BasicContainerGuiPiece {
    private SidedItemHandlerConfig sidedConfig;
    private SideConfigurator configurator;
    private int selectedInventory = -1;

    public SideConfigSelector(int left, int top, int width, int height, SidedItemHandlerConfig sidedConfig, SideConfigurator configurator) {
        super(left, top, width, height);
        this.sidedConfig = sidedConfig;
        this.configurator = configurator;
    }

    @Override
    public void drawBackgroundLayer(BasicTeslaGuiContainer container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
        List<ColoredItemHandlerInfo> colors = this.sidedConfig.getColoredInfo();
        if (colors != null && colors.size() > 0) {
            container.bindDefaultTexture();
            for (int i = 0; i < colors.size() && i < 8; ++i) {
                container.drawTexturedRect(this.getLeft() + 2 + i * 18, this.getTop() + 2, i == this.selectedInventory ? 128 : 110, 210, 14, 14);
                container.drawFilledRect(guiX + this.getLeft() + 4 + i * 18, guiY + this.getTop() + 4, 10, 10, -16777216 + colors.get((int)i).getColor().func_176768_e().field_76291_p);
            }
        }
    }

    @Override
    public void drawForegroundLayer(BasicTeslaGuiContainer container, int guiX, int guiY, int mouseX, int mouseY) {
        int localX;
        int index;
        int localY;
        List<ColoredItemHandlerInfo> colors = this.sidedConfig.getColoredInfo();
        if (this.isInside(container, mouseX, mouseY) && (localY = mouseY - guiY - this.getTop()) >= 2 && localY <= 14 && (index = (localX = mouseX - guiX - this.getLeft()) / 18) != this.selectedInventory && index >= 0 && index < colors.size() && index < 8 && colors.get(index).getHighlight() != null && (localX -= index * 18) >= 2 && localX <= 14) {
            BoundingRectangle box = colors.get(index).getHighlight();
            container.drawFilledRect(box.getLeft(), box.getTop(), box.getWidth(), box.getHeight(), 0x42000000 + colors.get((int)index).getColor().func_176768_e().field_76291_p, -16777216 + colors.get((int)index).getColor().func_176768_e().field_76291_p);
        }
        if (this.selectedInventory >= 0 && this.selectedInventory < colors.size()) {
            BoundingRectangle box = colors.get(this.selectedInventory).getHighlight();
            container.drawFilledRect(box.getLeft(), box.getTop(), box.getWidth(), box.getHeight(), 0x42000000 + colors.get((int)this.selectedInventory).getColor().func_176768_e().field_76291_p, -16777216 + colors.get((int)this.selectedInventory).getColor().func_176768_e().field_76291_p);
        }
    }

    @Override
    public void drawForegroundTopLayer(BasicTeslaGuiContainer container, int guiX, int guiY, int mouseX, int mouseY) {
        int localY;
        if (this.isInside(container, mouseX, mouseY) && (localY = mouseY - guiY - this.getTop()) >= 2 && localY <= 14) {
            String label;
            int localX = mouseX - guiX - this.getLeft();
            int index = localX / 18;
            List<ColoredItemHandlerInfo> colors = this.sidedConfig.getColoredInfo();
            if (index >= 0 && index < colors.size() && index < 8 && colors.get(index).getHighlight() != null && (localX -= index * 18) >= 2 && localX <= 14 && (label = colors.get(index).getName()) != null && label.length() > 0) {
                container.drawTooltip(Lists.newArrayList((Object[])new String[]{label}), this.getLeft() + index * 18 + 9, this.getTop() + this.getHeight() / 2);
            }
        }
    }

    @Override
    public void mouseClicked(BasicTeslaGuiContainer container, int mouseX, int mouseY, int mouseButton) {
        BasicTeslaContainer slots;
        int localY;
        int oldIndex = this.selectedInventory;
        this.selectedInventory = -1;
        if (this.isInside(container, mouseX, mouseY) && (localY = mouseY - container.getGuiTop() - this.getTop()) >= 2 && localY <= 14) {
            int localX = mouseX - container.getGuiLeft() - this.getLeft();
            int index = localX / 18;
            List<ColoredItemHandlerInfo> colors = this.sidedConfig.getColoredInfo();
            if (index != oldIndex && index >= 0 && index < colors.size() && index < 8 && colors.get(index).getHighlight() != null && (localX -= index * 18) >= 2 && localX <= 14) {
                this.selectedInventory = index;
            }
        }
        if (this.configurator != null) {
            this.configurator.setSelectedInventory(this.selectedInventory);
        }
        if ((slots = container.getTeslaContainer()) != null) {
            if (this.selectedInventory >= 0) {
                slots.hidePlayerInventory();
            } else {
                slots.showPlayerInventory();
            }
        }
    }
}

