/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.gui;

import com.google.common.collect.Lists;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.ndrei.teslacorelib.gui.BasicContainerGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import org.lwjgl.opengl.GL11;

public class FluidTankPiece
extends BasicContainerGuiPiece {
    public static final int WIDTH = 18;
    public static final int HEIGHT = 54;
    private IFluidTank tank;

    public FluidTankPiece(IFluidTank tank, int left, int top) {
        super(left, top, 18, 54);
        this.tank = tank;
    }

    @Override
    public void drawBackgroundLayer(BasicTeslaGuiContainer container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
        FluidStack stack;
        container.bindDefaultTexture();
        container.drawTexturedRect(this.getLeft(), this.getTop(), 1, 189, this.getWidth(), this.getHeight());
        container.drawTexturedRect(this.getLeft() + 2, this.getTop() + 2, 48, 191, this.getWidth() - 4, this.getHeight() - 4);
        if (this.tank != null && (stack = this.tank.getFluid()) != null && stack.amount > 0) {
            int amount = stack.amount * (this.getHeight() - 6) / this.tank.getCapacity();
            if (stack.getFluid() != null) {
                Fluid fluid = stack.getFluid();
                int color = fluid.getColor(stack);
                ResourceLocation still = fluid.getFlowing(stack);
                if (still != null) {
                    TextureAtlasSprite sprite = container.field_146297_k.func_147117_R().getTextureExtry(still.toString());
                    if (sprite == null) {
                        sprite = container.field_146297_k.func_147117_R().func_174944_f();
                    }
                    container.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                    GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
                    GlStateManager.func_179147_l();
                    container.func_175175_a(guiX + this.getLeft() + 3, guiY + this.getTop() + 3 + this.getHeight() - 6 - amount, sprite, this.getWidth() - 6, amount);
                    GlStateManager.func_179084_k();
                }
            }
        }
        container.bindDefaultTexture();
        container.drawTexturedRect(this.getLeft() + 2, this.getTop() + 2, 63, 191, this.getWidth() - 4, this.getHeight() - 4);
    }

    @Override
    public void drawForegroundTopLayer(BasicTeslaGuiContainer container, int guiX, int guiY, int mouseX, int mouseY) {
        FluidStack fluid;
        if (super.isInside(container, mouseX, mouseY) && this.tank != null && (fluid = this.tank.getFluid()) != null) {
            ArrayList lines = Lists.newArrayList();
            lines.add(String.format("%sFluid: %s%s", ChatFormatting.DARK_PURPLE, ChatFormatting.LIGHT_PURPLE, fluid.getLocalizedName()));
            lines.add(String.format("%s%,d mb %sof", ChatFormatting.AQUA, this.tank.getFluidAmount(), ChatFormatting.DARK_GRAY));
            lines.add(String.format("%s%,d mb", ChatFormatting.RESET, this.tank.getCapacity()));
            container.drawTooltip(lines, mouseX - guiX, mouseY - guiY);
        }
    }
}

