/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.compatibility;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public final class ItemStackUtil {
    public static boolean isEmpty(ItemStack stack) {
        return stack == null || stack.func_190926_b() || stack.func_190916_E() == 0;
    }

    public static void grow(ItemStack stack, int amount) {
        stack.func_190917_f(amount);
    }

    public static void shrink(ItemStack stack, int amount) {
        stack.func_190918_g(amount);
    }

    public static int getSize(ItemStack stack) {
        return ItemStackUtil.isEmpty(stack) ? 0 : stack.func_190916_E();
    }

    public static void setSize(ItemStack stack, int size) {
        stack.func_190920_e(size);
    }

    public static ItemStack copyWithSize(ItemStack stack, int size) {
        ItemStack result = stack.func_77946_l();
        result.func_190920_e(size);
        return result;
    }

    public static ItemStack getEmptyStack() {
        return ItemStack.field_190927_a;
    }

    public static List<ItemStack> getCombinedInventory(IItemHandler handler) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (ItemStackUtil.isEmpty(stack)) continue;
            ItemStack match = null;
            for (ItemStack existing : list) {
                if (existing.func_77973_b() != stack.func_77973_b()) continue;
                match = existing;
                break;
            }
            if (match == null) {
                list.add(stack.func_77946_l());
                continue;
            }
            match.func_190920_e(match.func_190916_E() + stack.func_190916_E());
        }
        return list;
    }

    public static int extractFromCombinedInventory(IItemHandler handler, ItemStack stack, int amount) {
        if (ItemStackUtil.isEmpty(stack)) {
            return 0;
        }
        int taken = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack temp = handler.getStackInSlot(i);
            if (temp == null || temp.func_190926_b() || temp.func_77973_b() != stack.func_77973_b()) continue;
            ItemStack takenStack = handler.extractItem(i, Math.min(amount, temp.func_190916_E()), false);
            taken += takenStack.func_190916_E();
            if ((amount -= takenStack.func_190916_E()) <= 0) break;
        }
        return taken;
    }

    @Nonnull
    public static ItemStack insertItemInExistingStacks(IItemHandler dest, @Nonnull ItemStack stack, boolean simulate) {
        if (dest == null || stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (int i = 0; i < dest.getSlots(); ++i) {
            if (ItemStackUtil.isEmpty(dest.getStackInSlot(i)) || !(stack = dest.insertItem(i, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }
}

