/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.Utils;
import net.ndrei.teslacorelib.compatibility.ItemStackUtil;
import net.ndrei.teslacorelib.render.HudInfoRenderer;
import net.ndrei.teslacorelib.tileentities.ElectricTileEntity;

public class OrientedBlock<T extends TileEntity>
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private Class<T> teClass;

    protected OrientedBlock(String modId, CreativeTabs tab, String registryName, Class<T> teClass) {
        this(modId, tab, registryName, teClass, Material.field_151576_e);
    }

    protected OrientedBlock(String modId, CreativeTabs tab, String registryName, Class<T> teClass, Material material) {
        super(material);
        this.teClass = teClass;
        this.setRegistryName(modId, registryName);
        this.func_149663_c(modId + "_" + registryName);
        if (tab != null) {
            this.func_149647_a(tab);
        }
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(3.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public void register() {
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this), (ResourceLocation)this.getRegistryName());
        GameRegistry.registerTileEntity(this.teClass, (String)(this.getRegistryName() + "_tile"));
        IRecipe recipe = this.getRecipe();
        if (recipe != null) {
            CraftingManager.func_77594_a().func_180302_a(recipe);
        }
    }

    protected IRecipe getRecipe() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderer() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        TileEntitySpecialRenderer<T> renderer = this.getSpecialRenderer();
        if (renderer != null) {
            ClientRegistry.bindTileEntitySpecialRenderer(this.teClass, renderer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected TileEntitySpecialRenderer<T> getSpecialRenderer() {
        return new HudInfoRenderer();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        try {
            return (TileEntity)this.teClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            TeslaCoreLib.logger.error((Object)e);
            return null;
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && !world.field_72995_K) {
            IFluidHandler tank = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            ItemStack bucket = player.func_184586_b(hand);
            if (!ItemStackUtil.isEmpty(bucket) && tank != null && bucket.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                FluidStack fluid;
                IFluidHandlerItem handler = (IFluidHandlerItem)bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                FluidStack fluidStack = fluid = handler != null ? handler.drain(1000, false) : null;
                if (fluid != null && fluid.amount == 1000) {
                    int filled = tank.fill(fluid, false);
                    if (filled == 1000) {
                        tank.fill(fluid, true);
                        if (!player.field_71075_bZ.field_75098_d) {
                            handler.drain(filled, true);
                            player.func_184611_a(hand, handler.getContainer());
                        }
                    }
                    return true;
                }
            }
        }
        if (super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (!world.field_72995_K) {
            player.openGui((Object)TeslaCoreLib.instance, 42, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        NBTTagCompound nbt;
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)Utils.getFacingFromEntity(pos, (Entity)placer)), 2);
        if (!ItemStackUtil.isEmpty(stack) && stack.func_77942_o() && (nbt = stack.func_77978_p()) != null && nbt.func_150297_b("tileentity", 10)) {
            NBTTagCompound teNBT = nbt.func_74775_l("tileentity");
            try {
                TileEntity te = this.func_149915_a(world, 0);
                if (te != null) {
                    te.deserializeNBT(teNBT);
                    world.func_175690_a(pos, te);
                }
            }
            catch (Throwable t) {
                TeslaCoreLib.logger.error((Object)t);
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity t = worldIn.func_175625_s(pos);
        if (t instanceof ElectricTileEntity) {
            ((ElectricTileEntity)t).onBlockBroken();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            TileEntity tileEntity = world.func_175625_s(pos);
            state = state.func_177226_a((IProperty)FACING, (Comparable)((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e());
            world.func_175656_a(pos, state);
            if (tileEntity != null) {
                tileEntity.func_145829_t();
                world.func_175690_a(pos, tileEntity);
            }
            return true;
        }
        return false;
    }
}

