/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.render.CCModelState;
import codechicken.lib.vec.Matrix4;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.EnumMap;
import java.util.Map;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.client.model.ForgeBlockStateV1;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class TransformUtils {
    private static final TRSRTransformation flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(TRSRTransformation.class, (Object)ForgeBlockStateV1.TRSRDeserializer.INSTANCE).create();
    public static final CCModelState DEFAULT_BLOCK;
    public static final CCModelState DEFAULT_ITEM;
    public static final CCModelState DEFAULT_TOOL;
    public static final CCModelState DEFAULT_BOW;
    public static final CCModelState DEFAULT_HANDHELD_ROD;

    public static TRSRTransformation get(float tx, float ty, float tz, float rx, float ry, float rz, float s) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(rx, ry, rz)), new Vector3f(s, s, s), null));
    }

    public static TRSRTransformation leftify(TRSRTransformation transform) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)flipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform)).compose(flipX));
    }

    public static Optional<IModelState> parseFromJson(JsonObject json) {
        int y;
        int x;
        Object rot;
        Optional ret = Optional.absent();
        if ((json.has("x") || json.has("y")) && !(ret = Optional.of((Object)new TRSRTransformation((ModelRotation)(rot = ModelRotation.func_177524_a((int)(x = JsonUtils.func_151208_a((JsonObject)json, (String)"x", (int)0)), (int)(y = JsonUtils.func_151208_a((JsonObject)json, (String)"y", (int)0))))))).isPresent()) {
            throw new JsonParseException("Invalid BlockModelRotation x: " + x + " y: " + y);
        }
        if (json.has("transform")) {
            JsonElement transformElement = json.get("transform");
            if (transformElement.isJsonPrimitive() && transformElement.getAsJsonPrimitive().isString()) {
                String transform = transformElement.getAsString();
                switch (transform) {
                    case "identity": {
                        ret = Optional.of((Object)TRSRTransformation.identity());
                        break;
                    }
                    case "ccl:default-block": {
                        ret = Optional.of((Object)DEFAULT_BLOCK);
                        break;
                    }
                    case "ccl:default-item": {
                        ret = Optional.of((Object)DEFAULT_ITEM);
                        break;
                    }
                    case "ccl:default-tool": {
                        ret = Optional.of((Object)DEFAULT_TOOL);
                        break;
                    }
                    case "ccl:default-bow": {
                        ret = Optional.of((Object)DEFAULT_BOW);
                        break;
                    }
                    case "ccl:default-handheld-rod": {
                        ret = Optional.of((Object)DEFAULT_HANDHELD_ROD);
                    }
                }
            } else if (!transformElement.isJsonObject()) {
                try {
                    TRSRTransformation base = (TRSRTransformation)GSON.fromJson(transformElement, TRSRTransformation.class);
                    ret = Optional.of((Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)base));
                }
                catch (JsonParseException e) {
                    throw new JsonParseException("transform: expected a string, object or valid base transformation, got: " + transformElement);
                }
            } else {
                TRSRTransformation t;
                JsonObject transform = transformElement.getAsJsonObject();
                EnumMap transforms = Maps.newEnumMap(ItemCameraTransforms.TransformType.class);
                if (transform.has("thirdperson")) {
                    t = (TRSRTransformation)GSON.fromJson(transform.get("thirdperson"), TRSRTransformation.class);
                    transform.remove("thirdperson");
                    transforms.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
                }
                if (transform.has("thirdperson_righthand")) {
                    t = (TRSRTransformation)GSON.fromJson(transform.get("thirdperson_righthand"), TRSRTransformation.class);
                    transform.remove("thirdperson_righthand");
                    transforms.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
                }
                if (transform.has("thirdperson_lefthand")) {
                    t = (TRSRTransformation)GSON.fromJson(transform.get("thirdperson_lefthand"), TRSRTransformation.class);
                    transform.remove("thirdperson_lefthand");
                    transforms.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
                }
                if (transform.has("firstperson")) {
                    t = (TRSRTransformation)GSON.fromJson(transform.get("firstperson"), TRSRTransformation.class);
                    transform.remove("firstperson");
                    transforms.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
                }
                if (transform.has("firstperson_righthand")) {
                    t = (TRSRTransformation)GSON.fromJson(transform.get("firstperson_righthand"), TRSRTransformation.class);
                    transform.remove("firstperson_righthand");
                    transforms.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
                }
                if (transform.has("firstperson_lefthand")) {
                    t = (TRSRTransformation)GSON.fromJson(transform.get("firstperson_lefthand"), TRSRTransformation.class);
                    transform.remove("firstperson_lefthand");
                    transforms.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
                }
                if (transform.has("head")) {
                    t = (TRSRTransformation)GSON.fromJson(transform.get("head"), TRSRTransformation.class);
                    transform.remove("head");
                    transforms.put(ItemCameraTransforms.TransformType.HEAD, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
                }
                if (transform.has("gui")) {
                    t = (TRSRTransformation)GSON.fromJson(transform.get("gui"), TRSRTransformation.class);
                    transform.remove("gui");
                    transforms.put(ItemCameraTransforms.TransformType.GUI, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
                }
                if (transform.has("ground")) {
                    t = (TRSRTransformation)GSON.fromJson(transform.get("ground"), TRSRTransformation.class);
                    transform.remove("ground");
                    transforms.put(ItemCameraTransforms.TransformType.GROUND, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
                }
                if (transform.has("fixed")) {
                    t = (TRSRTransformation)GSON.fromJson(transform.get("fixed"), TRSRTransformation.class);
                    transform.remove("fixed");
                    transforms.put(ItemCameraTransforms.TransformType.FIXED, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
                }
                int k = transform.entrySet().size();
                if (transform.has("matrix")) {
                    --k;
                }
                if (transform.has("translation")) {
                    --k;
                }
                if (transform.has("rotation")) {
                    --k;
                }
                if (transform.has("scale")) {
                    --k;
                }
                if (transform.has("post-rotation")) {
                    --k;
                }
                if (k > 0) {
                    throw new JsonParseException("transform: allowed keys: 'thirdperson', 'firstperson', 'gui', 'head', 'matrix', 'translation', 'rotation', 'scale', 'post-rotation'");
                }
                TRSRTransformation base = TRSRTransformation.identity();
                if (!transform.entrySet().isEmpty()) {
                    base = (TRSRTransformation)GSON.fromJson((JsonElement)transform, TRSRTransformation.class);
                    base = TRSRTransformation.blockCenterToCorner((TRSRTransformation)base);
                }
                Object state = transforms.isEmpty() ? base : new CCModelState((ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transforms), (Optional<TRSRTransformation>)Optional.of((Object)base));
                ret = Optional.of((Object)state);
            }
        }
        return ret;
    }

    public static TRSRTransformation fromMatrix4(Matrix4 matrix4) {
        return new TRSRTransformation(matrix4.toMatrix4f());
    }

    static {
        TRSRTransformation thirdPerson = TransformUtils.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        ImmutableMap.Builder defaultBlockBuilder = ImmutableMap.builder();
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)TransformUtils.get(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)TransformUtils.get(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)TransformUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdPerson);
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)TransformUtils.leftify(thirdPerson));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)TransformUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)TransformUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f));
        DEFAULT_BLOCK = new CCModelState((ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)defaultBlockBuilder.build());
        thirdPerson = TransformUtils.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
        TRSRTransformation firstPerson = TransformUtils.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
        ImmutableMap.Builder defaultItemBuilder = ImmutableMap.builder();
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)TransformUtils.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)TransformUtils.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdPerson);
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)TransformUtils.leftify(thirdPerson));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)firstPerson);
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)TransformUtils.leftify(firstPerson));
        DEFAULT_ITEM = new CCModelState((ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)defaultItemBuilder.build());
        ImmutableMap.Builder defaultToolBuilder = ImmutableMap.builder();
        defaultToolBuilder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)TransformUtils.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        defaultToolBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)TransformUtils.get(0.0f, 4.0f, 0.5f, 0.0f, -90.0f, 55.0f, 0.85f));
        defaultToolBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)TransformUtils.get(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f));
        defaultToolBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)TransformUtils.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        defaultToolBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)TransformUtils.get(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_TOOL = new CCModelState((ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)defaultToolBuilder.build());
        ImmutableMap.Builder defaultBowBuilder = ImmutableMap.builder();
        defaultBowBuilder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)TransformUtils.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        defaultBowBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)TransformUtils.get(-1.0f, -2.0f, 2.5f, -80.0f, 260.0f, -40.0f, 0.9f));
        defaultBowBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)TransformUtils.get(-1.0f, -2.0f, 2.5f, -80.0f, -280.0f, 40.0f, 0.9f));
        defaultBowBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)TransformUtils.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        defaultBowBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)TransformUtils.get(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_BOW = new CCModelState((ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)defaultBowBuilder.build());
        ImmutableMap.Builder defaultRodBuilder = ImmutableMap.builder();
        defaultRodBuilder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)TransformUtils.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        defaultRodBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)TransformUtils.get(0.0f, 4.0f, 2.5f, 0.0f, 90.0f, 55.0f, 0.85f));
        defaultRodBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)TransformUtils.get(0.0f, 4.0f, 2.5f, 0.0f, -90.0f, -55.0f, 0.85f));
        defaultRodBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)TransformUtils.get(0.0f, 1.6f, 0.8f, 0.0f, 90.0f, 25.0f, 0.68f));
        defaultRodBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)TransformUtils.get(0.0f, 1.6f, 0.8f, 0.0f, -90.0f, -25.0f, 0.68f));
        DEFAULT_HANDHELD_ROD = new CCModelState((ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)defaultRodBuilder.build());
    }
}

