/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model;

import codechicken.lib.util.Copyable;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class BakedModelProperties
implements Copyable<BakedModelProperties> {
    public static final BakedModelProperties DEFAULT_ITEM = new BakedModelProperties(true, false);
    public static final BakedModelProperties DEFAULT_BLOCK = new BakedModelProperties(true, true);
    private final boolean isAO;
    private final boolean isGui3D;
    private final boolean isBuiltInRenderer;
    private final TextureAtlasSprite particle;

    public BakedModelProperties(boolean isAO, boolean isGui3D) {
        this(isAO, isGui3D, false, null);
    }

    public BakedModelProperties(BakedModelProperties properties, TextureAtlasSprite sprite) {
        this(properties.isAmbientOcclusion(), properties.isGui3d(), properties.isBuiltInRenderer(), sprite);
    }

    public BakedModelProperties(boolean isAO, boolean isGui3D, TextureAtlasSprite sprite) {
        this(isAO, isGui3D, false, sprite);
    }

    public BakedModelProperties(boolean isAO, boolean isGui3D, boolean isBuiltInRenderer, TextureAtlasSprite particle) {
        this.isAO = isAO;
        this.isGui3D = isGui3D;
        this.isBuiltInRenderer = isBuiltInRenderer;
        this.particle = particle;
    }

    public static BakedModelProperties createFromModel(IBakedModel model) {
        return new BakedModelProperties(model.func_177555_b(), model.func_177556_c(), model.func_188618_c(), model.func_177554_e());
    }

    public boolean isAmbientOcclusion() {
        return this.isAO;
    }

    public boolean isGui3d() {
        return this.isGui3D;
    }

    public boolean isBuiltInRenderer() {
        return this.isBuiltInRenderer;
    }

    public TextureAtlasSprite getParticleTexture() {
        return this.particle;
    }

    @Override
    public BakedModelProperties copy() {
        return new BakedModelProperties(this.isAO, this.isGui3D, this.isBuiltInRenderer, this.particle);
    }
}

