/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import java.util.HashMap;
import java.util.Map;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.luajc.JavaGen;

public class JavaLoader
extends ClassLoader {
    private final LuaValue env;
    private Map unloaded = new HashMap();

    public JavaLoader(LuaValue luaValue) {
        this.env = luaValue;
    }

    public LuaFunction load(Prototype prototype, String string, String string2) {
        JavaGen javaGen = new JavaGen(prototype, string, string2);
        return this.load(javaGen);
    }

    public LuaFunction load(JavaGen javaGen) {
        this.include(javaGen);
        return this.load(javaGen.classname);
    }

    public LuaFunction load(String string) {
        try {
            Class<?> clazz = this.loadClass(string);
            LuaFunction luaFunction = (LuaFunction)clazz.newInstance();
            luaFunction.setfenv(this.env);
            return luaFunction;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalStateException("bad class gen: " + exception);
        }
    }

    public void include(JavaGen javaGen) {
        int n;
        this.unloaded.put(javaGen.classname, javaGen.bytecode);
        int n2 = n = javaGen.inners != null ? javaGen.inners.length : 0;
        for (int i = 0; i < n; ++i) {
            this.include(javaGen.inners[i]);
        }
    }

    public Class findClass(String string) throws ClassNotFoundException {
        byte[] byArray = (byte[])this.unloaded.get(string);
        if (byArray != null) {
            return this.defineClass(string, byArray, 0, byArray.length);
        }
        return super.findClass(string);
    }
}

