/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.lib.BaseLib;
import org.luaj.vm2.lib.IoLib;

public class JseIoLib
extends IoLib {
    protected IoLib.File wrapStdin() throws IOException {
        return new FileImpl(BaseLib.instance.STDIN);
    }

    protected IoLib.File wrapStdout() throws IOException {
        return new FileImpl(BaseLib.instance.STDOUT);
    }

    protected IoLib.File openFile(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, bl ? "r" : "rw");
        if (bl2) {
            randomAccessFile.seek(randomAccessFile.length());
        } else if (!bl) {
            randomAccessFile.setLength(0L);
        }
        return new FileImpl(randomAccessFile);
    }

    protected IoLib.File openProgram(String string, String string2) throws IOException {
        Process process = Runtime.getRuntime().exec(string);
        return "w".equals(string2) ? new FileImpl(process.getOutputStream()) : new FileImpl(process.getInputStream());
    }

    protected IoLib.File tmpFile() throws IOException {
        File file = File.createTempFile(".luaj", "bin");
        file.deleteOnExit();
        return new FileImpl(new RandomAccessFile(file, "rw"));
    }

    private static void notimplemented() {
        throw new LuaError("not implemented");
    }

    private final class FileImpl
    extends IoLib.File {
        private final RandomAccessFile file;
        private final InputStream is;
        private final OutputStream os;
        private boolean closed = false;
        private boolean nobuffer = false;

        private FileImpl(RandomAccessFile randomAccessFile, InputStream inputStream, OutputStream outputStream) {
            this.file = randomAccessFile;
            this.is = inputStream != null ? (inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream)) : null;
            this.os = outputStream;
        }

        private FileImpl(RandomAccessFile randomAccessFile) {
            this(randomAccessFile, null, null);
        }

        private FileImpl(InputStream inputStream) {
            this(null, inputStream, null);
        }

        private FileImpl(OutputStream outputStream) {
            this(null, null, outputStream);
        }

        public String tojstring() {
            return "file (" + this.hashCode() + ")";
        }

        public boolean isstdfile() {
            return this.file == null;
        }

        public void close() throws IOException {
            this.closed = true;
            if (this.file != null) {
                this.file.close();
            }
        }

        public void flush() throws IOException {
            if (this.os != null) {
                this.os.flush();
            }
        }

        public void write(LuaString luaString) throws IOException {
            if (this.os != null) {
                this.os.write(luaString.m_bytes, luaString.m_offset, luaString.m_length);
            } else if (this.file != null) {
                this.file.write(luaString.m_bytes, luaString.m_offset, luaString.m_length);
            } else {
                JseIoLib.notimplemented();
            }
            if (this.nobuffer) {
                this.flush();
            }
        }

        public boolean isclosed() {
            return this.closed;
        }

        public int seek(String string, int n) throws IOException {
            if (this.file != null) {
                if ("set".equals(string)) {
                    this.file.seek(n);
                } else if ("end".equals(string)) {
                    this.file.seek(this.file.length() + (long)n);
                } else {
                    this.file.seek(this.file.getFilePointer() + (long)n);
                }
                return (int)this.file.getFilePointer();
            }
            JseIoLib.notimplemented();
            return 0;
        }

        public void setvbuf(String string, int n) {
            this.nobuffer = "no".equals(string);
        }

        public int remaining() throws IOException {
            return this.file != null ? (int)(this.file.length() - this.file.getFilePointer()) : -1;
        }

        public int peek() throws IOException {
            if (this.is != null) {
                this.is.mark(1);
                int n = this.is.read();
                this.is.reset();
                return n;
            }
            if (this.file != null) {
                long l = this.file.getFilePointer();
                int n = this.file.read();
                this.file.seek(l);
                return n;
            }
            JseIoLib.notimplemented();
            return 0;
        }

        public int read() throws IOException {
            if (this.is != null) {
                return this.is.read();
            }
            if (this.file != null) {
                return this.file.read();
            }
            JseIoLib.notimplemented();
            return 0;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.file != null) {
                return this.file.read(byArray, n, n2);
            }
            if (this.is != null) {
                return this.is.read(byArray, n, n2);
            }
            JseIoLib.notimplemented();
            return n2;
        }
    }
}

