/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class WorldUtil {
    public static boolean isBlockInWorld(World world, BlockPos pos) {
        return pos.func_177956_o() >= 0 && pos.func_177956_o() < world.func_72800_K();
    }

    public static boolean isLiquidBlock(World world, BlockPos pos) {
        return WorldUtil.isBlockInWorld(world, pos) && world.func_180495_p(pos).func_185904_a().func_76224_d();
    }

    public static BlockPos moveCoords(BlockPos pos, EnumFacing dir) {
        return pos.func_177972_a(dir);
    }

    public static Pair<Entity, Vec3d> rayTraceEntities(World world, Vec3d vecStart, Vec3d vecDir, double distance) {
        Vec3d vecEnd = vecStart.func_72441_c(vecDir.field_72450_a * distance, vecDir.field_72448_b * distance, vecDir.field_72449_c * distance);
        RayTraceResult result = world.func_72933_a(vecStart.func_72441_c(0.0, 0.0, 0.0), vecEnd.func_72441_c(0.0, 0.0, 0.0));
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            distance = vecStart.func_72438_d(result.field_72307_f);
            vecEnd = vecStart.func_72441_c(vecDir.field_72450_a * distance, vecDir.field_72448_b * distance, vecDir.field_72449_c * distance);
        }
        float xStretch = Math.abs(vecDir.field_72450_a) > 0.25 ? 0.0f : 1.0f;
        float yStretch = Math.abs(vecDir.field_72448_b) > 0.25 ? 0.0f : 1.0f;
        float zStretch = Math.abs(vecDir.field_72449_c) > 0.25 ? 0.0f : 1.0f;
        AxisAlignedBB bigBox = new AxisAlignedBB(Math.min(vecStart.field_72450_a, vecEnd.field_72450_a) - (double)(0.375f * xStretch), Math.min(vecStart.field_72448_b, vecEnd.field_72448_b) - (double)(0.375f * yStretch), Math.min(vecStart.field_72449_c, vecEnd.field_72449_c) - (double)(0.375f * zStretch), Math.max(vecStart.field_72450_a, vecEnd.field_72450_a) + (double)(0.375f * xStretch), Math.max(vecStart.field_72448_b, vecEnd.field_72448_b) + (double)(0.375f * yStretch), Math.max(vecStart.field_72449_c, vecEnd.field_72449_c) + (double)(0.375f * zStretch));
        Entity closest = null;
        double closestDist = 99.0;
        List list = world.func_72839_b(null, bigBox);
        for (Entity entity : list) {
            AxisAlignedBB littleBox;
            if (entity.field_70128_L || !entity.func_70067_L() || (littleBox = entity.func_174813_aQ()) == null && (littleBox = entity.func_70046_E()) == null) continue;
            if (littleBox.func_72318_a(vecStart)) {
                closest = entity;
                closestDist = 0.0;
                continue;
            }
            RayTraceResult littleBoxResult = littleBox.func_72327_a(vecStart, vecEnd);
            if (littleBoxResult != null) {
                double dist = vecStart.func_72438_d(littleBoxResult.field_72307_f);
                if (closest != null && !(dist <= closestDist)) continue;
                closest = entity;
                closestDist = dist;
                continue;
            }
            if (!littleBox.func_72326_a(bigBox) || closest != null) continue;
            closest = entity;
            closestDist = distance;
        }
        if (closest != null && closestDist <= distance) {
            Vec3d closestPos = vecStart.func_72441_c(vecDir.field_72450_a * closestDist, vecDir.field_72448_b * closestDist, vecDir.field_72449_c * closestDist);
            return Pair.of((Object)closest, (Object)closestPos);
        }
        return null;
    }

    public static void dropItemStack(@Nonnull ItemStack stack, World world, BlockPos pos) {
        WorldUtil.dropItemStack(stack, world, pos, null);
    }

    public static void dropItemStack(@Nonnull ItemStack stack, World world, BlockPos pos, EnumFacing direction) {
        double zDir;
        double yDir;
        double xDir;
        if (direction != null) {
            xDir = direction.func_82601_c();
            yDir = direction.func_96559_d();
            zDir = direction.func_82599_e();
        } else {
            xDir = 0.0;
            yDir = 0.0;
            zDir = 0.0;
        }
        double xPos = (double)pos.func_177958_n() + 0.5 + xDir * 0.4;
        double yPos = (double)pos.func_177956_o() + 0.5 + yDir * 0.4;
        double zPos = (double)pos.func_177952_p() + 0.5 + zDir * 0.4;
        WorldUtil.dropItemStack(stack, world, xPos, yPos, zPos, xDir, yDir, zDir);
    }

    public static void dropItemStack(@Nonnull ItemStack stack, World world, double xPos, double yPos, double zPos) {
        WorldUtil.dropItemStack(stack, world, xPos, yPos, zPos, 0.0, 0.0, 0.0);
    }

    public static void dropItemStack(@Nonnull ItemStack stack, World world, double xPos, double yPos, double zPos, double xDir, double yDir, double zDir) {
        EntityItem entityItem = new EntityItem(world, xPos, yPos, zPos, stack.func_77946_l());
        entityItem.field_70159_w = xDir * 0.7 + (double)world.field_73012_v.nextFloat() * 0.2 - 0.1;
        entityItem.field_70181_x = yDir * 0.7 + (double)world.field_73012_v.nextFloat() * 0.2 - 0.1;
        entityItem.field_70179_y = zDir * 0.7 + (double)world.field_73012_v.nextFloat() * 0.2 - 0.1;
        entityItem.func_174869_p();
        world.func_72838_d((Entity)entityItem);
    }
}

