/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.ComputerCraft;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class IDAssigner {
    private IDAssigner() {
    }

    public static int getNextIDFromDirectory(File dir) {
        return IDAssigner.getNextID(dir, true);
    }

    public static int getNextIDFromFile(File file) {
        return IDAssigner.getNextID(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNextID(File location, boolean directory) {
        File lastidFile;
        if (directory) {
            location.mkdirs();
            lastidFile = new File(location, "lastid.txt");
        } else {
            location.getParentFile().mkdirs();
            lastidFile = location;
        }
        int id = 0;
        if (!lastidFile.exists()) {
            if (directory && location.exists() && location.isDirectory()) {
                String[] contents;
                for (String content : contents = location.list()) {
                    try {
                        int number = Integer.parseInt(content);
                        id = Math.max(number + 1, id);
                    }
                    catch (NumberFormatException e) {
                        ComputerCraft.log.error("Unexpected file '" + content + "' in '" + location.getAbsolutePath() + "'", (Throwable)e);
                    }
                }
            }
        } else {
            String idString;
            try {
                InputStreamReader isr;
                FileInputStream in = new FileInputStream(lastidFile);
                try {
                    isr = new InputStreamReader((InputStream)in, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    isr = new InputStreamReader(in);
                }
                BufferedReader br = new BufferedReader(isr);
                try {
                    idString = br.readLine();
                }
                finally {
                    br.close();
                }
            }
            catch (IOException e) {
                ComputerCraft.log.error("Cannot open ID file '" + lastidFile + "'", (Throwable)e);
                return 0;
            }
            try {
                id = Integer.parseInt(idString) + 1;
            }
            catch (NumberFormatException e) {
                ComputerCraft.log.error("Cannot parse ID file '" + lastidFile + "', perhaps it is corrupt?", (Throwable)e);
                return 0;
            }
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(lastidFile, false));
            out.write(Integer.toString(id));
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            ComputerCraft.log.error("An error occured while trying to create the computer folder. Please check you have relevant permissions.", (Throwable)e);
        }
        return id;
    }
}

