/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.common.IDirectionalTile;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public class DirectionUtil {
    public static EnumFacing rotateRight(EnumFacing dir) {
        if (dir.func_176740_k() != EnumFacing.Axis.Y) {
            return dir.func_176746_e();
        }
        return dir;
    }

    public static EnumFacing rotateLeft(EnumFacing dir) {
        if (dir.func_176740_k() != EnumFacing.Axis.Y) {
            return dir.func_176735_f();
        }
        return dir;
    }

    public static EnumFacing rotate180(EnumFacing dir) {
        if (dir.func_176740_k() != EnumFacing.Axis.Y) {
            return dir.func_176734_d();
        }
        return dir;
    }

    public static int toLocal(IDirectionalTile directional, EnumFacing dir) {
        EnumFacing front = directional.getDirection();
        if (front.func_176740_k() == EnumFacing.Axis.Y) {
            front = EnumFacing.NORTH;
        }
        EnumFacing back = DirectionUtil.rotate180(front);
        EnumFacing left = DirectionUtil.rotateLeft(front);
        EnumFacing right = DirectionUtil.rotateRight(front);
        if (dir == front) {
            return 3;
        }
        if (dir == back) {
            return 2;
        }
        if (dir == left) {
            return 5;
        }
        if (dir == right) {
            return 4;
        }
        if (dir == EnumFacing.UP) {
            return 1;
        }
        return 0;
    }

    public static EnumFacing fromEntityRot(EntityLivingBase player) {
        int rot = MathHelper.func_76141_d((float)(player.field_70177_z / 90.0f + 0.5f)) & 3;
        switch (rot) {
            case 0: {
                return EnumFacing.NORTH;
            }
            case 1: {
                return EnumFacing.EAST;
            }
            case 2: {
                return EnumFacing.SOUTH;
            }
            case 3: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.NORTH;
    }

    public static float toYawAngle(EnumFacing dir) {
        switch (dir) {
            case NORTH: {
                return 180.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
            case WEST: {
                return 90.0f;
            }
            case EAST: {
                return 270.0f;
            }
        }
        return 0.0f;
    }

    public static float toPitchAngle(EnumFacing dir) {
        switch (dir) {
            case DOWN: {
                return 90.0f;
            }
            case UP: {
                return 270.0f;
            }
        }
        return 0.0f;
    }
}

